/*
 * Copyright 2016-2021 The jetcd authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in alluxio.shaded.client.com.liance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package alluxio.shaded.client.io.etcd.jetcd.lease;

import alluxio.shaded.client.io.etcd.jetcd.impl.AbstractResponse;

public class LeaseKeepAliveResponse extends AbstractResponse<alluxio.shaded.client.io.etcd.jetcd.api.LeaseKeepAliveResponse> {

    public LeaseKeepAliveResponse(alluxio.shaded.client.io.etcd.jetcd.api.LeaseKeepAliveResponse response) {
        super(response, response.getHeader());
    }

    /**
     * Returns the lease ID from the keep alive request.
     *
     * @return the id.
     */
    public long getID() {
        return getResponse().getID();
    }

    /**
     * Returns the new time-to-live for the lease.
     *
     * @return the ttl.
     */
    public long getTTL() {
        return getResponse().getTTL();
    }
}
