/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.vertx.core.net.impl.transport;

import alluxio.shaded.client.io.netty.bootstrap.Bootstrap;
import alluxio.shaded.client.io.netty.bootstrap.ServerBootstrap;
import alluxio.shaded.client.io.netty.channel.Channel;
import alluxio.shaded.client.io.netty.channel.ChannelFactory;
import alluxio.shaded.client.io.netty.channel.EventLoopGroup;
import alluxio.shaded.client.io.netty.channel.ServerChannel;
import alluxio.shaded.client.io.netty.channel.epoll.Epoll;
import alluxio.shaded.client.io.netty.channel.epoll.EpollChannelOption;
import alluxio.shaded.client.io.netty.channel.epoll.EpollDatagramChannel;
import alluxio.shaded.client.io.netty.channel.epoll.EpollDomainSocketChannel;
import alluxio.shaded.client.io.netty.channel.epoll.EpollEventLoopGroup;
import alluxio.shaded.client.io.netty.channel.epoll.EpollServerDomainSocketChannel;
import alluxio.shaded.client.io.netty.channel.epoll.EpollServerSocketChannel;
import alluxio.shaded.client.io.netty.channel.epoll.EpollSocketChannel;
import alluxio.shaded.client.io.netty.channel.socket.DatagramChannel;
import alluxio.shaded.client.io.netty.channel.socket.InternetProtocolFamily;
import alluxio.shaded.client.io.netty.channel.unix.DomainSocketAddress;
import alluxio.shaded.client.io.vertx.core.datagram.DatagramSocketOptions;
import alluxio.shaded.client.io.vertx.core.net.ClientOptionsBase;
import alluxio.shaded.client.io.vertx.core.net.NetServerOptions;
import alluxio.shaded.client.io.vertx.core.net.SocketAddress;
import alluxio.shaded.client.io.vertx.core.net.impl.SocketAddressImpl;
import alluxio.shaded.client.io.vertx.core.net.impl.transport.Transport;
import java.util.concurrent.ThreadFactory;

class EpollTransport
extends Transport {
    private static volatile int pendingFastOpenRequestsThreshold = 256;

    public static int getPendingFastOpenRequestsThreshold() {
        return pendingFastOpenRequestsThreshold;
    }

    public static void setPendingFastOpenRequestsThreshold(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Invalid " + value);
        }
        pendingFastOpenRequestsThreshold = value;
    }

    EpollTransport() {
    }

    @Override
    public java.net.SocketAddress convert(SocketAddress address) {
        if (address.isDomainSocket()) {
            return new DomainSocketAddress(address.path());
        }
        return super.convert(address);
    }

    @Override
    public SocketAddress convert(java.net.SocketAddress address) {
        if (address instanceof DomainSocketAddress) {
            return new SocketAddressImpl(((DomainSocketAddress)address).path());
        }
        return super.convert(address);
    }

    @Override
    public boolean isAvailable() {
        return Epoll.isAvailable();
    }

    @Override
    public Throwable unavailabilityCause() {
        return Epoll.unavailabilityCause();
    }

    @Override
    public EventLoopGroup eventLoopGroup(int type, int nThreads, ThreadFactory threadFactory, int ioRatio) {
        EpollEventLoopGroup eventLoopGroup = new EpollEventLoopGroup(nThreads, threadFactory);
        eventLoopGroup.setIoRatio(ioRatio);
        return eventLoopGroup;
    }

    @Override
    public DatagramChannel datagramChannel() {
        return new EpollDatagramChannel();
    }

    @Override
    public DatagramChannel datagramChannel(InternetProtocolFamily family) {
        return new EpollDatagramChannel();
    }

    @Override
    public ChannelFactory<? extends Channel> channelFactory(boolean domainSocket) {
        if (domainSocket) {
            return EpollDomainSocketChannel::new;
        }
        return EpollSocketChannel::new;
    }

    @Override
    public ChannelFactory<? extends ServerChannel> serverChannelFactory(boolean domainSocket) {
        if (domainSocket) {
            return EpollServerDomainSocketChannel::new;
        }
        return EpollServerSocketChannel::new;
    }

    @Override
    public void configure(DatagramChannel channel, DatagramSocketOptions options) {
        channel.config().setOption(EpollChannelOption.SO_REUSEPORT, options.isReusePort());
        super.configure(channel, options);
    }

    @Override
    public void configure(NetServerOptions options, boolean domainSocket, ServerBootstrap bootstrap) {
        if (!domainSocket) {
            bootstrap.option(EpollChannelOption.SO_REUSEPORT, options.isReusePort());
            if (options.isTcpFastOpen()) {
                bootstrap.option(EpollChannelOption.TCP_FASTOPEN, options.isTcpFastOpen() ? pendingFastOpenRequestsThreshold : 0);
            }
            bootstrap.childOption(EpollChannelOption.TCP_QUICKACK, options.isTcpQuickAck());
            bootstrap.childOption(EpollChannelOption.TCP_CORK, options.isTcpCork());
        }
        super.configure(options, domainSocket, bootstrap);
    }

    @Override
    public void configure(ClientOptionsBase options, boolean domainSocket, Bootstrap bootstrap) {
        if (!domainSocket) {
            if (options.isTcpFastOpen()) {
                bootstrap.option(EpollChannelOption.TCP_FASTOPEN_CONNECT, options.isTcpFastOpen());
            }
            bootstrap.option(EpollChannelOption.TCP_USER_TIMEOUT, options.getTcpUserTimeout());
            bootstrap.option(EpollChannelOption.TCP_QUICKACK, options.isTcpQuickAck());
            bootstrap.option(EpollChannelOption.TCP_CORK, options.isTcpCork());
        }
        super.configure(options, domainSocket, bootstrap);
    }
}

