package alluxio.shaded.client.io.etcd.jetcd.api;

import static alluxio.shaded.client.io.etcd.jetcd.api.WatchGrpc.getServiceDescriptor;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncUnaryCall;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static alluxio.shaded.client.io.grpc.stub.ServerCalls.asyncBidiStreamingCall;


@alluxio.shaded.client.javax.annotation.Generated(
value = "by VertxGrpc generator",
alluxio.shaded.client.com.ents = "Source: rpc.proto")
public final class VertxWatchGrpc {
    private VertxWatchGrpc() {}

    public static WatchVertxStub newVertxStub(alluxio.shaded.client.io.grpc.Channel channel) {
        return new WatchVertxStub(channel);
    }

    
    public static final class WatchVertxStub extends alluxio.shaded.client.io.grpc.stub.AbstractStub<WatchVertxStub> {
        private final alluxio.shaded.client.io.vertx.core.impl.ContextInternal ctx;
        private WatchGrpc.WatchStub delegateStub;

        private WatchVertxStub(alluxio.shaded.client.io.grpc.Channel channel) {
            super(channel);
            delegateStub = WatchGrpc.newStub(channel);
            this.ctx = (alluxio.shaded.client.io.vertx.core.impl.ContextInternal) alluxio.shaded.client.io.vertx.core.Vertx.currentContext();
        }

        private WatchVertxStub(alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
            super(channel, callOptions);
            delegateStub = WatchGrpc.newStub(channel).build(channel, callOptions);
            this.ctx = (alluxio.shaded.client.io.vertx.core.impl.ContextInternal) alluxio.shaded.client.io.vertx.core.Vertx.currentContext();
        }

        @Override
        protected WatchVertxStub build(alluxio.shaded.client.io.grpc.Channel channel, alluxio.shaded.client.io.grpc.CallOptions callOptions) {
            return new WatchVertxStub(channel, callOptions);
        }

        /**
         * <pre>
         *  Range gets the keys in the range from the key-value store.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.WatchResponse> progress(alluxio.shaded.client.io.etcd.jetcd.api.WatchProgressRequest request) {
            return alluxio.shaded.client.io.vertx.grpc.stub.ClientCalls.oneToOne(ctx, request, delegateStub::progress);
        }

        /**
         * <pre>
         *  Put puts the given key into the key-value store.
         *  A put request increments the revision of the key-value store
         *  and generates one event in the event history.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.streams.ReadStream<alluxio.shaded.client.io.etcd.jetcd.api.WatchResponse> watch(alluxio.shaded.client.io.vertx.core.Handler<alluxio.shaded.client.io.vertx.core.streams.WriteStream<alluxio.shaded.client.io.etcd.jetcd.api.WatchRequest>> hdlr) {
            return alluxio.shaded.client.io.vertx.grpc.stub.ClientCalls.manyToMany(ctx, hdlr, delegateStub::watch);
        }
    }

    
    public static abstract class WatchVertxImplBase implements alluxio.shaded.client.io.grpc.BindableService {
        private String alluxio.shaded.client.com.ression;

        /**
         * Set whether the server will try to use a alluxio.shaded.client.com.ressed response.
         *
         * @param alluxio.shaded.client.com.ression the alluxio.shaded.client.com.ression, e.g {@code gzip}
         */
        public WatchVertxImplBase withCompression(String alluxio.shaded.client.com.ression) {
            this.alluxio.shaded.client.com.ression = alluxio.shaded.client.com.ression;
            return this;
        }

        /**
         * <pre>
         *  Range gets the keys in the range from the key-value store.
         * </pre>
         */
        public alluxio.shaded.client.io.vertx.core.Future<alluxio.shaded.client.io.etcd.jetcd.api.WatchResponse> progress(alluxio.shaded.client.io.etcd.jetcd.api.WatchProgressRequest request) {
            throw new alluxio.shaded.client.io.grpc.StatusRuntimeException(alluxio.shaded.client.io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Put puts the given key into the key-value store.
         *  A put request increments the revision of the key-value store
         *  and generates one event in the event history.
         * </pre>
         */
        public void watch(alluxio.shaded.client.io.vertx.core.streams.ReadStream<alluxio.shaded.client.io.etcd.jetcd.api.WatchRequest> request, alluxio.shaded.client.io.vertx.core.streams.WriteStream<alluxio.shaded.client.io.etcd.jetcd.api.WatchResponse> response) {
            throw new alluxio.shaded.client.io.grpc.StatusRuntimeException(alluxio.shaded.client.io.grpc.Status.UNIMPLEMENTED);
        }

        @java.lang.Override public final alluxio.shaded.client.io.grpc.ServerServiceDefinition bindService() {
            return alluxio.shaded.client.io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
                    .addMethod(
                            alluxio.shaded.client.io.etcd.jetcd.api.WatchGrpc.getProgressMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            alluxio.shaded.client.io.etcd.jetcd.api.WatchProgressRequest,
                                            alluxio.shaded.client.io.etcd.jetcd.api.WatchResponse>(
                                            this, METHODID_PROGRESS, alluxio.shaded.client.com.ression)))
                    .addMethod(
                            alluxio.shaded.client.io.etcd.jetcd.api.WatchGrpc.getWatchMethod(),
                            asyncBidiStreamingCall(
                                    new MethodHandlers<
                                            alluxio.shaded.client.io.etcd.jetcd.api.WatchRequest,
                                            alluxio.shaded.client.io.etcd.jetcd.api.WatchResponse>(
                                            this, METHODID_WATCH, alluxio.shaded.client.com.ression)))
                    .build();
        }
    }

    private static final int METHODID_PROGRESS = 0;
    private static final int METHODID_WATCH = 1;

    private static final class MethodHandlers<Req, Resp> implements
            alluxio.shaded.client.io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
            alluxio.shaded.client.io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
            alluxio.shaded.client.io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
            alluxio.shaded.client.io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {

        private final WatchVertxImplBase serviceImpl;
        private final int methodId;
        private final String alluxio.shaded.client.com.ression;

        MethodHandlers(WatchVertxImplBase serviceImpl, int methodId, String alluxio.shaded.client.com.ression) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
            this.alluxio.shaded.client.com.ression = alluxio.shaded.client.com.ression;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public void invoke(Req request, alluxio.shaded.client.io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch (methodId) {
                case METHODID_PROGRESS:
                    alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.oneToOne(
                            (alluxio.shaded.client.io.etcd.jetcd.api.WatchProgressRequest) request,
                            (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.WatchResponse>) responseObserver,
                            alluxio.shaded.client.com.ression,
                            serviceImpl::progress);
                    break;
                default:
                    throw new java.lang.AssertionError();
            }
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public alluxio.shaded.client.io.grpc.stub.StreamObserver<Req> invoke(alluxio.shaded.client.io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch (methodId) {
                case METHODID_WATCH:
                    return (alluxio.shaded.client.io.grpc.stub.StreamObserver<Req>) alluxio.shaded.client.io.vertx.grpc.stub.ServerCalls.manyToMany(
                            (alluxio.shaded.client.io.grpc.stub.StreamObserver<alluxio.shaded.client.io.etcd.jetcd.api.WatchResponse>) responseObserver,
                            alluxio.shaded.client.com.ression,
                            serviceImpl::watch);
                default:
                    throw new java.lang.AssertionError();
            }
        }
    }

}
