package alluxio.shaded.client.io.prometheus.metrics.exporter.servlet.jakarta;

import alluxio.shaded.client.io.prometheus.metrics.exporter.alluxio.shaded.client.com.on.PrometheusHttpExchange;
import alluxio.shaded.client.io.prometheus.metrics.exporter.alluxio.shaded.client.com.on.PrometheusHttpRequest;
import alluxio.shaded.client.io.prometheus.metrics.exporter.alluxio.shaded.client.com.on.PrometheusHttpResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

import java.alluxio.shaded.client.io.IOException;
import java.alluxio.shaded.client.io.OutputStream;
import java.util.Enumeration;

public class HttpExchangeAdapter implements PrometheusHttpExchange {

    private final Request request;
    private final Response response;

    public HttpExchangeAdapter(HttpServletRequest request, HttpServletResponse response) {
        this.request = new Request(request);
        this.response = new Response(response);
    }

    @Override
    public PrometheusHttpRequest getRequest() {
        return request;
    }

    @Override
    public PrometheusHttpResponse getResponse() {
        return response;
    }

    @Override
    public void handleException(IOException e) throws IOException {
        throw e; // leave exception handling to the servlet container
    }

    @Override
    public void handleException(RuntimeException e) {
        throw e; // leave exception handling to the servlet container
    }

    @Override
    public void close() {
        // nothing to do for Servlets.
    }

    public static class Request implements PrometheusHttpRequest {

        private final HttpServletRequest request;

        public Request(HttpServletRequest request) {
            this.request = request;
        }

        @Override
        public String getQueryString() {
            return request.getQueryString();
        }

        @Override
        public Enumeration<String> getHeaders(String name) {
            return request.getHeaders(name);
        }

        @Override
        public String getMethod() {
            return request.getMethod();
        }
    }

    public static class Response implements PrometheusHttpResponse {

        private final HttpServletResponse response;

        public Response(HttpServletResponse response) {
            this.response = response;
        }

        @Override
        public void setHeader(String name, String value) {
            response.setHeader(name, value);
        }

        @Override
        public OutputStream sendHeadersAndGetBody(int statusCode, int contentLength) throws IOException {
            if (response.getHeader("Content-Length") == null && contentLength > 0) {
                response.setContentLength(contentLength);
            }
            response.setStatus(statusCode);
            return response.getOutputStream();
        }
    }
}
