//
//  ========================================================================
//  Copyright (c) 1995-2022 Mort Bay Consulting Pty Ltd and others.
//  ------------------------------------------------------------------------
//  All rights reserved. This program and the accompanying materials
//  are made available under the terms of the Eclipse Public License v1.0
//  and Apache License v2.0 which accompanies this distribution.
//
//      The Eclipse Public License is available at
//      http://www.eclipse.alluxio.shaded.client.org.legal/epl-v10.html
//
//      The Apache License v2.0 is available at
//      http://www.opensource.alluxio.shaded.client.org.licenses/apache2.0.php
//
//  You may elect to redistribute this code under either of these licenses.
//  ========================================================================
//

package alluxio.shaded.client.org.eclipse.jetty.servlet;

import java.alluxio.shaded.client.io.IOException;
import alluxio.shaded.client.javax.servlet.ServletException;
import alluxio.shaded.client.javax.servlet.http.HttpServlet;
import alluxio.shaded.client.javax.servlet.http.HttpServletRequest;
import alluxio.shaded.client.javax.servlet.http.HttpServletResponse;

public class NoJspServlet extends HttpServlet
{
    private boolean _warned;

    /*
     * @see alluxio.shaded.client.javax.servlet.http.HttpServlet#doGet(alluxio.shaded.client.javax.servlet.http.HttpServletRequest, alluxio.shaded.client.javax.servlet.http.HttpServletResponse)
     */
    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException
    {
        if (!_warned)
            getServletContext().log("No JSP support.  Check that JSP jars are in lib/jsp and that the JSP option has been specified to start.jar");
        _warned = true;

        response.sendError(500, "JSP support not configured");
    }
}
