/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file;

import alluxio.client.hive.HiveCacheContext;
import alluxio.client.quota.CacheQuota;
import alluxio.client.quota.CacheScope;
import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.javax.annotation.Nullable;
import java.util.Objects;

public class CacheContext {
    private CacheQuota mCacheQuota = CacheQuota.UNLIMITED;
    private CacheScope mCacheScope = CacheScope.GLOBAL;
    private HiveCacheContext mHiveCacheContext = null;
    private String mCacheIdentifier = null;
    private boolean mIsTemporary = false;

    public static CacheContext defaults() {
        return new CacheContext();
    }

    protected CacheContext() {
    }

    @Nullable
    public String getCacheIdentifier() {
        return this.mCacheIdentifier;
    }

    @Nullable
    public HiveCacheContext getHiveCacheContext() {
        return this.mHiveCacheContext;
    }

    public CacheQuota getCacheQuota() {
        return this.mCacheQuota;
    }

    public CacheScope getCacheScope() {
        return this.mCacheScope;
    }

    public CacheContext setCacheIdentifier(String identifier) {
        this.mCacheIdentifier = identifier;
        return this;
    }

    public CacheContext setCacheQuota(CacheQuota cacheQuota) {
        this.mCacheQuota = cacheQuota;
        return this;
    }

    public CacheContext setCacheScope(CacheScope cacheScope) {
        this.mCacheScope = cacheScope;
        return this;
    }

    public CacheContext setHiveCacheContext(HiveCacheContext hiveCacheContext) {
        this.mHiveCacheContext = hiveCacheContext;
        return this;
    }

    public boolean isTemporary() {
        return this.mIsTemporary;
    }

    public CacheContext setTemporary(boolean isTemporary) {
        this.mIsTemporary = isTemporary;
        return this;
    }

    public void incrementCounter(String name, long value) {
    }

    public void incrementCounter(String name, StatsUnit unit, long value) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheContext that = (CacheContext)o;
        return Objects.equals(this.mCacheIdentifier, that.mCacheIdentifier) && Objects.equals(this.mHiveCacheContext, that.mHiveCacheContext) && Objects.equals(this.mCacheQuota, that.mCacheQuota) && Objects.equals(this.mCacheScope, that.mCacheScope);
    }

    public int hashCode() {
        return Objects.hash(this.mCacheQuota, this.mCacheScope, this.mCacheIdentifier, this.mHiveCacheContext, this.mIsTemporary);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("cacheIdentifier", this.mCacheIdentifier).add("cacheQuota", this.mCacheQuota).add("cacheScope", this.mCacheScope).add("hiveCacheContext", this.mHiveCacheContext).add("isTemporary", this.mIsTemporary).toString();
    }

    public static enum StatsUnit {
        NANO,
        BYTE;

    }
}

