/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.dora;

import alluxio.client.block.BlockWorkerInfo;
import alluxio.conf.AlluxioConfiguration;
import alluxio.membership.WorkerClusterView;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.wire.WorkerInfo;
import alluxio.wire.WorkerNetAddress;
import alluxio.wire.WorkerState;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteWorkerList {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteWorkerList.class);
    private static RemoteWorkerList sInstance;
    private final List<WorkerInfo> mRemoteWorkers;
    private int mNextIndex = 0;

    private RemoteWorkerList(WorkerClusterView blockWorkerInfos, AlluxioConfiguration conf) {
        String userHostname = NetworkAddressUtils.getClientHostName(conf);
        this.mRemoteWorkers = new ArrayList<WorkerInfo>();
        for (WorkerInfo worker : blockWorkerInfos) {
            WorkerNetAddress workerAddr = worker.getAddress();
            if (workerAddr == null || userHostname.equals(workerAddr.getHost())) continue;
            this.mRemoteWorkers.add(worker);
        }
        this.mRemoteWorkers.sort(Comparator.comparing(a -> a.getAddress().getHost()));
        LOG.debug("{} remote workers found on {}", (Object)this.mRemoteWorkers.size(), (Object)userHostname);
    }

    public static synchronized RemoteWorkerList getInstance(WorkerClusterView blockWorkerInfos, AlluxioConfiguration conf) {
        if (sInstance == null) {
            sInstance = new RemoteWorkerList(blockWorkerInfos, conf);
        }
        return sInstance;
    }

    public synchronized BlockWorkerInfo findNextWorker() {
        WorkerInfo nextWorker = this.mRemoteWorkers.get(this.mNextIndex);
        ++this.mNextIndex;
        if (this.mNextIndex >= this.mRemoteWorkers.size()) {
            this.mNextIndex -= this.mRemoteWorkers.size();
        }
        return new BlockWorkerInfo(nextWorker.getIdentity(), nextWorker.getAddress(), nextWorker.getCapacityBytes(), nextWorker.getUsedBytes(), nextWorker.getState() == WorkerState.LIVE);
    }
}

