/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.io.vertx.core.net;

import alluxio.shaded.client.io.vertx.core.Vertx;
import alluxio.shaded.client.io.vertx.core.net.TrustManagerFactoryWrapper;
import alluxio.shaded.client.io.vertx.core.net.TrustOptions;
import alluxio.shaded.client.javax.net.ssl.TrustManager;
import alluxio.shaded.client.javax.net.ssl.TrustManagerFactory;
import java.util.function.Function;

class TrustManagerFactoryOptions
implements TrustOptions {
    private final TrustManagerFactory trustManagerFactory;

    TrustManagerFactoryOptions(TrustManagerFactory trustManagerFactory) {
        if (trustManagerFactory == null || trustManagerFactory.getTrustManagers() == null || trustManagerFactory.getTrustManagers().length == 0) {
            throw new IllegalArgumentException("TrustManagerFactory is not present or is not initialized yet");
        }
        this.trustManagerFactory = trustManagerFactory;
    }

    TrustManagerFactoryOptions(TrustManager trustManager) {
        this(new TrustManagerFactoryWrapper(trustManager));
    }

    private TrustManagerFactoryOptions(TrustManagerFactoryOptions other) {
        this.trustManagerFactory = other.trustManagerFactory;
    }

    @Override
    public TrustOptions copy() {
        return new TrustManagerFactoryOptions(this);
    }

    @Override
    public TrustManagerFactory getTrustManagerFactory(Vertx vertx) {
        return this.trustManagerFactory;
    }

    @Override
    public Function<String, TrustManager[]> trustManagerMapper(Vertx vertx) {
        return serverName -> this.trustManagerFactory.getTrustManagers();
    }
}

