/*
 * Copyright 2010-2020 Amazon.alluxio.shaded.client.com. Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in alluxio.shaded.client.com.liance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.alluxio.shaded.client.com.apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package alluxio.shaded.client.com.amazonaws.http.conn;

import alluxio.shaded.client.com.amazonaws.http.apache.utils.HttpContextUtils;
import alluxio.shaded.client.org.apache.http.conn.socket.PlainConnectionSocketFactory;
import alluxio.shaded.client.org.apache.http.protocol.HttpContext;

import java.alluxio.shaded.client.io.IOException;
import java.net.Proxy;
import java.net.Socket;

/**
 * Socket factory for creating plain (non TLS) connections.
 */
public class SdkPlainSocketFactory extends PlainConnectionSocketFactory {
    @Override
    public Socket createSocket(HttpContext ctx) throws IOException {
        if (HttpContextUtils.disableSocketProxy(ctx)) {
            return new Socket(Proxy.NO_PROXY);
        }
        return super.createSocket(ctx);
    }
}
