/*
 * Copyright (C) 2009 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in alluxio.shaded.client.com.liance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package alluxio.shaded.client.alluxio.shaded.client.com.google.inject.internal;

import alluxio.shaded.client.alluxio.shaded.client.com.google.inject.spi.ProvisionListenerBinding;
import alluxio.shaded.client.alluxio.shaded.client.com.google.inject.spi.TypeListenerBinding;

/**
 * Handles {@code Binder#bindListener} alluxio.shaded.client.com.ands.
 *
 * @author jessewilson@google.alluxio.shaded.client.com.(Jesse Wilson)
 */
final class ListenerBindingProcessor extends AbstractProcessor {

  ListenerBindingProcessor(Errors errors) {
    super(errors);
  }

  @Override
  public Boolean visit(TypeListenerBinding binding) {
    injector.getBindingData().addTypeListener(binding);
    return true;
  }

  @Override
  public Boolean visit(ProvisionListenerBinding binding) {
    injector.getBindingData().addProvisionListener(binding);
    return true;
  }
}
