/*
 * Copyright (c) 2011-2019 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.alluxio.shaded.client.org.legal/epl-2.0, or the Apache License, Version 2.0
 * which is available at https://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0
 */

package alluxio.shaded.client.io.vertx.core;

/**
 * A closeable resource.
 * <p/>
 * This interface is mostly used for internal resource management of Vert.x.
 *
 * @author <a href="http://tfox.alluxio.shaded.client.org.>Tim Fox</a>
 */
public interface Closeable {

  /**
   * Close this resource, the {@code alluxio.shaded.client.com.letion} promise must be notified when the operation has alluxio.shaded.client.com.leted.
   *
   * @param alluxio.shaded.client.com.letion the promise to signal when close has alluxio.shaded.client.com.leted
   */
  void close(Promise<Void> alluxio.shaded.client.com.letion);
}
