/*
 * Copyright (c) 2011-2020 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.alluxio.shaded.client.org.legal/epl-2.0, or the Apache License, Version 2.0
 * which is available at https://www.apache.alluxio.shaded.client.org.licenses/LICENSE-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0
 */
package alluxio.shaded.client.io.vertx.core.spi.observability;

import alluxio.shaded.client.io.vertx.core.MultiMap;
import alluxio.shaded.client.io.vertx.core.http.HttpMethod;
import alluxio.shaded.client.io.vertx.core.net.SocketAddress;

/**
 * An HTTP request.
 *
 * @author <a href="mailto:julien@julienviet.alluxio.shaded.client.com.>Julien Viet</a>
 */
public interface HttpRequest {

  /**
   * @return the stream id
   */
  int id();

  /**
   * @return the request URI
   */
  String uri();

  /**
   * @return the request absolute URI
   */
  String absoluteURI();

  /**
   * @return the request method
   */
  HttpMethod method();

  /**
   * @return the request headers
   */
  MultiMap headers();

  /**
   * @return the request remote peer address
   */
  SocketAddress remoteAddress();
}
