/*
 * Copyright 2010-2016 Amazon.alluxio.shaded.client.com. Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in alluxio.shaded.client.com.liance with the License.
 * A copy of the License is located at:
 *
 *     http://aws.amazon.alluxio.shaded.client.com.apache2.0/
 *
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific
 * language governing permissions and limitations under the License.
 */

package software.amazon.alluxio.shaded.client.io..impl;

import java.alluxio.shaded.client.io.InputStream;
import java.alluxio.shaded.client.io.Reader;
import java.util.Iterator;
import software.amazon.alluxio.shaded.client.io..IonContainer;
import software.amazon.alluxio.shaded.client.io..IonReader;
import software.amazon.alluxio.shaded.client.io..IonStruct;
import software.amazon.alluxio.shaded.client.io..IonSystem;
import software.amazon.alluxio.shaded.client.io..IonValue;
import software.amazon.alluxio.shaded.client.io..IonWriter;
import software.amazon.alluxio.shaded.client.io..SymbolTable;
import software.amazon.alluxio.shaded.client.io..system.IonSystemBuilder;

/**
 * @deprecated This is an internal API that is subject to change without notice.
 */
@Deprecated
public interface PrivateIonSystem
    extends IonSystem
{
    public SymbolTable newSharedSymbolTable(IonStruct alluxio.shaded.client.io.Rep);

    /**
     * TODO Must correct amznlabs/alluxio.shaded.client.io.-java#63 before exposing this or using from public API.
     */
    public Iterator<IonValue> systemIterate(String alluxio.shaded.client.io.Text);

    /**
     * TODO Must correct amznlabs/alluxio.shaded.client.io.-java#63 before exposing this or using from public API.
     */
    public Iterator<IonValue> systemIterate(Reader alluxio.shaded.client.io.Text);

    public Iterator<IonValue> systemIterate(byte[] alluxio.shaded.client.io.Data);

    /**
     * TODO Must correct amznlabs/alluxio.shaded.client.io.-java#63 before exposing this or using from public API.
     */
    public Iterator<IonValue> systemIterate(InputStream alluxio.shaded.client.io.Data);

    public IonReader newSystemReader(Reader alluxio.shaded.client.io.Text);

    public IonReader newSystemReader(byte[] alluxio.shaded.client.io.Data);

    public IonReader newSystemReader(byte[] alluxio.shaded.client.io.Data, int offset, int len);

    public IonReader newSystemReader(String alluxio.shaded.client.io.Text);

    public IonReader newSystemReader(InputStream alluxio.shaded.client.io.Data);

    public IonReader newSystemReader(IonValue value);


    public IonWriter newTreeWriter(IonContainer container);

    public IonWriter newTreeSystemWriter(IonContainer container);


    public boolean valueIsSharedSymbolTable(IonValue value);

    /**
     * Indicates whether writers built by this system may attempt to optimize
     * {@link IonWriter#writeValue(IonReader)} by copying raw source data.
     *
     * @see IonSystemBuilder#isStreamCopyOptimized()
     */
    public boolean isStreamCopyOptimized();
}
