/*
 * Decompiled with CFR 0.152.
 */
package alluxio.resource;

import alluxio.resource.CloseableResource;
import alluxio.resource.Pool;
import java.lang.ref.WeakReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledResource<T>
extends CloseableResource<T> {
    private static final Logger LOG = LoggerFactory.getLogger(PooledResource.class);
    protected final WeakReference<Pool<T>> mPool;
    protected final String mPoolDescription;

    public PooledResource(T resource, Pool<T> pool) {
        super(resource);
        this.mPool = new WeakReference<Pool<Pool<T>>>(pool);
        this.mPoolDescription = String.format("%s@%s", pool.getClass().getName(), Integer.toHexString(pool.hashCode())).intern();
    }

    @Override
    public void closeResource() {
        Pool pool = (Pool)this.mPool.get();
        if (pool != null) {
            pool.release(this.get());
        } else {
            Object leaked = this.get();
            String resType = leaked.getClass().getName();
            LOG.warn("resource of type {} leaked from pool {} which had been GCed before the resource could be released", (Object)resType, (Object)this.mPoolDescription);
            if (leaked instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)leaked).close();
                }
                catch (Exception e) {
                    throw new RuntimeException(String.format("failed to close leaked resource %s: %s", resType, e), e);
                }
            }
        }
    }
}

