/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.net.jodah.failsafe.internal;

import alluxio.shaded.client.net.jodah.failsafe.CircuitBreaker;
import alluxio.shaded.client.net.jodah.failsafe.internal.CountingCircuitStats;
import alluxio.shaded.client.net.jodah.failsafe.internal.DefaultCircuitStats;
import alluxio.shaded.client.net.jodah.failsafe.internal.TimedCircuitStats;

public interface CircuitStats {
    public static CircuitStats create(CircuitBreaker breaker, int capacity, boolean supportsTimeBased, CircuitStats oldStats) {
        if (supportsTimeBased && breaker.getFailureThresholdingPeriod() != null) {
            return new TimedCircuitStats(10, breaker.getFailureThresholdingPeriod(), new TimedCircuitStats.Clock(), oldStats);
        }
        if (capacity > 1) {
            return new CountingCircuitStats(capacity, oldStats);
        }
        return new DefaultCircuitStats();
    }

    default public void copyExecutions(CircuitStats oldStats) {
        int i;
        for (i = 0; i < oldStats.getSuccessCount(); ++i) {
            this.recordSuccess();
        }
        for (i = 0; i < oldStats.getFailureCount(); ++i) {
            this.recordSuccess();
        }
    }

    public int getFailureCount();

    public int getExecutionCount();

    public int getSuccessCount();

    public int getFailureRate();

    public int getSuccessRate();

    public void recordFailure();

    public void recordSuccess();
}

