/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.org.eclipse.jetty.util.ajax;

import alluxio.shaded.client.org.eclipse.jetty.util.ajax.JSON;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class JSONObjectConvertor
implements JSON.Convertor {
    private boolean _fromJSON;
    private Set _excluded = null;

    public JSONObjectConvertor() {
        this._fromJSON = false;
    }

    public JSONObjectConvertor(boolean fromJSON) {
        this._fromJSON = fromJSON;
    }

    public JSONObjectConvertor(boolean fromJSON, String[] excluded) {
        this._fromJSON = fromJSON;
        if (excluded != null) {
            this._excluded = new HashSet<String>(Arrays.asList(excluded));
        }
    }

    @Override
    public Object fromJSON(Map map) {
        if (this._fromJSON) {
            throw new UnsupportedOperationException();
        }
        return map;
    }

    @Override
    public void toJSON(Object obj, JSON.Output out) {
        try {
            Class<?> c = obj.getClass();
            if (this._fromJSON) {
                out.addClass(obj.getClass());
            }
            Method[] methods = obj.getClass().getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method m3 = methods[i];
                if (Modifier.isStatic(m3.getModifiers()) || m3.getParameterCount() != 0 || m3.getReturnType() == null || m3.getDeclaringClass() == Object.class) continue;
                String name = m3.getName();
                if (name.startsWith("is")) {
                    name = name.substring(2, 3).toLowerCase(Locale.ENGLISH) + name.substring(3);
                } else {
                    if (!name.startsWith("get")) continue;
                    name = name.substring(3, 4).toLowerCase(Locale.ENGLISH) + name.substring(4);
                }
                if (!this.includeField(name, obj, m3)) continue;
                out.add(name, m3.invoke(obj, (Object[])null));
            }
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected boolean includeField(String name, Object o, Method m3) {
        return this._excluded == null || !this._excluded.contains(name);
    }
}

