/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.job;

import alluxio.job.plan.PlanConfig;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class StressBenchConfig
implements PlanConfig {
    private static final long serialVersionUID = 7883915266950426997L;
    private static final String NAME = "StressBench";
    private final String mClassName;
    private final List<String> mArgs;
    private final long mStartDelayMs;
    private final int mClusterLimit;

    public StressBenchConfig(@JsonProperty(value="className") String className, @JsonProperty(value="args") List<String> args, @JsonProperty(value="startDelayMs") long startDelayMs, @JsonProperty(value="clusterLimit") int clusterLimit) {
        this.mClassName = (String)Preconditions.checkNotNull((Object)className, (Object)"className");
        this.mArgs = (List)Preconditions.checkNotNull(args, (Object)"args");
        this.mStartDelayMs = startDelayMs;
        this.mClusterLimit = clusterLimit;
    }

    public String getName() {
        return NAME;
    }

    public String getClassName() {
        return this.mClassName;
    }

    public List<String> getArgs() {
        return this.mArgs;
    }

    public long getStartDelayMs() {
        return this.mStartDelayMs;
    }

    public int getClusterLimit() {
        return this.mClusterLimit;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StressBenchConfig)) {
            return false;
        }
        StressBenchConfig that = (StressBenchConfig)obj;
        return Objects.equal((Object)this.mClassName, (Object)that.mClassName) && Objects.equal(this.mArgs, that.mArgs) && Objects.equal((Object)this.mStartDelayMs, (Object)that.mStartDelayMs) && Objects.equal((Object)this.mClusterLimit, (Object)that.mClusterLimit);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mClassName, this.mArgs, this.mStartDelayMs, this.mClusterLimit});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("className", (Object)this.mClassName).add("args", this.mArgs).add("startDelayMs", this.mStartDelayMs).add("clusterLimit", this.mClusterLimit).toString();
    }
}

