/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.master;

import alluxio.collections.Pair;
import alluxio.stress.Parameters;
import alluxio.stress.Summary;
import alluxio.stress.common.SummaryStatistics;
import alluxio.stress.graph.BarGraph;
import alluxio.stress.graph.Graph;
import alluxio.stress.graph.LineGraph;
import alluxio.stress.master.MasterBenchParameters;
import alluxio.stress.master.MasterBenchTaskResult;
import alluxio.stress.master.MasterBenchTaskResultStatistics;
import alluxio.stress.master.Operation;
import com.google.common.base.Splitter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.DataFormatException;

public final class MasterBenchSummary
implements Summary {
    private long mDurationMs;
    private long mEndTimeMs;
    private MasterBenchParameters mParameters;
    private List<String> mNodes;
    private Map<String, List<String>> mErrors;
    private float mThroughput;
    private SummaryStatistics mStatistics;
    private Map<String, SummaryStatistics> mStatisticsPerMethod;

    public MasterBenchSummary() {
    }

    public MasterBenchSummary(MasterBenchTaskResult mergedTaskResults, List<String> nodes, Map<String, List<String>> errors) throws DataFormatException {
        this.mStatistics = mergedTaskResults.getStatistics().toMasterBenchSummaryStatistics();
        this.mStatisticsPerMethod = new HashMap<String, SummaryStatistics>();
        for (Map.Entry<String, MasterBenchTaskResultStatistics> entry : mergedTaskResults.getStatisticsPerMethod().entrySet()) {
            String key = entry.getKey();
            MasterBenchTaskResultStatistics value = entry.getValue();
            this.mStatisticsPerMethod.put(key, value.toMasterBenchSummaryStatistics());
        }
        this.mDurationMs = mergedTaskResults.getEndMs() - mergedTaskResults.getRecordStartMs();
        this.mEndTimeMs = mergedTaskResults.getEndMs();
        this.mThroughput = (float)this.mStatistics.mNumSuccess / (float)this.mDurationMs * 1000.0f;
        this.mParameters = mergedTaskResults.getParameters();
        this.mNodes = nodes;
        this.mErrors = errors;
    }

    public float getThroughput() {
        return this.mThroughput;
    }

    public void setThroughput(float throughput) {
        this.mThroughput = throughput;
    }

    public long getDurationMs() {
        return this.mDurationMs;
    }

    public void setDurationMs(long durationMs) {
        this.mDurationMs = durationMs;
    }

    public MasterBenchParameters getParameters() {
        return this.mParameters;
    }

    public void setParameters(MasterBenchParameters parameters) {
        this.mParameters = parameters;
    }

    public List<String> getNodes() {
        return this.mNodes;
    }

    public void setNodes(List<String> nodes) {
        this.mNodes = nodes;
    }

    public Map<String, List<String>> getErrors() {
        return this.mErrors;
    }

    public void setErrors(Map<String, List<String>> errors) {
        this.mErrors = errors;
    }

    public long getEndTimeMs() {
        return this.mEndTimeMs;
    }

    public void setEndTimeMs(long endTimeMs) {
        this.mEndTimeMs = endTimeMs;
    }

    public SummaryStatistics getStatistics() {
        return this.mStatistics;
    }

    public void setStatistics(SummaryStatistics statistics) {
        this.mStatistics = statistics;
    }

    public Map<String, SummaryStatistics> getStatisticsPerMethod() {
        return this.mStatisticsPerMethod;
    }

    public void setStatisticsPerMethod(Map<String, SummaryStatistics> statisticsPerMethod) {
        this.mStatisticsPerMethod = statisticsPerMethod;
    }

    private LineGraph.Data computeResponseTimeData() {
        return this.mStatistics.computeTimeData();
    }

    private List<String> collectErrors() {
        ArrayList<String> errors = new ArrayList<String>();
        for (Map.Entry<String, List<String>> entry : this.mErrors.entrySet()) {
            errors.addAll(entry.getValue().stream().map(err -> (String)entry.getKey() + ": " + err).collect(Collectors.toList()));
        }
        return errors;
    }

    @Override
    public alluxio.stress.GraphGenerator graphGenerator() {
        return new GraphGenerator();
    }

    public static final class GraphGenerator
    extends alluxio.stress.GraphGenerator {
        @Override
        public List<Graph> generate(List<? extends Summary> results) {
            ArrayList<Graph> graphs = new ArrayList<Graph>();
            List summaries = results.stream().map(x -> (MasterBenchSummary)x).collect(Collectors.toList());
            for (Operation operation : Operation.values()) {
                List opSummaries = summaries.stream().filter(x -> ((MasterBenchSummary)x).mParameters.mOperation == operation).collect(Collectors.toList());
                if (opSummaries.isEmpty()) continue;
                Pair<List<String>, List<String>> fieldNames = Parameters.partitionFieldNames(opSummaries.stream().map(x -> ((MasterBenchSummary)x).mParameters).collect(Collectors.toList()));
                ArrayList<String> subTitle = new ArrayList<String>(Splitter.fixedLength((int)100).splitToList((CharSequence)((MasterBenchSummary)opSummaries.get(0)).mParameters.getDescription((List)fieldNames.getFirst())));
                for (MasterBenchSummary summary : opSummaries) {
                    String series = summary.mParameters.getDescription((List)fieldNames.getSecond());
                    subTitle.add(series + ": " + DateFormat.getDateTimeInstance().format(summary.getEndTimeMs()));
                }
                LineGraph responseTimeGraph = new LineGraph((Object)((Object)operation) + " - Response Time (ms)", subTitle, "Percentile", "Response Time (ms)");
                graphs.add(responseTimeGraph);
                HashMap<String, LineGraph> responseTimeGraphPerMethod = new HashMap<String, LineGraph>();
                HashMap<String, Long> methodCounts = new HashMap<String, Long>();
                for (MasterBenchSummary summary : opSummaries) {
                    String series = summary.mParameters.getDescription((List)fieldNames.getSecond());
                    responseTimeGraph.addDataSeries(series, summary.computeResponseTimeData());
                    responseTimeGraph.setErrors(series, summary.collectErrors());
                    for (Map.Entry<String, SummaryStatistics> entry : summary.getStatisticsPerMethod().entrySet()) {
                        String method = entry.getKey();
                        LineGraph.Data responseTimeData = entry.getValue().computeTimeData();
                        if (!responseTimeGraphPerMethod.containsKey(method)) {
                            responseTimeGraphPerMethod.put(method, new LineGraph((Object)((Object)operation) + " - Response Time (ms) " + method, subTitle, "Percentile", "Response Time (ms)"));
                        }
                        ((LineGraph)responseTimeGraphPerMethod.get(method)).addDataSeries(series, responseTimeData);
                        methodCounts.put(method, Math.max(methodCounts.getOrDefault(method, 0L), entry.getValue().mNumSuccess));
                    }
                }
                BarGraph maxGraph = new BarGraph((Object)((Object)operation) + " - Max API Calls", subTitle, "# API calls");
                for (Map.Entry entry : methodCounts.entrySet()) {
                    BarGraph.Data data = new BarGraph.Data();
                    data.addData(entry.getValue());
                    maxGraph.addDataSeries((String)entry.getKey(), data);
                }
                graphs.add(maxGraph);
                for (LineGraph graph : responseTimeGraphPerMethod.values()) {
                    graphs.add(graph);
                }
            }
            return graphs;
        }
    }
}

