/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress;

import alluxio.AlluxioURI;
import alluxio.collections.Pair;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.MapType;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Parameters {
    private static final Logger LOG = LoggerFactory.getLogger(Parameters.class);
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);

    private Map<String, Object> toMap() {
        try {
            String json = MAPPER.writeValueAsString((Object)this);
            MapType type = MAPPER.getTypeFactory().constructMapType(Map.class, String.class, Object.class);
            return (Map)MAPPER.readValue(json, (JavaType)type);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to convert " + this.getClass().getName() + " to map.", e);
        }
    }

    public String getDescription(List<String> fields) {
        HashSet<String> includedFields = new HashSet<String>();
        if (fields != null) {
            includedFields.addAll(fields);
        }
        Map<String, Object> map = this.toMap();
        ArrayList<String> descriptions = new ArrayList<String>();
        for (Field field : this.getClass().getFields()) {
            KeylessDescription keylessAnnotation;
            PathDescription pathAnnotation;
            String fieldName = field.getName();
            Object fieldValue = map.get(fieldName);
            if (fields != null && !includedFields.contains(fieldName)) continue;
            if (fieldValue == null) {
                throw new IllegalStateException(String.format("Field value is null. fieldName: %s class: %s", fieldName, this.getClass().getName()));
            }
            String description = null;
            BooleanDescription boolAnnotation = field.getAnnotation(BooleanDescription.class);
            if (boolAnnotation != null) {
                if (!(fieldValue instanceof Boolean)) {
                    throw new IllegalStateException(String.format("%s must annotate a boolean, but %s is %s", boolAnnotation, field.getName(), field.getType().getName()));
                }
                description = (Boolean)fieldValue != false ? boolAnnotation.trueDescription() : boolAnnotation.falseDescription();
            }
            if ((pathAnnotation = field.getAnnotation(PathDescription.class)) != null) {
                if (map.containsKey(pathAnnotation.aliasFieldName())) continue;
                AlluxioURI uri = new AlluxioURI(fieldValue.toString());
                description = uri.getScheme();
                if (pathAnnotation.includeAuthority()) {
                    description = description + "-" + uri.getAuthority();
                }
            }
            if ((keylessAnnotation = field.getAnnotation(KeylessDescription.class)) != null && (description = fieldValue.toString()).isEmpty()) {
                description = "_";
            }
            if (description == null) {
                if (fieldName.startsWith("m")) {
                    fieldName = fieldName.substring(1);
                }
                description = String.format("%s: %s", fieldName, fieldValue.toString());
            }
            descriptions.add(description);
        }
        return String.join((CharSequence)", ", descriptions);
    }

    public static Pair<List<String>, List<String>> partitionFieldNames(List<Parameters> paramList) {
        List paramMaps = paramList.stream().map(Parameters::toMap).collect(Collectors.toList());
        Map constantValues = (Map)paramMaps.get(0);
        HashSet uniqueFields = new HashSet();
        for (Map param : paramMaps) {
            HashSet rm = new HashSet(constantValues.keySet());
            rm.removeAll(param.keySet());
            uniqueFields.addAll(rm);
            for (Map.Entry entry : param.entrySet()) {
                if (uniqueFields.contains(entry.getKey()) || entry.getValue().equals(constantValues.get(entry.getKey()))) continue;
                uniqueFields.add(entry.getKey());
            }
        }
        HashSet commonFields = new HashSet(constantValues.keySet());
        commonFields.removeAll(uniqueFields);
        return new Pair(new ArrayList(commonFields), new ArrayList(uniqueFields));
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface KeylessDescription {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface PathDescription {
        public String aliasFieldName() default "";

        public boolean includeAuthority() default true;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface BooleanDescription {
        public String trueDescription();

        public String falseDescription();
    }
}

