/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.master;

import alluxio.annotation.SuppressFBWarnings;
import alluxio.stress.common.SummaryStatistics;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.Histogram;

public class MasterBenchTaskResultStatistics {
    public long mNumSuccess;
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public byte[] mResponseTimeNsRaw;
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public long[] mMaxResponseTimeNs = new long[20];

    public MasterBenchTaskResultStatistics() {
        Arrays.fill(this.mMaxResponseTimeNs, -1L);
    }

    public void merge(MasterBenchTaskResultStatistics statistics) throws Exception {
        this.mNumSuccess += statistics.mNumSuccess;
        Histogram responseTime = new Histogram(1800000000000L, 3);
        if (this.mResponseTimeNsRaw != null) {
            responseTime.add((AbstractHistogram)Histogram.decodeFromCompressedByteBuffer((ByteBuffer)ByteBuffer.wrap(this.mResponseTimeNsRaw), (long)1800000000000L));
        }
        if (statistics.mResponseTimeNsRaw != null) {
            responseTime.add((AbstractHistogram)Histogram.decodeFromCompressedByteBuffer((ByteBuffer)ByteBuffer.wrap(statistics.mResponseTimeNsRaw), (long)1800000000000L));
        }
        this.encodeResponseTimeNsRaw(responseTime);
        for (int i = 0; i < this.mMaxResponseTimeNs.length; ++i) {
            if (statistics.mMaxResponseTimeNs[i] <= this.mMaxResponseTimeNs[i]) continue;
            this.mMaxResponseTimeNs[i] = statistics.mMaxResponseTimeNs[i];
        }
    }

    public void encodeResponseTimeNsRaw(Histogram responseTimeNs) {
        ByteBuffer bb = ByteBuffer.allocate(responseTimeNs.getEstimatedFootprintInBytes());
        responseTimeNs.encodeIntoCompressedByteBuffer(bb, 9);
        bb.flip();
        this.mResponseTimeNsRaw = new byte[bb.limit()];
        bb.get(this.mResponseTimeNsRaw);
    }

    public SummaryStatistics toMasterBenchSummaryStatistics() throws DataFormatException {
        Histogram responseTime = new Histogram(1800000000000L, 3);
        if (this.mResponseTimeNsRaw != null) {
            responseTime.add((AbstractHistogram)Histogram.decodeFromCompressedByteBuffer((ByteBuffer)ByteBuffer.wrap(this.mResponseTimeNsRaw), (long)1800000000000L));
        }
        float[] responseTimePercentile = new float[101];
        for (int i = 0; i <= 100; ++i) {
            responseTimePercentile[i] = (float)responseTime.getValueAtPercentile((double)i) / 1000000.0f;
        }
        float[] responseTime99Percentile = new float[6];
        for (int i = 0; i < responseTime99Percentile.length; ++i) {
            responseTime99Percentile[i] = (float)responseTime.getValueAtPercentile(100.0 - 1.0 / Math.pow(10.0, i)) / 1000000.0f;
        }
        float[] maxResponseTimesMs = new float[20];
        Arrays.fill(maxResponseTimesMs, -1.0f);
        for (int i = 0; i < this.mMaxResponseTimeNs.length; ++i) {
            maxResponseTimesMs[i] = (float)this.mMaxResponseTimeNs[i] / 1000000.0f;
        }
        return new SummaryStatistics(this.mNumSuccess, responseTimePercentile, responseTime99Percentile, maxResponseTimesMs);
    }
}

