/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.jobservice;

import alluxio.stress.Parameters;
import alluxio.stress.jobservice.JobServiceBenchOperation;
import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.Parameter;

public final class JobServiceBenchParameters
extends Parameters {
    @Parameter(names={"--operation"}, description="the operation to perform. Options are [DistributedLoad]", converter=OperationConverter.class, required=true)
    public JobServiceBenchOperation mOperation;
    @Parameter(names={"--num-dirs"}, description="the number of directories")
    public int mNumDirs = 256;
    @Parameter(names={"--files-per-dir"}, description="the number of files in each directory.")
    public int mNumFilesPerDir = 1000;
    @Parameter(names={"--base"}, description="The base directory path URI to perform operations in")
    public String mBasePath = "alluxio://localhost:19998/stress-job-service-base";
    @Parameter(names={"--file-size"}, description="The size of a file for the Create op, allowed to be 0. (0, 1m, 2k, 8k, etc.)")
    public int mFileSize = 128;

    public static class OperationConverter
    implements IStringConverter<JobServiceBenchOperation> {
        public JobServiceBenchOperation convert(String value) {
            return JobServiceBenchOperation.fromString(value);
        }
    }
}

