/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress;

import com.beust.jcommander.Parameter;
import java.util.ArrayList;
import java.util.List;

public final class BaseParameters {
    public static final String CLUSTER_FLAG = "--cluster";
    public static final String CLUSTER_LIMIT_FLAG = "--cluster-limit";
    public static final String CLUSTER_START_DELAY_FLAG = "--cluster-start-delay";
    public static final String DISTRIBUTED_FLAG = "--distributed";
    public static final String ID_FLAG = "--id";
    public static final String IN_PROCESS_FLAG = "--in-process";
    public static final String JAVA_OPT_FLAG = "--java-opt";
    public static final String START_MS_FLAG = "--start-ms";
    public static final String HELP_FLAG = "--help";
    public static final String PROFILE_AGENT = "--profile-agent";
    public static final String BENCH_TIMEOUT = "--bench-timeout";
    public static final long UNDEFINED_START_MS = -1L;
    public static final String AGENT_OUTPUT_PATH = "/tmp/stress_client.log";
    public static final String DEFAULT_TASK_ID = "local-task-0";
    @Parameter(names={"--cluster"}, description="If true, runs the benchmark via the job service cluster. Otherwise, runs locally.")
    public boolean mCluster = false;
    @Parameter(names={"--cluster-limit"}, description="If greater than 0, it will only run on that number of workers. If 0, will run on all available cluster workers. If < 0, will run on the workers from the end of the worker list. This flag is only used if --cluster is enabled.")
    public int mClusterLimit = 0;
    @Parameter(names={"--cluster-start-delay"}, description="The start delay for the jobs to wait before starting the benchmark, used to synchronize the jobs. For example, --cluster-start-delay 10000ms,--cluster-start-delay 15s, --cluster-start-delay 2m")
    public String mClusterStartDelay = "10s";
    @Parameter(names={"--java-opt"}, description="The java options to add to the command line to for the task. This can be repeated. The options must be quoted and prefixed with a space, to avoid getting passed to the JVM. For example: --java-opt \" -Xmx4g\" --java-opt \" -Xms2g\"")
    public List<String> mJavaOpts = new ArrayList<String>();
    @Parameter(names={"--profile-agent"}, description="The path to the profile agent if one is available. Providing this will enable a more detailed output.")
    public String mProfileAgent = "";
    @Parameter(names={"--bench-timeout"}, description="The length of time to wait when finishing the benchmark. (10m 600s, etc.)")
    public String mBenchTimeout = "20m";
    @Parameter(names={"--id"}, description="Any string to uniquely identify this invocation", hidden=true)
    public String mId = "local-task-0";
    @Parameter(names={"--distributed"}, description="If true, this is a distributed task, not a local task. This is automatically added for a cluster job.", hidden=true)
    public boolean mDistributed = false;
    @Parameter(names={"--start-ms"}, description="The time (ms since epoch) in the future to start the test. -1 means start immediately.", hidden=true)
    public long mStartMs = -1L;
    @Parameter(names={"--in-process"}, description="If true, runs the task in process. Otherwise, will spawn a new process to execute the task", hidden=true)
    public boolean mInProcess = false;
    @Parameter(names={"-h", "--help"}, help=true)
    public boolean mHelp = false;
}

