/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.jobservice;

import alluxio.collections.Pair;
import alluxio.stress.Parameters;
import alluxio.stress.Summary;
import alluxio.stress.common.GeneralBenchSummary;
import alluxio.stress.common.SummaryStatistics;
import alluxio.stress.graph.BarGraph;
import alluxio.stress.graph.Graph;
import alluxio.stress.graph.LineGraph;
import alluxio.stress.jobservice.JobServiceBenchOperation;
import alluxio.stress.jobservice.JobServiceBenchParameters;
import alluxio.stress.jobservice.JobServiceBenchTaskResult;
import alluxio.stress.jobservice.JobServiceBenchTaskResultStatistics;
import com.google.common.base.Splitter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.DataFormatException;

public final class JobServiceBenchSummary
extends GeneralBenchSummary {
    private long mDurationMs;
    private long mEndTimeMs;
    private JobServiceBenchParameters mParameters;
    private List<String> mNodes;
    private SummaryStatistics mStatistics;
    private Map<String, SummaryStatistics> mStatisticsPerMethod;

    public JobServiceBenchSummary() {
    }

    public JobServiceBenchSummary(JobServiceBenchTaskResult mergedTaskResults, List<String> nodes, Map<String, List<String>> errors) throws DataFormatException {
        this.mStatistics = mergedTaskResults.getStatistics().toBenchSummaryStatistics();
        this.mStatisticsPerMethod = new HashMap<String, SummaryStatistics>();
        for (Map.Entry<String, JobServiceBenchTaskResultStatistics> entry : mergedTaskResults.getStatisticsPerMethod().entrySet()) {
            String key = entry.getKey();
            JobServiceBenchTaskResultStatistics value = entry.getValue();
            this.mStatisticsPerMethod.put(key, value.toBenchSummaryStatistics());
        }
        this.mEndTimeMs = mergedTaskResults.getEndMs();
        this.mParameters = mergedTaskResults.getParameters();
        this.mDurationMs = this.mEndTimeMs - mergedTaskResults.getRecordStartMs();
        this.mThroughput = (float)this.mStatistics.mNumSuccess / (float)this.mDurationMs * 1000.0f;
        this.mNodes = nodes;
        this.mErrors = errors;
    }

    public long getDurationMs() {
        return this.mDurationMs;
    }

    public void setDurationMs(long durationMs) {
        this.mDurationMs = durationMs;
    }

    public JobServiceBenchParameters getParameters() {
        return this.mParameters;
    }

    public void setParameters(JobServiceBenchParameters parameters) {
        this.mParameters = parameters;
    }

    public List<String> getNodes() {
        return this.mNodes;
    }

    public void setNodes(List<String> nodes) {
        this.mNodes = nodes;
    }

    public long getEndTimeMs() {
        return this.mEndTimeMs;
    }

    public void setEndTimeMs(long endTimeMs) {
        this.mEndTimeMs = endTimeMs;
    }

    public SummaryStatistics getStatistics() {
        return this.mStatistics;
    }

    public void setStatistics(SummaryStatistics statistics) {
        this.mStatistics = statistics;
    }

    public Map<String, SummaryStatistics> getStatisticsPerMethod() {
        return this.mStatisticsPerMethod;
    }

    public void setStatisticsPerMethod(Map<String, SummaryStatistics> statisticsPerMethod) {
        this.mStatisticsPerMethod = statisticsPerMethod;
    }

    private LineGraph.Data computeResponseTimeData() {
        return this.mStatistics.computeTimeData();
    }

    private List<String> collectErrors() {
        ArrayList<String> errors = new ArrayList<String>();
        for (Map.Entry entry : this.mErrors.entrySet()) {
            errors.addAll(((List)entry.getValue()).stream().map(err -> (String)entry.getKey() + ": " + err).collect(Collectors.toList()));
        }
        return errors;
    }

    @Override
    public alluxio.stress.GraphGenerator graphGenerator() {
        return new GraphGenerator();
    }

    public static final class GraphGenerator
    extends alluxio.stress.GraphGenerator {
        @Override
        public List<Graph> generate(List<? extends Summary> results) {
            ArrayList<Graph> graphs = new ArrayList<Graph>();
            List summaries = results.stream().map(x -> (JobServiceBenchSummary)x).collect(Collectors.toList());
            for (JobServiceBenchOperation operation : JobServiceBenchOperation.values()) {
                List opSummaries = summaries.stream().filter(x -> ((JobServiceBenchSummary)x).mParameters.mOperation == operation).collect(Collectors.toList());
                if (opSummaries.isEmpty()) continue;
                Pair<List<String>, List<String>> fieldNames = Parameters.partitionFieldNames(opSummaries.stream().map(x -> ((JobServiceBenchSummary)x).mParameters).collect(Collectors.toList()));
                ArrayList<String> subTitle = new ArrayList<String>(Splitter.fixedLength((int)100).splitToList((CharSequence)((JobServiceBenchSummary)opSummaries.get(0)).mParameters.getDescription((List)fieldNames.getFirst())));
                for (JobServiceBenchSummary summary : opSummaries) {
                    String series = summary.mParameters.getDescription((List)fieldNames.getSecond());
                    subTitle.add(series + ": " + DateFormat.getDateTimeInstance().format(summary.getEndTimeMs()));
                }
                LineGraph responseTimeGraph = new LineGraph((Object)((Object)operation) + " - Response Time (ms)", subTitle, "Percentile", "Response Time (ms)");
                graphs.add(responseTimeGraph);
                HashMap<String, LineGraph> responseTimeGraphPerMethod = new HashMap<String, LineGraph>();
                HashMap<String, Long> methodCounts = new HashMap<String, Long>();
                for (JobServiceBenchSummary summary : opSummaries) {
                    String series = summary.mParameters.getDescription((List)fieldNames.getSecond());
                    responseTimeGraph.addDataSeries(series, summary.computeResponseTimeData());
                    responseTimeGraph.setErrors(series, summary.collectErrors());
                    for (Map.Entry<String, SummaryStatistics> entry : summary.getStatisticsPerMethod().entrySet()) {
                        String method = entry.getKey();
                        LineGraph.Data responseTimeData = entry.getValue().computeTimeData();
                        if (!responseTimeGraphPerMethod.containsKey(method)) {
                            responseTimeGraphPerMethod.put(method, new LineGraph((Object)((Object)operation) + " - Response Time (ms) " + method, subTitle, "Percentile", "Response Time (ms)"));
                        }
                        ((LineGraph)responseTimeGraphPerMethod.get(method)).addDataSeries(series, responseTimeData);
                        methodCounts.put(method, Math.max(methodCounts.getOrDefault(method, 0L), entry.getValue().mNumSuccess));
                    }
                }
                BarGraph maxGraph = new BarGraph((Object)((Object)operation) + " - Max API Calls", subTitle, "# API calls");
                for (Map.Entry entry : methodCounts.entrySet()) {
                    BarGraph.Data data = new BarGraph.Data();
                    data.addData(entry.getValue());
                    maxGraph.addDataSeries((String)entry.getKey(), data);
                }
                graphs.add(maxGraph);
                for (LineGraph graph : responseTimeGraphPerMethod.values()) {
                    graphs.add(graph);
                }
            }
            return graphs;
        }
    }
}

