/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.client;

public enum ClientIOOperation {
    WRITE("Write"),
    READ_ARRAY("ReadArray"),
    READ_BYTE_BUFFER("ReadByteBuffer"),
    READ_FULLY("ReadFully"),
    POS_READ("PosRead"),
    POS_READ_FULLY("PosReadFully");

    private final String mName;

    public static boolean isRead(ClientIOOperation operation) {
        switch (operation) {
            case READ_ARRAY: 
            case READ_BYTE_BUFFER: 
            case READ_FULLY: 
            case POS_READ: 
            case POS_READ_FULLY: {
                return true;
            }
        }
        return false;
    }

    public static boolean isPosRead(ClientIOOperation operation) {
        switch (operation) {
            case POS_READ: 
            case POS_READ_FULLY: {
                return true;
            }
        }
        return false;
    }

    private ClientIOOperation(String name) {
        this.mName = name;
    }

    public String toString() {
        return this.mName;
    }

    public static ClientIOOperation fromString(String text) {
        for (ClientIOOperation type : ClientIOOperation.values()) {
            if (!type.toString().equalsIgnoreCase(text)) continue;
            return type;
        }
        throw new IllegalArgumentException("No constant with text " + text + " found");
    }
}

