/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.common;

import alluxio.collections.Pair;
import alluxio.stress.Parameters;
import alluxio.stress.Summary;
import alluxio.stress.common.GeneralParameters;
import alluxio.stress.graph.BarGraph;
import alluxio.stress.graph.Graph;
import com.google.common.base.Splitter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class AbstractMaxThroughputSummary<T extends GeneralParameters, S extends Summary>
implements Summary {
    private float mMaxThroughput;
    private long mEndTimeMs;
    private T mParameters;
    private Map<Long, S> mPassedRuns = new HashMap<Long, S>();
    private Map<Long, S> mFailedRuns = new HashMap<Long, S>();

    public float getMaxThroughput() {
        return this.mMaxThroughput;
    }

    public void setMaxThroughput(float maxThroughput) {
        this.mMaxThroughput = maxThroughput;
    }

    public long getEndTimeMs() {
        return this.mEndTimeMs;
    }

    public void setEndTimeMs(long endTimeMs) {
        this.mEndTimeMs = endTimeMs;
    }

    @Override
    public alluxio.stress.GraphGenerator graphGenerator() {
        return new GraphGenerator();
    }

    public T getParameters() {
        return this.mParameters;
    }

    public void setParameters(T parameters) {
        this.mParameters = parameters;
    }

    public void addPassedRun(long targetThroughput, S summary) {
        this.mPassedRuns.put(targetThroughput, summary);
    }

    public Map<Long, S> getPassedRuns() {
        return this.mPassedRuns;
    }

    public void setPassedRuns(Map<Long, S> passedRuns) {
        this.mPassedRuns = passedRuns;
    }

    public void addFailedRun(long targetThroughput, S summary) {
        this.mFailedRuns.put(targetThroughput, summary);
    }

    public Map<Long, S> getFailedRuns() {
        return this.mFailedRuns;
    }

    public void setFailedRuns(Map<Long, S> failedRuns) {
        this.mFailedRuns = failedRuns;
    }

    public static class GraphGenerator
    extends alluxio.stress.GraphGenerator {
        @Override
        public List<Graph> generate(List<? extends Summary> results) {
            ArrayList<Graph> graphs = new ArrayList<Graph>();
            List summaries = results.stream().map(x -> (AbstractMaxThroughputSummary)x).collect(Collectors.toList());
            List operations = summaries.stream().map(x -> ((AbstractMaxThroughputSummary)x).mParameters.operation()).distinct().collect(Collectors.toList());
            for (Enum operation : operations) {
                String series;
                List opSummaries = summaries.stream().filter(x -> ((AbstractMaxThroughputSummary)x).mParameters.operation() == operation).collect(Collectors.toList());
                if (opSummaries.isEmpty()) continue;
                Pair<List<String>, List<String>> fieldNames = Parameters.partitionFieldNames(opSummaries.stream().map(x -> ((AbstractMaxThroughputSummary)x).mParameters).collect(Collectors.toList()));
                ArrayList<String> subTitle = new ArrayList<String>(Splitter.fixedLength((int)100).splitToList((CharSequence)((AbstractMaxThroughputSummary)opSummaries.get(0)).mParameters.getDescription((List)fieldNames.getFirst())));
                for (AbstractMaxThroughputSummary summary : opSummaries) {
                    String series2 = summary.mParameters.getDescription((List)fieldNames.getSecond());
                    subTitle.add(series2 + ": " + DateFormat.getDateTimeInstance().format(summary.getEndTimeMs()));
                }
                BarGraph maxGraph = new BarGraph(operation + " - Max Throughput", subTitle, "Throughput");
                for (AbstractMaxThroughputSummary summary : opSummaries) {
                    series = summary.mParameters.getDescription((List)fieldNames.getSecond());
                    BarGraph.Data data = new BarGraph.Data();
                    data.addData(Float.valueOf(summary.getMaxThroughput()));
                    maxGraph.addDataSeries(series, data);
                }
                graphs.add(maxGraph);
                for (AbstractMaxThroughputSummary summary : opSummaries) {
                    series = summary.mParameters.getDescription((List)fieldNames.getSecond());
                    ArrayList runs = new ArrayList(summary.getPassedRuns().values());
                    alluxio.stress.GraphGenerator runGraphGenerator = ((Summary)runs.get(0)).graphGenerator();
                    List<Graph> runGraphs = runGraphGenerator.generate(runs);
                    for (Graph graph : runGraphs) {
                        ArrayList<String> newTitle = new ArrayList<String>();
                        newTitle.add(series);
                        newTitle.addAll(graph.getTitle());
                        graph.setTitle(newTitle);
                    }
                    graphs.addAll(runGraphs);
                }
            }
            return graphs;
        }
    }
}

