/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.jobservice;

import alluxio.stress.BaseParameters;
import alluxio.stress.TaskResult;
import alluxio.stress.jobservice.JobServiceBenchParameters;
import alluxio.stress.jobservice.JobServiceBenchSummary;
import alluxio.stress.jobservice.JobServiceBenchTaskResultStatistics;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class JobServiceBenchTaskResult
implements TaskResult {
    private long mRecordStartMs;
    private long mEndMs;
    private BaseParameters mBaseParameters;
    private JobServiceBenchParameters mParameters;
    private List<String> mErrors = new ArrayList<String>();
    private JobServiceBenchTaskResultStatistics mStatistics = new JobServiceBenchTaskResultStatistics();
    private Map<String, JobServiceBenchTaskResultStatistics> mStatisticsPerMethod = new HashMap<String, JobServiceBenchTaskResultStatistics>();

    public void merge(JobServiceBenchTaskResult result) throws Exception {
        this.mErrors.addAll(result.mErrors);
        this.aggregateByWorker(result);
    }

    public void aggregateByWorker(JobServiceBenchTaskResult result) throws Exception {
        this.mStatistics.merge(result.mStatistics);
        this.mRecordStartMs = Math.min(this.mRecordStartMs, result.mRecordStartMs);
        this.mEndMs = Math.max(this.mEndMs, result.mEndMs);
        this.mBaseParameters = result.mBaseParameters;
        this.mParameters = result.mParameters;
        for (Map.Entry<String, JobServiceBenchTaskResultStatistics> entry : result.mStatisticsPerMethod.entrySet()) {
            String key = entry.getKey();
            JobServiceBenchTaskResultStatistics value = entry.getValue();
            if (!this.mStatisticsPerMethod.containsKey(key)) {
                this.mStatisticsPerMethod.put(key, value);
                continue;
            }
            this.mStatisticsPerMethod.get(key).merge(value);
        }
    }

    public void incrementNumSuccess(long numSuccess) {
        this.mStatistics.mNumSuccess += numSuccess;
    }

    @Override
    public BaseParameters getBaseParameters() {
        return this.mBaseParameters;
    }

    public void setBaseParameters(BaseParameters baseParameters) {
        this.mBaseParameters = baseParameters;
    }

    public JobServiceBenchParameters getParameters() {
        return this.mParameters;
    }

    public void setParameters(JobServiceBenchParameters parameters) {
        this.mParameters = parameters;
    }

    public long[] getMaxResponseTimeNs() {
        return this.mStatistics.mMaxResponseTimeNs;
    }

    public void setMaxResponseTimeNs(long[] maxResponseTimeNs) {
        this.mStatistics.mMaxResponseTimeNs = maxResponseTimeNs;
    }

    public long getRecordStartMs() {
        return this.mRecordStartMs;
    }

    public void setRecordStartMs(long recordStartMs) {
        this.mRecordStartMs = recordStartMs;
    }

    public long getEndMs() {
        return this.mEndMs;
    }

    public void setEndMs(long endMs) {
        this.mEndMs = endMs;
    }

    @Override
    public List<String> getErrors() {
        return this.mErrors;
    }

    public void setErrors(List<String> errors) {
        this.mErrors = errors;
    }

    public void addErrorMessage(String errMesssage) {
        this.mErrors.add(errMesssage);
    }

    public JobServiceBenchTaskResultStatistics getStatistics() {
        return this.mStatistics;
    }

    public void setStatistics(JobServiceBenchTaskResultStatistics statistics) {
        this.mStatistics = statistics;
    }

    public Map<String, JobServiceBenchTaskResultStatistics> getStatisticsPerMethod() {
        return this.mStatisticsPerMethod;
    }

    public void setStatisticsPerMethod(Map<String, JobServiceBenchTaskResultStatistics> statisticsPerMethod) {
        this.mStatisticsPerMethod = statisticsPerMethod;
    }

    public void putStatisticsForMethod(String method, JobServiceBenchTaskResultStatistics statistics) {
        this.mStatisticsPerMethod.put(method, statistics);
    }

    @Override
    public TaskResult.Aggregator aggregator() {
        return new Aggregator();
    }

    private static final class Aggregator
    implements TaskResult.Aggregator<JobServiceBenchTaskResult> {
        private Aggregator() {
        }

        public JobServiceBenchSummary aggregate(Iterable<JobServiceBenchTaskResult> results) throws Exception {
            HashMap<String, JobServiceBenchTaskResult> nodes = new HashMap<String, JobServiceBenchTaskResult>();
            JobServiceBenchTaskResult mergingTaskResult = null;
            for (TaskResult taskResult : results) {
                if (!(taskResult instanceof JobServiceBenchTaskResult)) {
                    throw new IOException("TaskResult is not of type JobServiceBenchTaskResult. class: " + taskResult.getClass().getName());
                }
                JobServiceBenchTaskResult result = (JobServiceBenchTaskResult)taskResult;
                nodes.put(result.getBaseParameters().mId, result);
                if (mergingTaskResult == null) {
                    mergingTaskResult = result;
                    continue;
                }
                mergingTaskResult.aggregateByWorker(result);
            }
            return new JobServiceBenchSummary(mergingTaskResult, nodes);
        }
    }
}

