/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.worker;

import alluxio.stress.BaseParameters;
import alluxio.stress.TaskResult;
import alluxio.stress.worker.WorkerBenchParameters;
import alluxio.stress.worker.WorkerBenchSummary;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class WorkerBenchTaskResult
implements TaskResult {
    private BaseParameters mBaseParameters;
    private WorkerBenchParameters mParameters;
    private long mRecordStartMs;
    private long mEndMs;
    private long mIOBytes;
    private List<String> mErrors = new ArrayList<String>();

    public void merge(WorkerBenchTaskResult result) throws Exception {
        this.mErrors.addAll(result.mErrors);
        this.aggregateByWorker(result);
    }

    public void aggregateByWorker(WorkerBenchTaskResult result) {
        this.mBaseParameters = result.mBaseParameters;
        this.mParameters = result.mParameters;
        this.mRecordStartMs = result.mRecordStartMs;
        this.mEndMs = Math.max(this.mEndMs, result.mEndMs);
        this.mIOBytes += result.mIOBytes;
    }

    public long getIOBytes() {
        return this.mIOBytes;
    }

    public void incrementIOBytes(long ioBytes) {
        this.mIOBytes += ioBytes;
    }

    public void setIOBytes(long ioBytes) {
        this.mIOBytes = ioBytes;
    }

    @Override
    public BaseParameters getBaseParameters() {
        return this.mBaseParameters;
    }

    public void setBaseParameters(BaseParameters baseParameters) {
        this.mBaseParameters = baseParameters;
    }

    public WorkerBenchParameters getParameters() {
        return this.mParameters;
    }

    public void setParameters(WorkerBenchParameters parameters) {
        this.mParameters = parameters;
    }

    public long getRecordStartMs() {
        return this.mRecordStartMs;
    }

    public void setRecordStartMs(long recordStartMs) {
        this.mRecordStartMs = recordStartMs;
    }

    public long getEndMs() {
        return this.mEndMs;
    }

    public void setEndMs(long endMs) {
        this.mEndMs = endMs;
    }

    @Override
    public List<String> getErrors() {
        return this.mErrors;
    }

    public void setErrors(List<String> errors) {
        this.mErrors = errors;
    }

    public void addErrorMessage(String errMesssage) {
        this.mErrors.add(errMesssage);
    }

    @Override
    public TaskResult.Aggregator aggregator() {
        return new Aggregator();
    }

    private static final class Aggregator
    implements TaskResult.Aggregator<WorkerBenchTaskResult> {
        private Aggregator() {
        }

        public WorkerBenchSummary aggregate(Iterable<WorkerBenchTaskResult> results) throws Exception {
            HashMap<String, WorkerBenchTaskResult> nodes = new HashMap<String, WorkerBenchTaskResult>();
            WorkerBenchTaskResult mergingTaskResult = new WorkerBenchTaskResult();
            for (WorkerBenchTaskResult result : results) {
                nodes.put(result.getBaseParameters().mId, result);
                mergingTaskResult.aggregateByWorker(result);
            }
            return new WorkerBenchSummary(mergingTaskResult, nodes);
        }
    }
}

