/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.master;

import alluxio.stress.BaseParameters;
import alluxio.stress.TaskResult;
import alluxio.stress.master.MasterBenchParameters;
import alluxio.stress.master.MasterBenchSummary;
import alluxio.stress.master.MasterBenchTaskResultStatistics;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class MasterBenchTaskResult
implements TaskResult {
    private long mRecordStartMs;
    private long mEndMs;
    private long mDurationMs;
    private BaseParameters mBaseParameters;
    private MasterBenchParameters mParameters;
    private List<String> mErrors = new ArrayList<String>();
    private MasterBenchTaskResultStatistics mStatistics = new MasterBenchTaskResultStatistics();
    private Map<String, MasterBenchTaskResultStatistics> mStatisticsPerMethod = new HashMap<String, MasterBenchTaskResultStatistics>();

    public void merge(MasterBenchTaskResult result) throws Exception {
        this.mErrors.addAll(result.mErrors);
        this.aggregateByWorker(result);
    }

    public void aggregateByWorker(MasterBenchTaskResult result) throws Exception {
        this.mStatistics.merge(result.mStatistics);
        this.mRecordStartMs = result.mRecordStartMs;
        if (result.mEndMs > this.mEndMs) {
            this.mEndMs = result.mEndMs;
        }
        this.mBaseParameters = result.mBaseParameters;
        this.mParameters = result.mParameters;
        for (Map.Entry<String, MasterBenchTaskResultStatistics> entry : result.mStatisticsPerMethod.entrySet()) {
            String key = entry.getKey();
            MasterBenchTaskResultStatistics value = entry.getValue();
            if (!this.mStatisticsPerMethod.containsKey(key)) {
                this.mStatisticsPerMethod.put(key, value);
                continue;
            }
            this.mStatisticsPerMethod.get(key).merge(value);
        }
    }

    public long getDurationMs() {
        return this.mDurationMs;
    }

    public void setDurationMs(long durationMs) {
        this.mDurationMs = durationMs;
    }

    public void incrementNumSuccess(long numSuccess) {
        this.mStatistics.mNumSuccess += numSuccess;
    }

    @Override
    public BaseParameters getBaseParameters() {
        return this.mBaseParameters;
    }

    public void setBaseParameters(BaseParameters baseParameters) {
        this.mBaseParameters = baseParameters;
    }

    public MasterBenchParameters getParameters() {
        return this.mParameters;
    }

    public void setParameters(MasterBenchParameters parameters) {
        this.mParameters = parameters;
    }

    public long[] getMaxResponseTimeNs() {
        return this.mStatistics.mMaxResponseTimeNs;
    }

    public void setMaxResponseTimeNs(long[] maxResponseTimeNs) {
        this.mStatistics.mMaxResponseTimeNs = maxResponseTimeNs;
    }

    public long getRecordStartMs() {
        return this.mRecordStartMs;
    }

    public void setRecordStartMs(long recordStartMs) {
        this.mRecordStartMs = recordStartMs;
    }

    public long getEndMs() {
        return this.mEndMs;
    }

    public void setEndMs(long endMs) {
        this.mEndMs = endMs;
    }

    @Override
    public List<String> getErrors() {
        return this.mErrors;
    }

    public void setErrors(List<String> errors) {
        this.mErrors = errors;
    }

    public void addErrorMessage(String errMesssage) {
        this.mErrors.add(errMesssage);
    }

    public MasterBenchTaskResultStatistics getStatistics() {
        return this.mStatistics;
    }

    public void setStatistics(MasterBenchTaskResultStatistics statistics) {
        this.mStatistics = statistics;
    }

    public Map<String, MasterBenchTaskResultStatistics> getStatisticsPerMethod() {
        return this.mStatisticsPerMethod;
    }

    public void setStatisticsPerMethod(Map<String, MasterBenchTaskResultStatistics> statisticsPerMethod) {
        this.mStatisticsPerMethod = statisticsPerMethod;
    }

    public void putStatisticsForMethod(String method, MasterBenchTaskResultStatistics statistics) {
        this.mStatisticsPerMethod.put(method, statistics);
    }

    @Override
    public TaskResult.Aggregator aggregator() {
        return new Aggregator();
    }

    private static final class Aggregator
    implements TaskResult.Aggregator<MasterBenchTaskResult> {
        private Aggregator() {
        }

        public MasterBenchSummary aggregate(Iterable<MasterBenchTaskResult> results) throws Exception {
            HashMap<String, MasterBenchTaskResult> nodes = new HashMap<String, MasterBenchTaskResult>();
            MasterBenchTaskResult mergingTaskResult = null;
            for (TaskResult taskResult : results) {
                if (!(taskResult instanceof MasterBenchTaskResult)) {
                    throw new IOException("TaskResult is not of type MasterBenchTaskResult. class: " + taskResult.getClass().getName());
                }
                MasterBenchTaskResult result = (MasterBenchTaskResult)taskResult;
                nodes.put(result.getBaseParameters().mId, result);
                if (mergingTaskResult == null) {
                    mergingTaskResult = result;
                    continue;
                }
                mergingTaskResult.aggregateByWorker(result);
            }
            return new MasterBenchSummary(mergingTaskResult, nodes);
        }
    }
}

