/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress;

import alluxio.conf.AlluxioConfiguration;
import alluxio.grpc.ConfigProperty;
import alluxio.grpc.LocationBlockIdListEntry;
import alluxio.master.MasterClientContext;
import alluxio.worker.block.BlockMapIterator;
import alluxio.worker.block.BlockMasterClient;
import alluxio.worker.block.BlockStoreLocation;
import alluxio.worker.block.RegisterStreamer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingBlockMasterClient
extends BlockMasterClient {
    private static final Logger LOG = LoggerFactory.getLogger(CachingBlockMasterClient.class);
    private List<LocationBlockIdListEntry> mLocationBlockIdList;
    public CachingBlockMapIterator mBlockBatchIterator;

    public CachingBlockMasterClient(MasterClientContext conf, List<LocationBlockIdListEntry> locationBlockIdList) {
        super(conf);
        LOG.debug("Init CachingBlockMasterClient for unary RPC");
        this.mLocationBlockIdList = locationBlockIdList;
    }

    public CachingBlockMasterClient(MasterClientContext conf, Map<BlockStoreLocation, List<Long>> blockMap) {
        super(conf);
        LOG.info("Init CachingBlockMasterClient for streaming RPC");
        this.mBlockBatchIterator = new CachingBlockMapIterator(blockMap, conf.getClusterConf());
    }

    public List<LocationBlockIdListEntry> convertBlockListMapToProto(Map<BlockStoreLocation, List<Long>> blockListOnLocation) {
        LOG.debug("Using the cached block list proto");
        return this.mLocationBlockIdList;
    }

    public void registerWithStream(long workerId, List<String> storageTierAliases, Map<String, Long> totalBytesOnTiers, Map<String, Long> usedBytesOnTiers, Map<BlockStoreLocation, List<Long>> currentBlocksOnLocation, Map<String, List<String>> lostStorage, List<ConfigProperty> configList) throws IOException {
        AtomicReference ioe = new AtomicReference();
        this.retryRPC(() -> {
            try {
                RegisterStreamer stream = new RegisterStreamer(this.mAsyncClient, workerId, storageTierAliases, totalBytesOnTiers, usedBytesOnTiers, lostStorage, configList, (BlockMapIterator)this.mBlockBatchIterator);
                stream.registerWithMaster();
            }
            catch (IOException e) {
                ioe.set(e);
            }
            catch (InterruptedException e) {
                ioe.set(new IOException(e));
            }
            return null;
        }, LOG, "Register", "workerId=%d", new Object[]{workerId});
        if (ioe.get() != null) {
            throw (IOException)ioe.get();
        }
    }

    public static class CachingBlockMapIterator
    extends BlockMapIterator {
        List<List<LocationBlockIdListEntry>> mBatches = new ArrayList<List<LocationBlockIdListEntry>>();
        Iterator<List<LocationBlockIdListEntry>> mDelegate;

        public CachingBlockMapIterator(Map<BlockStoreLocation, List<Long>> blockLocationMap, AlluxioConfiguration conf) {
            super(blockLocationMap, conf);
            while (super.hasNext()) {
                this.mBatches.add(super.next());
            }
            this.mDelegate = this.mBatches.iterator();
        }

        public boolean hasNext() {
            return this.mDelegate.hasNext();
        }

        public List<LocationBlockIdListEntry> next() {
            return this.mDelegate.next();
        }
    }
}

