/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.graph;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Graph {
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
    protected final Map<String, Object> mGraph = new HashMap<String, Object>();
    protected final List<Map<Object, Object>> mData = new ArrayList<Map<Object, Object>>();
    protected final List<String> mTitle = new ArrayList<String>();
    protected final List<String> mSubTitle = new ArrayList<String>();
    protected final Map<String, List<String>> mErrors = new HashMap<String, List<String>>();

    private Map<String, Object> toMap() {
        this.mGraph.put("data", ImmutableMap.of((Object)"values", this.mData));
        return this.mGraph;
    }

    public List<String> getTitle() {
        return this.mTitle;
    }

    public void setTitle(List<String> newTitle) {
        this.mTitle.clear();
        this.mTitle.addAll(newTitle);
        this.mGraph.put("title", ImmutableMap.of((Object)"text", this.mTitle, (Object)"subtitle", this.mSubTitle));
    }

    public String toJson() throws JsonProcessingException {
        MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        return MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(this.toMap());
    }

    public Map<String, List<String>> getErrors() {
        return this.mErrors;
    }

    public void setErrors(String series, List<String> errors) {
        if (errors.isEmpty()) {
            return;
        }
        this.mErrors.put(series, errors);
    }
}

