/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.master;

import alluxio.stress.BaseParameters;
import alluxio.stress.TaskResult;
import alluxio.stress.master.MasterBenchBaseParameters;
import alluxio.stress.master.MasterBenchTaskResultStatistics;
import java.util.ArrayList;
import java.util.List;

public abstract class MasterBenchTaskResultBase<P extends MasterBenchBaseParameters>
implements TaskResult {
    protected long mRecordStartMs;
    protected long mEndMs;
    protected long mDurationMs;
    protected BaseParameters mBaseParameters;
    protected P mParameters;
    protected List<String> mErrors = new ArrayList<String>();

    public void merge(MasterBenchTaskResultBase<P> result) throws Exception {
        this.mErrors.addAll(result.mErrors);
        this.aggregateByWorker(result);
    }

    abstract void mergeResultStatistics(MasterBenchTaskResultBase<P> var1) throws Exception;

    public abstract void putStatisticsForMethod(String var1, MasterBenchTaskResultStatistics var2);

    public void aggregateByWorker(MasterBenchTaskResultBase<P> result) throws Exception {
        this.mRecordStartMs = result.mRecordStartMs;
        if (result.mEndMs > this.mEndMs) {
            this.mEndMs = result.mEndMs;
        }
        this.mBaseParameters = result.mBaseParameters;
        this.mParameters = result.mParameters;
        this.mergeResultStatistics(result);
    }

    public long getDurationMs() {
        return this.mDurationMs;
    }

    public void setDurationMs(long durationMs) {
        this.mDurationMs = durationMs;
    }

    @Override
    public BaseParameters getBaseParameters() {
        return this.mBaseParameters;
    }

    public void setBaseParameters(BaseParameters baseParameters) {
        this.mBaseParameters = baseParameters;
    }

    public P getParameters() {
        return this.mParameters;
    }

    public void setParameters(P parameters) {
        this.mParameters = parameters;
    }

    public long getRecordStartMs() {
        return this.mRecordStartMs;
    }

    public void setRecordStartMs(long recordStartMs) {
        this.mRecordStartMs = recordStartMs;
    }

    public long getEndMs() {
        return this.mEndMs;
    }

    public void setEndMs(long endMs) {
        this.mEndMs = endMs;
    }

    @Override
    public List<String> getErrors() {
        return this.mErrors;
    }

    public void setErrors(List<String> errors) {
        this.mErrors = errors;
    }

    public void addErrorMessage(String errMesssage) {
        this.mErrors.add(errMesssage);
    }
}

