/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.common;

import alluxio.annotation.SuppressFBWarnings;
import alluxio.stress.graph.LineGraph;
import java.util.Arrays;

public class SummaryStatistics {
    public long mNumSuccesses;
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public float[] mTimePercentileMs;
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public float[] mTime99PercentileMs;
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public float[] mMaxTimeMs;

    public SummaryStatistics() {
        this.mTimePercentileMs = new float[101];
        Arrays.fill(this.mTimePercentileMs, 0.0f);
        this.mTime99PercentileMs = new float[6];
        Arrays.fill(this.mTime99PercentileMs, 0.0f);
        this.mMaxTimeMs = new float[20];
        Arrays.fill(this.mMaxTimeMs, 0.0f);
    }

    public SummaryStatistics(long numSuccess, float[] timePercentileMs, float[] time99PercentileMs, float[] maxTimeMs) {
        this.mNumSuccesses = numSuccess;
        this.mTimePercentileMs = timePercentileMs;
        this.mTime99PercentileMs = time99PercentileMs;
        this.mMaxTimeMs = maxTimeMs;
    }

    public LineGraph.Data computeTimeData() {
        LineGraph.Data data = new LineGraph.Data();
        if (this.mNumSuccesses == 0L) {
            return data;
        }
        data.addData(50, Float.valueOf(this.mTimePercentileMs[50]));
        data.addData(75, Float.valueOf(this.mTimePercentileMs[75]));
        data.addData(90, Float.valueOf(this.mTimePercentileMs[90]));
        data.addData(95, Float.valueOf(this.mTimePercentileMs[95]));
        int counter = 0;
        for (float ms : this.mTime99PercentileMs) {
            float percentile = (float)(100.0 - 1.0 / Math.pow(10.0, counter));
            data.addData(Float.valueOf(percentile), Float.valueOf(ms));
            ++counter;
        }
        return data;
    }
}

