/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.graph;

import alluxio.stress.graph.Graph;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class LineGraph
extends Graph {
    private static final String X_FIELD = "x";
    private static final String Y_FIELD = "y";
    private static final String SERIES_FIELD = "series";
    private static final int POINT_SIZE = 81;
    private static final Object CONDITIONAL_OPACITY = ImmutableMap.of((Object)"opacity", (Object)ImmutableMap.of((Object)"condition", (Object)ImmutableMap.of((Object)"selection", (Object)"legendSelect", (Object)"value", (Object)1), (Object)"value", (Object)0.05));
    private static final Object LEGEND_CONFIG = ImmutableMap.of((Object)"columns", (Object)3, (Object)"symbolLimit", (Object)500);

    public LineGraph(String title, List<String> subTitle, String xTitle, String yTitle) {
        this.mTitle.add(title);
        this.mSubTitle.addAll(subTitle);
        this.mGraph.put("$schema", "https://vega.github.io/schema/vega-lite/v4.json");
        this.mGraph.put("width", 700);
        this.mGraph.put("height", 400);
        this.mGraph.put("title", ImmutableMap.of((Object)"text", (Object)this.mTitle, (Object)"subtitle", (Object)this.mSubTitle));
        HashMap<String, Object> encoding = new HashMap<String, Object>();
        encoding.put(X_FIELD, ImmutableMap.of((Object)"field", (Object)X_FIELD, (Object)"type", (Object)"ordinal", (Object)"title", (Object)xTitle));
        encoding.put(Y_FIELD, ImmutableMap.of((Object)"field", (Object)Y_FIELD, (Object)"type", (Object)"quantitative", (Object)"title", (Object)yTitle));
        encoding.put("tooltip", Arrays.asList(ImmutableMap.of((Object)"field", (Object)SERIES_FIELD, (Object)"type", (Object)"nominal", (Object)"title", (Object)"Series"), ImmutableMap.of((Object)"field", (Object)X_FIELD, (Object)"type", (Object)"ordinal", (Object)"title", (Object)xTitle), ImmutableMap.of((Object)"field", (Object)Y_FIELD, (Object)"type", (Object)"quantitative", (Object)"title", (Object)yTitle)));
        encoding.put("color", ImmutableMap.of((Object)"field", (Object)SERIES_FIELD, (Object)"type", (Object)"nominal", (Object)"legend", (Object)LEGEND_CONFIG));
        encoding.put("strokeWidth", ImmutableMap.of((Object)"value", (Object)3));
        this.mGraph.put("encoding", encoding);
        ArrayList<ImmutableMap> layer = new ArrayList<ImmutableMap>();
        layer.add(ImmutableMap.of((Object)"mark", (Object)ImmutableMap.of((Object)"type", (Object)"point", (Object)"size", (Object)81, (Object)"stroke", (Object)"transparent"), (Object)"selection", (Object)ImmutableMap.of((Object)"legendSelect", (Object)ImmutableMap.of((Object)"type", (Object)"multi", (Object)"bind", (Object)"legend", (Object)"fields", (Object)new String[]{SERIES_FIELD}))));
        layer.add(ImmutableMap.of((Object)"mark", (Object)"line", (Object)"encoding", (Object)CONDITIONAL_OPACITY));
        layer.add(ImmutableMap.of((Object)"mark", (Object)ImmutableMap.of((Object)"type", (Object)"point", (Object)"size", (Object)81, (Object)"filled", (Object)false, (Object)"fill", (Object)"white"), (Object)"encoding", (Object)CONDITIONAL_OPACITY));
        this.mGraph.put("layer", layer);
        this.mGraph.put("config", ImmutableMap.of((Object)"legend", (Object)ImmutableMap.of((Object)"orient", (Object)"bottom", (Object)"direction", (Object)"vertical", (Object)"labelLimit", (Object)700)));
    }

    public void addDataSeries(String series, Data data) {
        List newSeries = data.mData.stream().map(m -> {
            HashMap<String, String> newMap = new HashMap<String, String>((Map<String, String>)m);
            newMap.put(SERIES_FIELD, series);
            return newMap;
        }).collect(Collectors.toList());
        this.mData.addAll(newSeries);
    }

    public static final class Data {
        private final List<Map<Object, Object>> mData = new ArrayList<Map<Object, Object>>();

        public void addData(Object x, Object y) {
            this.mData.add((Map<Object, Object>)ImmutableMap.of((Object)LineGraph.X_FIELD, (Object)x, (Object)LineGraph.Y_FIELD, (Object)y));
        }
    }
}

