/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.fuse;

import alluxio.stress.BaseParameters;
import alluxio.stress.TaskResult;
import alluxio.stress.fuse.FuseIOParameters;
import alluxio.stress.fuse.FuseIOSummary;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public final class FuseIOTaskResult
implements TaskResult {
    private long mRecordStartMs;
    private long mEndMs;
    private long mIOBytes;
    private List<String> mErrors = new ArrayList<String>();
    private BaseParameters mBaseParameters;
    private FuseIOParameters mParameters;

    @Override
    public TaskResult.Aggregator aggregator() {
        return new Aggregator();
    }

    public void merge(FuseIOTaskResult result) {
        this.mRecordStartMs = Math.min(this.mRecordStartMs, result.mRecordStartMs);
        this.mEndMs = Math.max(this.mEndMs, result.mEndMs);
        this.mIOBytes += result.mIOBytes;
        this.mErrors.addAll(result.mErrors);
    }

    @Override
    public BaseParameters getBaseParameters() {
        return this.mBaseParameters;
    }

    public void setBaseParameters(BaseParameters baseParameters) {
        this.mBaseParameters = baseParameters;
    }

    public FuseIOParameters getParameters() {
        return this.mParameters;
    }

    public void setParameters(FuseIOParameters parameters) {
        this.mParameters = parameters;
    }

    public long getDurationMs() {
        return this.mEndMs - this.mRecordStartMs;
    }

    @JsonIgnore
    public void setDurationMs(long durationMs) {
    }

    public long getIOBytes() {
        return this.mIOBytes;
    }

    public void incrementIOBytes(long ioBytes) {
        this.mIOBytes += ioBytes;
    }

    public void setIOBytes(long ioBytes) {
        this.mIOBytes = ioBytes;
    }

    public long getRecordStartMs() {
        return this.mRecordStartMs;
    }

    public void setRecordStartMs(long recordStartMs) {
        this.mRecordStartMs = recordStartMs;
    }

    public long getEndMs() {
        return this.mEndMs;
    }

    public void setEndMs(long endMs) {
        this.mEndMs = endMs;
    }

    @Override
    public List<String> getErrors() {
        return Collections.unmodifiableList(this.mErrors);
    }

    public void setErrors(List<String> errors) {
        this.mErrors = errors;
    }

    public void addErrorMessage(String errMessage) {
        this.mErrors.add(errMessage);
    }

    public float getIOMBps() {
        return (float)this.mIOBytes / (float)this.getDurationMs() * 1000.0f / 1048576.0f;
    }

    public void setIOMBps(float ioMBps) {
    }

    private static final class Aggregator
    implements TaskResult.Aggregator<FuseIOTaskResult> {
        private Aggregator() {
        }

        public FuseIOSummary aggregate(Iterable<FuseIOTaskResult> results) throws Exception {
            long recordStartMs = 0L;
            long endMs = 0L;
            long ioBytes = 0L;
            FuseIOParameters fuseIOParameters = null;
            BaseParameters baseParameters = null;
            HashMap<String, FuseIOTaskResult> nodes = new HashMap<String, FuseIOTaskResult>();
            for (FuseIOTaskResult taskResult : results) {
                recordStartMs = taskResult.getRecordStartMs();
                endMs = Math.max(endMs, taskResult.getEndMs());
                ioBytes += taskResult.getIOBytes();
                fuseIOParameters = taskResult.getParameters();
                baseParameters = taskResult.getBaseParameters();
                String jobWorkerUniqueId = taskResult.getBaseParameters().mId;
                nodes.put(jobWorkerUniqueId, taskResult);
            }
            float ioMBps = (float)ioBytes / (float)(endMs - recordStartMs) * 1000.0f / 1048576.0f;
            return new FuseIOSummary(fuseIOParameters, baseParameters, nodes, recordStartMs, endMs, ioBytes, ioMBps);
        }
    }
}

