/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.master;

import alluxio.annotation.SuppressFBWarnings;
import alluxio.collections.Pair;
import alluxio.stress.GraphGenerator;
import alluxio.stress.common.GeneralBenchSummary;
import alluxio.stress.common.SummaryStatistics;
import alluxio.stress.master.MasterBenchTaskResultStatistics;
import alluxio.stress.master.MultiOperationMasterBenchParameters;
import alluxio.stress.master.MultiOperationMasterBenchTaskResult;
import alluxio.stress.master.Operation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.DataFormatException;

public final class MultiOperationMasterBenchSummary
extends GeneralBenchSummary<MultiOperationMasterBenchTaskResult> {
    private long mDurationMs;
    private long mEndTimeMs;
    private MultiOperationMasterBenchParameters mParameters;
    private List<SummaryStatistics> mStatistics;
    private Map<String, SummaryStatistics> mStatisticsPerMethod;
    private List<Pair<Operation, Float>> mOperationThroughputs;

    public MultiOperationMasterBenchSummary() {
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
    public MultiOperationMasterBenchSummary(MultiOperationMasterBenchTaskResult mergedTaskResults, Map<String, MultiOperationMasterBenchTaskResult> nodes) throws DataFormatException {
        this.mStatistics = mergedTaskResults.getAllStatistics().stream().map(it -> {
            try {
                return it.toBenchSummaryStatistics();
            }
            catch (DataFormatException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        this.mStatisticsPerMethod = new HashMap<String, SummaryStatistics>();
        for (Map.Entry<String, MasterBenchTaskResultStatistics> entry : mergedTaskResults.getStatisticsPerMethod().entrySet()) {
            String key = entry.getKey();
            MasterBenchTaskResultStatistics value = entry.getValue();
            this.mStatisticsPerMethod.put(key, value.toBenchSummaryStatistics());
        }
        this.mDurationMs = mergedTaskResults.getEndMs() - mergedTaskResults.getRecordStartMs();
        this.mEndTimeMs = mergedTaskResults.getEndMs();
        this.mThroughput = (float)mergedTaskResults.getNumSuccessOperations() / (float)this.mDurationMs * 1000.0f;
        this.mOperationThroughputs = new ArrayList<Pair<Operation, Float>>();
        for (MasterBenchTaskResultStatistics statistics : mergedTaskResults.getAllStatistics()) {
            float throughput = (float)statistics.mNumSuccesses / (float)this.mDurationMs * 1000.0f;
            this.mOperationThroughputs.add((Pair<Operation, Float>)new Pair((Object)statistics.mOperation, (Object)Float.valueOf(throughput)));
        }
        this.mParameters = (MultiOperationMasterBenchParameters)mergedTaskResults.getParameters();
        this.mNodeResults = nodes;
    }

    public long getDurationMs() {
        return this.mDurationMs;
    }

    public void setDurationMs(long durationMs) {
        this.mDurationMs = durationMs;
    }

    public MultiOperationMasterBenchParameters getParameters() {
        return this.mParameters;
    }

    public void setParameters(MultiOperationMasterBenchParameters parameters) {
        this.mParameters = parameters;
    }

    public long getEndTimeMs() {
        return this.mEndTimeMs;
    }

    public void setEndTimeMs(long endTimeMs) {
        this.mEndTimeMs = endTimeMs;
    }

    public List<SummaryStatistics> getStatistics() {
        return this.mStatistics;
    }

    public void setStatistics(List<SummaryStatistics> statistics) {
        this.mStatistics = statistics;
    }

    public Map<String, SummaryStatistics> getStatisticsPerMethod() {
        return this.mStatisticsPerMethod;
    }

    public void setStatisticsPerMethod(Map<String, SummaryStatistics> statisticsPerMethod) {
        this.mStatisticsPerMethod = statisticsPerMethod;
    }

    public List<Pair<Operation, Float>> getOperationThroughputs() {
        return this.mOperationThroughputs;
    }

    public void setOperationThroughputs(List<Pair<Operation, Float>> operationThroughputs) {
        this.mOperationThroughputs = operationThroughputs;
    }

    @Override
    public GraphGenerator graphGenerator() {
        throw new RuntimeException("Graph generation is not supported in " + this.getClassName());
    }
}

