/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.worker;

import alluxio.stress.worker.WorkerBenchCoarseDataPoint;
import alluxio.stress.worker.WorkerBenchDataPoint;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;

public class WorkerBenchCoarseDataPointDeserializer
extends JsonDeserializer<WorkerBenchCoarseDataPoint> {
    public WorkerBenchCoarseDataPoint deserialize(JsonParser parser, DeserializationContext ctx) throws IOException {
        ObjectMapper mapper = (ObjectMapper)parser.getCodec();
        JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
        Long wId = node.get("workerId").asLong();
        Long tId = node.get("threadId").asLong();
        ArrayList<Long> tpList = new ArrayList<Long>();
        JsonNode tpNode = node.get("throughput");
        if (tpNode != null) {
            for (JsonNode throughput : tpNode) {
                tpList.add(throughput.asLong());
            }
        }
        ArrayList<WorkerBenchDataPoint> data = new ArrayList<WorkerBenchDataPoint>();
        JsonNode dataNodes = node.get("data");
        if (dataNodes != null) {
            for (JsonNode dataNode : dataNodes) {
                WorkerBenchDataPoint dataPoint = (WorkerBenchDataPoint)mapper.treeToValue((TreeNode)dataNode, WorkerBenchDataPoint.class);
                data.add(dataPoint);
            }
        }
        return new WorkerBenchCoarseDataPoint(wId, tId, data, tpList);
    }
}

