/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.worker;

import alluxio.collections.Pair;
import alluxio.stress.Parameters;
import alluxio.stress.Summary;
import alluxio.stress.common.GeneralBenchSummary;
import alluxio.stress.graph.Graph;
import alluxio.stress.graph.LineGraph;
import alluxio.stress.worker.WorkerBenchParameters;
import alluxio.stress.worker.WorkerBenchTaskResult;
import alluxio.util.FormatUtils;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.HdrHistogram.Histogram;

public final class WorkerBenchSummary
extends GeneralBenchSummary<WorkerBenchTaskResult> {
    private WorkerBenchParameters mParameters;
    private long mDurationMs;
    private long mEndTimeMs;
    private long mIOBytes;
    private List<Long> mThroughputPercentiles;

    public WorkerBenchSummary() {
        this.mNodeResults = new HashMap();
        this.mThroughputPercentiles = new ArrayList<Long>();
    }

    public WorkerBenchSummary(WorkerBenchTaskResult mergedTaskResults, Map<String, WorkerBenchTaskResult> nodes) {
        this.mDurationMs = mergedTaskResults.getEndMs() - mergedTaskResults.getRecordStartMs();
        this.mEndTimeMs = mergedTaskResults.getEndMs();
        this.mIOBytes = mergedTaskResults.getIOBytes();
        this.mParameters = mergedTaskResults.getParameters();
        this.mNodeResults = nodes;
        this.mThroughput = this.getIOMBps();
        this.mThroughputPercentiles = new ArrayList<Long>();
        Histogram throughputHistogram = new Histogram(FormatUtils.parseSpaceSize((String)this.mParameters.mFileSize), 3);
        mergedTaskResults.getAllThroughput().forEach(arg_0 -> ((Histogram)throughputHistogram).recordValue(arg_0));
        for (int i = 0; i <= 100; ++i) {
            this.mThroughputPercentiles.add(throughputHistogram.getValueAtPercentile((double)i));
        }
    }

    public float getIOMBps() {
        return (float)this.mIOBytes / (float)this.mDurationMs * 1000.0f / 1048576.0f;
    }

    public void setIOMBps(float ioMBps) {
    }

    public long getDurationMs() {
        return this.mDurationMs;
    }

    public void setDurationMs(long durationMs) {
        this.mDurationMs = durationMs;
    }

    public WorkerBenchParameters getParameters() {
        return this.mParameters;
    }

    public void setParameters(WorkerBenchParameters parameters) {
        this.mParameters = parameters;
    }

    public long getEndTimeMs() {
        return this.mEndTimeMs;
    }

    public void setEndTimeMs(long endTimeMs) {
        this.mEndTimeMs = endTimeMs;
    }

    public long getIOBytes() {
        return this.mIOBytes;
    }

    public void setIOBytes(long IOBytes) {
        this.mIOBytes = IOBytes;
    }

    public List<Long> getThroughputPercentiles() {
        return this.mThroughputPercentiles;
    }

    public void setThroughputPercentiles(List<Long> percentiles) {
        this.mThroughputPercentiles = percentiles;
    }

    @Override
    public alluxio.stress.GraphGenerator graphGenerator() {
        return new GraphGenerator();
    }

    public static final class GraphGenerator
    extends alluxio.stress.GraphGenerator {
        @Override
        public List<Graph> generate(List<? extends Summary> results) {
            ArrayList<Graph> graphs = new ArrayList<Graph>();
            List summaries = results.stream().map(x -> (WorkerBenchSummary)x).collect(Collectors.toList());
            if (summaries.isEmpty()) {
                return graphs;
            }
            Pair<List<String>, List<String>> fieldNames = Parameters.partitionFieldNames(summaries.stream().map(x -> ((WorkerBenchSummary)x).mParameters).collect(Collectors.toList()));
            ArrayList<String> subTitle = new ArrayList<String>(Splitter.fixedLength((int)100).splitToList((CharSequence)((WorkerBenchSummary)summaries.get(0)).mParameters.getDescription((List)fieldNames.getFirst())));
            LineGraph throughputGraph = new LineGraph("Worker Throughput (MB/s)", subTitle, "Total Client Threads", "Throughput (MB/s)");
            List<String> seriesFields = ((List)fieldNames.getSecond()).stream().filter(f -> !"mThreads".equals(f)).collect(Collectors.toList());
            HashMap<String, Map> allSeries = new HashMap<String, Map>();
            HashMap<String, List> allSeriesErrors = new HashMap<String, List>();
            for (WorkerBenchSummary workerBenchSummary : summaries) {
                String series = workerBenchSummary.mParameters.getDescription(seriesFields);
                allSeries.compute(series, (key, value) -> {
                    if (value == null) {
                        value = new HashMap<Integer, Float>();
                    }
                    int totalThreads = summary.getNodeResults().size() * summary.getParameters().mThreads;
                    value.put(totalThreads, Float.valueOf(summary.getIOMBps()));
                    return value;
                });
                allSeriesErrors.compute(series, (key, value) -> {
                    if (value == null) {
                        value = new ArrayList<String>();
                    }
                    value.addAll(summary.collectErrorsFromAllNodes());
                    return value;
                });
            }
            for (Map.Entry entry : allSeries.entrySet()) {
                LineGraph.Data seriesLine = new LineGraph.Data();
                for (Map.Entry dataPoint : ((Map)entry.getValue()).entrySet()) {
                    seriesLine.addData(dataPoint.getKey(), dataPoint.getValue());
                }
                throughputGraph.addDataSeries((String)entry.getKey(), seriesLine);
            }
            for (Map.Entry entry : allSeriesErrors.entrySet()) {
                throughputGraph.setErrors((String)entry.getKey(), (List)entry.getValue());
            }
            graphs.add(throughputGraph);
            return graphs;
        }
    }
}

