/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.cli.suite;

import alluxio.stress.BaseParameters;
import alluxio.stress.Summary;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParametersDelegate;

public abstract class Suite<T extends Summary> {
    @ParametersDelegate
    protected BaseParameters mBaseParameters = new BaseParameters();

    public abstract T runSuite(String[] var1) throws Exception;

    void prepare() throws Exception {
    }

    protected static void mainInternal(String[] args, Suite suite) {
        try {
            String result = suite.run(args);
            System.out.println(result);
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private String run(String[] args) throws Exception {
        JCommander jc = new JCommander((Object)this);
        jc.setProgramName(this.getClass().getSimpleName());
        try {
            jc.parse(args);
        }
        catch (Exception e) {
            jc.usage();
            throw e;
        }
        this.prepare();
        T result = this.runSuite(args);
        return result.toJson();
    }
}

