/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.cli.suite;

import alluxio.ClientContext;
import alluxio.client.job.JobMasterClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.stress.cli.StressMasterBench;
import alluxio.stress.cli.suite.Suite;
import alluxio.stress.master.MasterBenchParameters;
import alluxio.stress.master.MasterBenchSummary;
import alluxio.stress.master.MaxThroughputSummary;
import alluxio.stress.master.Operation;
import alluxio.util.CommonUtils;
import alluxio.util.ConfigurationUtils;
import alluxio.util.FormatUtils;
import alluxio.util.JsonSerializable;
import alluxio.worker.job.JobMasterClientContext;
import com.beust.jcommander.ParametersDelegate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxThroughput
extends Suite<MaxThroughputSummary> {
    private static final Logger LOG = LoggerFactory.getLogger(MaxThroughput.class);
    @ParametersDelegate
    private MasterBenchParameters mParameters = new MasterBenchParameters();
    private int mNumWorkers = 0;

    public static void main(String[] args) {
        MaxThroughput.mainInternal(args, new MaxThroughput());
    }

    private MaxThroughput() {
    }

    @Override
    public MaxThroughputSummary runSuite(String[] args) throws Exception {
        int current;
        try (JobMasterClient client = JobMasterClient.Factory.create((JobMasterClientContext)JobMasterClientContext.newBuilder((ClientContext)ClientContext.create((AlluxioConfiguration)new InstancedConfiguration(ConfigurationUtils.defaults()))).build());){
            this.mNumWorkers = client.getAllWorkerHealth().size();
        }
        if (this.mNumWorkers <= 0) {
            throw new IllegalStateException("No workers available for testing!");
        }
        MaxThroughputSummary summary = new MaxThroughputSummary();
        summary.setParameters(this.mParameters);
        ArrayList<String> baseArgs = new ArrayList<String>(Arrays.asList(args));
        this.prepareBeforeAllTests(baseArgs);
        int lower = 0;
        int upper = Integer.MAX_VALUE;
        int next = this.mParameters.mTargetThroughput;
        int best = 0;
        do {
            int perWorkerThroughput = next / this.mNumWorkers;
            int requestedThroughput = perWorkerThroughput * this.mNumWorkers;
            if (perWorkerThroughput == 0) break;
            ArrayList<String> newArgs = new ArrayList<String>(baseArgs);
            this.updateArgValue(newArgs, "--target-throughput", Integer.toString(perWorkerThroughput));
            long runSec = (FormatUtils.parseTimeSize((String)this.mParameters.mDuration) + FormatUtils.parseTimeSize((String)this.mParameters.mWarmup)) / 1000L;
            long requiredCount = (long)next * runSec;
            MasterBenchSummary mbr = this.runSingleTest(requiredCount, newArgs);
            current = next;
            float actualThroughput = mbr.getThroughput();
            if (actualThroughput > (float)requestedThroughput || (double)(((float)requestedThroughput - actualThroughput) / (float)requestedThroughput) < 0.02) {
                summary.addPassedRun((long)current, mbr);
                best = current;
                lower = current;
                next = upper == Integer.MAX_VALUE ? (next *= 2) : (next + upper) / 2;
            } else {
                summary.addFailedRun((long)current, mbr);
                upper = current;
                next = (lower + next) / 2;
            }
            LOG.info("target: " + requestedThroughput + " actual: " + actualThroughput + " [" + lower + " " + next + " " + upper + "]");
            for (Map.Entry entry : mbr.getErrors().entrySet()) {
                for (String error : (List)entry.getValue()) {
                    LOG.error(String.format("%s: %s", entry.getKey(), error));
                }
            }
        } while (!((double)((float)Math.abs(current - next) / (float)current) <= 0.02));
        LOG.info("max throughput: " + best);
        summary.setEndTimeMs(CommonUtils.getCurrentMs());
        summary.setMaxThroughput((float)best);
        return summary;
    }

    private void updateArgValue(List<String> args, String argName, String argValue) {
        int index = args.indexOf(argName);
        if (index == -1) {
            args.add(argName);
            args.add(argValue);
            return;
        }
        if (index + 1 < args.size()) {
            args.set(index + 1, argValue);
        }
    }

    private void createFiles(long numFiles, List<String> args) throws Exception {
        ArrayList<String> newArgs = new ArrayList<String>(args);
        this.updateArgValue(newArgs, "--operation", Operation.CreateFile.toString());
        this.updateArgValue(newArgs, "--warmup", "0s");
        this.updateArgValue(newArgs, "--threads", "128");
        this.updateArgValue(newArgs, "--stop-count", Long.toString(numFiles));
        this.updateArgValue(newArgs, "--target-throughput", "10000");
        LOG.info(String.format("Preparing %d files. args: %s", numFiles, String.join((CharSequence)" ", newArgs)));
        StressMasterBench b = new StressMasterBench();
        String result = b.run(newArgs.toArray(new String[0]));
        MasterBenchSummary summary = (MasterBenchSummary)JsonSerializable.fromJson((String)result, (JsonSerializable[])new MasterBenchSummary[0]);
        if (!summary.getErrors().isEmpty()) {
            throw new IllegalStateException(String.format("Could not create files for operation (%s). error: %s", this.mParameters.mOperation, summary.getErrors().entrySet().iterator().next()));
        }
    }

    private void prepareBeforeAllTests(List<String> args) throws Exception {
        switch (this.mParameters.mOperation) {
            case GetBlockLocations: 
            case GetFileStatus: 
            case ListDir: 
            case ListDirLocated: 
            case OpenFile: {
                this.createFiles(this.mParameters.mFixedCount, args);
                break;
            }
        }
    }

    private void prepareBeforeSingleTest(long requiredCount, List<String> args) throws Exception {
        switch (this.mParameters.mOperation) {
            case RenameFile: 
            case DeleteFile: {
                float perWorkerCount = (float)requiredCount / (float)this.mNumWorkers * 1.5f;
                this.createFiles(Math.max((long)perWorkerCount, (long)this.mParameters.mFixedCount), args);
                break;
            }
        }
    }

    private MasterBenchSummary runSingleTest(long requiredCount, List<String> args) throws Exception {
        this.prepareBeforeSingleTest(requiredCount, args);
        StressMasterBench b = new StressMasterBench();
        String result = b.run(args.toArray(new String[0]));
        return (MasterBenchSummary)JsonSerializable.fromJson((String)result, (JsonSerializable[])new MasterBenchSummary[0]);
    }
}

