/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.cli;

import alluxio.stress.cli.Benchmark;
import alluxio.stress.master.MasterBenchParameters;
import alluxio.stress.master.MasterBenchTaskResult;
import alluxio.stress.master.MasterBenchTaskResultStatistics;
import alluxio.stress.master.Operation;
import alluxio.util.CommonUtils;
import alluxio.util.FormatUtils;
import alluxio.util.executor.ExecutorServiceFactories;
import alluxio.util.io.PathUtils;
import com.beust.jcommander.ParametersDelegate;
import com.google.common.util.concurrent.RateLimiter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.HdrHistogram.Histogram;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StressMasterBench
extends Benchmark<MasterBenchTaskResult> {
    private static final Logger LOG = LoggerFactory.getLogger(StressMasterBench.class);
    @ParametersDelegate
    private MasterBenchParameters mParameters = new MasterBenchParameters();
    private byte[] mFiledata;
    private FileSystem[] mCachedFs;

    public static void main(String[] args) {
        StressMasterBench.mainInternal(args, new StressMasterBench());
    }

    @Override
    public void prepare() throws Exception {
        Configuration hdfsConf;
        if (this.mParameters.mFixedCount <= 0) {
            throw new IllegalStateException("fixed count must be > 0. fixedCount: " + this.mParameters.mFixedCount);
        }
        if (!this.mBaseParameters.mDistributed) {
            hdfsConf = new Configuration();
            hdfsConf.set("alluxio.user.file.delete.unchecked", "true");
            hdfsConf.set("alluxio.user.file.writetype.default", "CACHE_THROUGH");
            hdfsConf.set("alluxio.user.file.master.client.pool.size.max", "256");
            FileSystem prepareFs = FileSystem.get((URI)new URI(this.mParameters.mBasePath), (Configuration)hdfsConf);
            Path path = new Path(this.mParameters.mBasePath);
            Path basePath = this.mParameters.mOperation == Operation.CreateDir ? new Path(path, "dirs") : new Path(path, "files");
            if (this.mParameters.mOperation == Operation.CreateFile || this.mParameters.mOperation == Operation.CreateDir) {
                long start = CommonUtils.getCurrentMs();
                this.deletePaths(prepareFs, basePath);
                long end = CommonUtils.getCurrentMs();
                LOG.info("Cleanup delete took: {} s", (Object)((double)(end - start) / 1000.0));
                prepareFs.mkdirs(basePath);
            } else if (!prepareFs.exists(basePath)) {
                throw new IllegalStateException(String.format("base path (%s) must exist for operation (%s)", basePath, this.mParameters.mOperation));
            }
            if (!prepareFs.isDirectory(basePath)) {
                throw new IllegalStateException(String.format("base path (%s) must be a directory for operation (%s)", basePath, this.mParameters.mOperation));
            }
        }
        hdfsConf = new Configuration();
        hdfsConf.set(String.format("fs.%s.impl.disable.cache", new URI(this.mParameters.mBasePath).getScheme()), "true");
        for (Map.Entry entry : this.mParameters.mConf.entrySet()) {
            hdfsConf.set((String)entry.getKey(), (String)entry.getValue());
        }
        this.mCachedFs = new FileSystem[this.mParameters.mClients];
        for (int i = 0; i < this.mCachedFs.length; ++i) {
            this.mCachedFs[i] = FileSystem.get((URI)new URI(this.mParameters.mBasePath), (Configuration)hdfsConf);
        }
    }

    private void deletePaths(FileSystem fs, Path basePath) throws Exception {
        if (!fs.exists(basePath)) {
            return;
        }
        FileStatus[] subDirs = fs.listStatus(basePath);
        if (subDirs.length == 0) {
            return;
        }
        int fixedSize = fs.listStatus(new Path(subDirs[0].getPath(), "fixed")).length;
        long batchSize = 50000L;
        int deleteThreads = 256;
        ExecutorService service = ExecutorServiceFactories.fixedThreadPool((String)"bench-delete-thread", (int)deleteThreads).create();
        block0: for (FileStatus subDir : subDirs) {
            LOG.info("Cleaning up all files in: {}", (Object)subDir.getPath());
            AtomicLong globalCounter = new AtomicLong();
            Path fixedBase = new Path(subDir.getPath(), "fixed");
            long runningLimit = 0L;
            while (!Thread.currentThread().isInterrupted()) {
                AtomicLong success = new AtomicLong();
                long limit = runningLimit += batchSize;
                ArrayList<Callable<Void>> callables = new ArrayList<Callable<Void>>(deleteThreads);
                for (int i = 0; i < deleteThreads; ++i) {
                    callables.add(() -> {
                        while (!Thread.currentThread().isInterrupted()) {
                            long counter = globalCounter.getAndIncrement();
                            if (counter >= limit) {
                                globalCounter.getAndDecrement();
                                return null;
                            }
                            Path deletePath = counter < (long)fixedSize ? new Path(fixedBase, Long.toString(counter)) : new Path(subDir.getPath(), Long.toString(counter));
                            if (!fs.delete(deletePath, true)) continue;
                            success.getAndIncrement();
                        }
                        return null;
                    });
                }
                service.invokeAll(callables, 1L, TimeUnit.MINUTES);
                if (success.get() == 0L) continue block0;
                LOG.info("Removed {} files", (Object)success.get());
            }
        }
        service.shutdownNow();
        service.awaitTermination(10L, TimeUnit.SECONDS);
        LOG.info("Deleting base directory: {}", (Object)basePath);
        fs.delete(basePath, true);
    }

    @Override
    public MasterBenchTaskResult runLocal() throws Exception {
        ExecutorService service = ExecutorServiceFactories.fixedThreadPool((String)"bench-thread", (int)this.mParameters.mThreads).create();
        RateLimiter rateLimiter = RateLimiter.create((double)this.mParameters.mTargetThroughput);
        this.mFiledata = new byte[(int)FormatUtils.parseSpaceSize((String)this.mParameters.mCreateFileSize)];
        Arrays.fill(this.mFiledata, (byte)122);
        long durationMs = FormatUtils.parseTimeSize((String)this.mParameters.mDuration);
        long warmupMs = FormatUtils.parseTimeSize((String)this.mParameters.mWarmup);
        long startMs = this.mBaseParameters.mStartMs;
        if (this.mBaseParameters.mStartMs == -1L) {
            startMs = CommonUtils.getCurrentMs() + 1000L;
        }
        long endMs = startMs + warmupMs + durationMs;
        BenchContext context = new BenchContext(rateLimiter, startMs, endMs);
        ArrayList<BenchThread> callables = new ArrayList<BenchThread>(this.mParameters.mThreads);
        for (int i = 0; i < this.mParameters.mThreads; ++i) {
            callables.add(new BenchThread(context, this.mCachedFs[i % this.mCachedFs.length]));
        }
        service.invokeAll(callables, FormatUtils.parseTimeSize((String)this.mBaseParameters.mBenchTimeout), TimeUnit.MILLISECONDS);
        service.shutdownNow();
        service.awaitTermination(30L, TimeUnit.SECONDS);
        if (!this.mBaseParameters.mProfileAgent.isEmpty()) {
            context.addAdditionalResult();
        }
        return context.getResult();
    }

    private final class BenchThread
    implements Callable<Void> {
        private final BenchContext mContext;
        private final Histogram mResponseTimeNs;
        private final Path mBasePath;
        private final Path mFixedBasePath;
        private final FileSystem mFs;
        private final MasterBenchTaskResult mResult = new MasterBenchTaskResult();

        private BenchThread(BenchContext context, FileSystem fs) {
            this.mContext = context;
            this.mResponseTimeNs = new Histogram(1800000000000L, 3);
            this.mBasePath = ((StressMasterBench)StressMasterBench.this).mParameters.mOperation == Operation.CreateDir ? new Path(PathUtils.concatPath((Object)((StressMasterBench)StressMasterBench.this).mParameters.mBasePath, (Object[])new Object[]{"dirs", StressMasterBench.this.mBaseParameters.mId})) : new Path(PathUtils.concatPath((Object)((StressMasterBench)StressMasterBench.this).mParameters.mBasePath, (Object[])new Object[]{"files", StressMasterBench.this.mBaseParameters.mId}));
            this.mFixedBasePath = new Path(this.mBasePath, "fixed");
            this.mFs = fs;
        }

        @Override
        public Void call() {
            try {
                this.runInternal();
            }
            catch (Exception e) {
                this.mResult.addErrorMessage(e.getMessage());
            }
            this.mResult.setEndMs(CommonUtils.getCurrentMs());
            this.mResult.getStatistics().encodeResponseTimeNsRaw(this.mResponseTimeNs);
            this.mResult.setParameters(StressMasterBench.this.mParameters);
            this.mResult.setBaseParameters(StressMasterBench.this.mBaseParameters);
            this.mContext.mergeThreadResult(this.mResult);
            return null;
        }

        private void runInternal() throws Exception {
            long recordMs = this.mContext.getStartMs() + FormatUtils.parseTimeSize((String)((StressMasterBench)StressMasterBench.this).mParameters.mWarmup);
            this.mResult.setRecordStartMs(recordMs);
            boolean useStopCount = ((StressMasterBench)StressMasterBench.this).mParameters.mStopCount != -1;
            long bucketSize = (this.mContext.getEndMs() - recordMs) / 20L;
            long waitMs = this.mContext.getStartMs() - CommonUtils.getCurrentMs();
            if (waitMs < 0L) {
                throw new IllegalStateException(String.format("Thread missed barrier. Set the start time to a later time. start: %d current: %d", this.mContext.getStartMs(), CommonUtils.getCurrentMs()));
            }
            CommonUtils.sleepMs((long)waitMs);
            while (!Thread.currentThread().isInterrupted() && (!useStopCount && CommonUtils.getCurrentMs() < this.mContext.getEndMs() || useStopCount && this.mContext.mCounter.get() < (long)((StressMasterBench)StressMasterBench.this).mParameters.mStopCount)) {
                this.mContext.getRateLimiter().acquire();
                long startNs = System.nanoTime();
                this.applyOperation();
                long endNs = System.nanoTime();
                long currentMs = CommonUtils.getCurrentMs();
                if (currentMs <= recordMs) continue;
                this.mResult.incrementNumSuccess(1L);
                long responseTimeNs = endNs - startNs;
                this.mResponseTimeNs.recordValue(responseTimeNs);
                long[] maxResponseTimeNs = this.mResult.getStatistics().mMaxResponseTimeNs;
                int bucket = Math.min(maxResponseTimeNs.length - 1, (int)((currentMs - recordMs) / bucketSize));
                if (responseTimeNs <= maxResponseTimeNs[bucket]) continue;
                maxResponseTimeNs[bucket] = responseTimeNs;
            }
        }

        private void applyOperation() throws IOException {
            long counter = this.mContext.getCounter().getAndIncrement();
            switch (((StressMasterBench)StressMasterBench.this).mParameters.mOperation) {
                case CreateDir: {
                    Path path = counter < (long)((StressMasterBench)StressMasterBench.this).mParameters.mFixedCount ? new Path(this.mFixedBasePath, Long.toString(counter)) : new Path(this.mBasePath, Long.toString(counter));
                    this.mFs.mkdirs(path);
                    break;
                }
                case CreateFile: {
                    Path path = counter < (long)((StressMasterBench)StressMasterBench.this).mParameters.mFixedCount ? new Path(this.mFixedBasePath, Long.toString(counter)) : new Path(this.mBasePath, Long.toString(counter));
                    this.mFs.create(path).close();
                    break;
                }
                case GetBlockLocations: {
                    Path path = new Path(this.mFixedBasePath, Long.toString(counter %= (long)((StressMasterBench)StressMasterBench.this).mParameters.mFixedCount));
                    this.mFs.getFileBlockLocations(path, 0L, 0L);
                    break;
                }
                case GetFileStatus: {
                    Path path = new Path(this.mFixedBasePath, Long.toString(counter %= (long)((StressMasterBench)StressMasterBench.this).mParameters.mFixedCount));
                    this.mFs.getFileStatus(path);
                    break;
                }
                case ListDir: {
                    FileStatus[] files = this.mFs.listStatus(this.mFixedBasePath);
                    if (files.length == ((StressMasterBench)StressMasterBench.this).mParameters.mFixedCount) break;
                    throw new IOException(String.format("listing `%s` expected %d files but got %d files", this.mFixedBasePath, ((StressMasterBench)StressMasterBench.this).mParameters.mFixedCount, files.length));
                }
                case ListDirLocated: {
                    RemoteIterator it = this.mFs.listLocatedStatus(this.mFixedBasePath);
                    int listedFiles = 0;
                    while (it.hasNext()) {
                        it.next();
                        ++listedFiles;
                    }
                    if (listedFiles == ((StressMasterBench)StressMasterBench.this).mParameters.mFixedCount) break;
                    throw new IOException(String.format("listing located `%s` expected %d files but got %d files", this.mFixedBasePath, ((StressMasterBench)StressMasterBench.this).mParameters.mFixedCount, listedFiles));
                }
                case OpenFile: {
                    Path path = new Path(this.mFixedBasePath, Long.toString(counter %= (long)((StressMasterBench)StressMasterBench.this).mParameters.mFixedCount));
                    this.mFs.open(path).close();
                    break;
                }
                case RenameFile: {
                    Path path = counter < (long)((StressMasterBench)StressMasterBench.this).mParameters.mFixedCount ? new Path(this.mFixedBasePath, Long.toString(counter)) : new Path(this.mBasePath, Long.toString(counter));
                    Path dst = new Path(path.toString() + "-renamed");
                    if (this.mFs.rename(path, dst)) break;
                    throw new IOException(String.format("Failed to rename (%s) to (%s)", path, dst));
                }
                case DeleteFile: {
                    Path path = counter < (long)((StressMasterBench)StressMasterBench.this).mParameters.mFixedCount ? new Path(this.mFixedBasePath, Long.toString(counter)) : new Path(this.mBasePath, Long.toString(counter));
                    if (this.mFs.delete(path, false)) break;
                    throw new IOException(String.format("Failed to delete (%s)", path));
                }
                default: {
                    throw new IllegalStateException("Unknown operation: " + ((StressMasterBench)StressMasterBench.this).mParameters.mOperation);
                }
            }
        }
    }

    private final class BenchContext {
        private final RateLimiter mRateLimiter;
        private final long mStartMs;
        private final long mEndMs;
        private final AtomicLong mCounter;
        private MasterBenchTaskResult mResult;

        public BenchContext(RateLimiter rateLimiter, long startMs, long endMs) {
            this.mRateLimiter = rateLimiter;
            this.mStartMs = startMs;
            this.mEndMs = endMs;
            this.mCounter = new AtomicLong();
        }

        public RateLimiter getRateLimiter() {
            return this.mRateLimiter;
        }

        public long getStartMs() {
            return this.mStartMs;
        }

        public long getEndMs() {
            return this.mEndMs;
        }

        public AtomicLong getCounter() {
            return this.mCounter;
        }

        public synchronized void mergeThreadResult(MasterBenchTaskResult threadResult) {
            if (this.mResult == null) {
                this.mResult = threadResult;
                return;
            }
            try {
                this.mResult.merge(threadResult);
            }
            catch (Exception e) {
                this.mResult.addErrorMessage(e.getMessage());
            }
        }

        @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
        public synchronized void addAdditionalResult() throws IOException {
            if (this.mResult == null) {
                return;
            }
            Map<String, Benchmark.MethodStatistics> nameStatistics = StressMasterBench.this.processMethodProfiles(this.mResult.getRecordStartMs(), this.mResult.getEndMs(), profileInput -> {
                String method = profileInput.getMethod();
                if (profileInput.getType().contains("RPC")) {
                    int classNameDivider = profileInput.getMethod().lastIndexOf(".");
                    method = profileInput.getMethod().substring(classNameDivider + 1);
                }
                return profileInput.getType() + ":" + method;
            });
            for (Map.Entry<String, Benchmark.MethodStatistics> entry : nameStatistics.entrySet()) {
                MasterBenchTaskResultStatistics stats = new MasterBenchTaskResultStatistics();
                stats.encodeResponseTimeNsRaw(entry.getValue().getTimeNs());
                stats.mNumSuccess = entry.getValue().getNumSuccess();
                stats.mMaxResponseTimeNs = entry.getValue().getMaxTimeNs();
                this.mResult.putStatisticsForMethod(entry.getKey(), stats);
            }
        }

        public synchronized MasterBenchTaskResult getResult() {
            return this.mResult;
        }
    }
}

