/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.cli.fuse;

import alluxio.annotation.SuppressFBWarnings;
import alluxio.stress.cli.Benchmark;
import alluxio.stress.common.SummaryStatistics;
import alluxio.stress.fuse.FuseIOOperation;
import alluxio.stress.fuse.FuseIOParameters;
import alluxio.stress.fuse.FuseIOTaskResult;
import alluxio.util.CommonUtils;
import alluxio.util.FormatUtils;
import alluxio.util.executor.ExecutorServiceFactories;
import com.beust.jcommander.ParametersDelegate;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FuseIOBench
extends Benchmark<FuseIOTaskResult> {
    private static final Logger LOG = LoggerFactory.getLogger(FuseIOBench.class);
    @ParametersDelegate
    private FuseIOParameters mParameters = new FuseIOParameters();
    private volatile boolean mStartBarrierPassed = false;

    public static void main(String[] args) {
        FuseIOBench.mainInternal(args, new FuseIOBench());
    }

    @Override
    public String getBenchDescription() {
        return String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)ImmutableList.of((Object)"A stress bench for testing the reading throughput of Fuse-based POSIX API.", (Object)"To run the test, data must be written first by executing \"Write\" operation, then run \"Read\" operation to test the reading throughput. Optionally one can set alluxio.user.metadata.cache.enabled=true when mounting Alluxio Fuse and run \"ListFile\" before \"Read\" to cache the metadata of the test files and eliminate the effect of metadata operations while getting the reading throughput data.", (Object)"Note that \"--operation\" is required, and \"--local-path\" can be a local filesystem path or a mounted Fuse path.", (Object)"", (Object)"Example:", (Object)"# The test data will be written to /mnt/alluxio-fuse/FuseIOTest", (Object)"# Files will be evenly distributed into 32 directories, each contains 10 files of size 100 MB", (Object)"# Metadata of the test files will be cached", (Object)"# 32 threads will be used for writing the data, and 16 threads will be used for testing the reading throughput", (Object)"# 5 seconds of warmup time and 30 seconds of actual reading test time", (Object)"$ bin/alluxio runClass alluxio.stress.cli.fuse.fuseIOBench --operation Write \\", (Object)"--local-path /mnt/alluxio-fuse/FuseIOTest --num-dirs 32 --num-files-per-dir 10 \\", (Object[])new String[]{"--file-size 100m --threads 32", "$ bin/alluxio runClass alluxio.stress.cli.fuse.fuseIOBench --operation ListFile \\", "--local-path /mnt/alluxio-fuse/FuseIOTest", "$ bin/alluxio runClass alluxio.stress.cli.fuse.fuseIOBench --operation Read \\", "--local-path /mnt/alluxio-fuse/FuseIOTest --num-dirs 32 --num-files-per-dir 10 \\", "--file-size 100m --threads 16 --warmup 5s --duration 30s", ""}));
    }

    @Override
    public void prepare() throws Exception {
        if (this.mParameters.mThreads > this.mParameters.mNumDirs) {
            throw new IllegalArgumentException(String.format("Some of the threads are not being used. Please set the number of directories to be at least the number of threads, preferably a multiple of it.", new Object[0]));
        }
        if (this.mParameters.mOperation == FuseIOOperation.WRITE) {
            LOG.warn("Cannot write repeatedly, so warmup is not possible. Setting warmup to 0s.");
            this.mParameters.mWarmup = "0s";
            for (int i = 0; i < this.mParameters.mNumDirs; ++i) {
                Files.createDirectories(Paths.get(this.mParameters.mLocalPath + "/" + i, new String[0]), new FileAttribute[0]);
            }
        }
    }

    @Override
    public FuseIOTaskResult runLocal() throws Exception {
        ArrayList<Integer> threadCounts = new ArrayList<Integer>(this.mParameters.mThreads);
        threadCounts.sort(Comparator.comparingInt(i -> i));
        FuseIOTaskResult taskResult = new FuseIOTaskResult();
        taskResult.setBaseParameters(this.mBaseParameters);
        taskResult.setParameters(this.mParameters);
        FuseIOTaskResult.ThreadCountResult threadCountResult = this.runForThreadCount(this.mParameters.mThreads);
        taskResult.addThreadCountResults(this.mParameters.mThreads, threadCountResult);
        return taskResult;
    }

    private FuseIOTaskResult.ThreadCountResult runForThreadCount(int numThreads) throws Exception {
        LOG.info("Running benchmark for thread count: " + numThreads);
        ExecutorService service = ExecutorServiceFactories.fixedThreadPool((String)"bench-thread", (int)numThreads).create();
        long durationMs = FormatUtils.parseTimeSize((String)this.mParameters.mDuration);
        long warmupMs = FormatUtils.parseTimeSize((String)this.mParameters.mWarmup);
        long startMs = this.mBaseParameters.mStartMs;
        if (startMs == -1L || this.mStartBarrierPassed) {
            startMs = CommonUtils.getCurrentMs() + 10000L;
        }
        long endMs = startMs + warmupMs + durationMs;
        BenchContext context = new BenchContext(startMs, endMs);
        ArrayList<BenchThread> callables = new ArrayList<BenchThread>(numThreads);
        for (int i = 0; i < numThreads; ++i) {
            callables.add(new BenchThread(context, i, numThreads));
        }
        service.invokeAll(callables, FormatUtils.parseTimeSize((String)this.mBaseParameters.mBenchTimeout), TimeUnit.MILLISECONDS);
        service.shutdownNow();
        service.awaitTermination(30L, TimeUnit.SECONDS);
        FuseIOTaskResult.ThreadCountResult result = context.getResult();
        LOG.info(String.format("thread count: %d, errors: %d, IO throughput (MB/s): %f", numThreads, result.getErrors().size(), Float.valueOf(result.getIOMBps())));
        return result;
    }

    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
    public synchronized Map<String, SummaryStatistics> addAdditionalResult(long startMs, long endMs) throws IOException {
        HashMap<String, SummaryStatistics> summaryStatistics = new HashMap<String, SummaryStatistics>();
        Map<String, Benchmark.MethodStatistics> nameStatistics = this.processMethodProfiles(startMs, endMs, profileInput -> {
            if (profileInput.getIsttfb()) {
                return profileInput.getMethod();
            }
            return null;
        });
        if (!nameStatistics.isEmpty()) {
            for (Map.Entry<String, Benchmark.MethodStatistics> entry : nameStatistics.entrySet()) {
                summaryStatistics.put(entry.getKey(), this.toSummaryStatistics(entry.getValue()));
            }
        }
        return summaryStatistics;
    }

    private SummaryStatistics toSummaryStatistics(Benchmark.MethodStatistics methodStatistics) {
        float[] responseTimePercentile = new float[101];
        for (int i = 0; i <= 100; ++i) {
            responseTimePercentile[i] = (float)methodStatistics.getTimeNs().getValueAtPercentile((double)i) / 1000000.0f;
        }
        float[] responseTime99Percentile = new float[6];
        for (int i = 0; i < responseTime99Percentile.length; ++i) {
            responseTime99Percentile[i] = (float)methodStatistics.getTimeNs().getValueAtPercentile(100.0 - 1.0 / Math.pow(10.0, i)) / 1000000.0f;
        }
        float[] maxResponseTimesMs = new float[20];
        Arrays.fill(maxResponseTimesMs, -1.0f);
        for (int i = 0; i < methodStatistics.getMaxTimeNs().length; ++i) {
            maxResponseTimesMs[i] = (float)methodStatistics.getMaxTimeNs()[i] / 1000000.0f;
        }
        return new SummaryStatistics((long)methodStatistics.getNumSuccess(), responseTimePercentile, responseTime99Percentile, maxResponseTimesMs);
    }

    private final class BenchThread
    implements Callable<Void> {
        private final BenchContext mContext;
        private final int mThreadId;
        private final byte[] mBuffer;
        private final long mFileSize;
        private FileInputStream mInStream = null;
        private FileOutputStream mOutStream = null;
        private long mCurrentOffset;
        private final FuseIOTaskResult.ThreadCountResult mThreadCountResult = new FuseIOTaskResult.ThreadCountResult();

        private BenchThread(BenchContext context, int threadId, int numThreads) {
            this.mContext = context;
            this.mThreadId = threadId;
            this.mBuffer = new byte[(int)FormatUtils.parseSpaceSize((String)((FuseIOBench)FuseIOBench.this).mParameters.mBufferSize)];
            Arrays.fill(this.mBuffer, (byte)65);
            this.mFileSize = FormatUtils.parseSpaceSize((String)((FuseIOBench)FuseIOBench.this).mParameters.mFileSize);
        }

        @Override
        public Void call() {
            try {
                this.runInternal();
            }
            catch (Exception e) {
                LOG.error(Thread.currentThread().getName() + ": failed", (Throwable)e);
                this.mThreadCountResult.addErrorMessage(e.getMessage());
            }
            finally {
                this.closeInStream();
                this.closeOutStream();
            }
            this.mThreadCountResult.setEndMs(CommonUtils.getCurrentMs());
            this.mContext.mergeThreadResult(this.mThreadCountResult);
            return null;
        }

        private void runInternal() throws Exception {
            long recordMs = this.mContext.getStartMs() + FormatUtils.parseTimeSize((String)((FuseIOBench)FuseIOBench.this).mParameters.mWarmup);
            this.mThreadCountResult.setRecordStartMs(recordMs);
            boolean isRead = FuseIOOperation.isRead((FuseIOOperation)((FuseIOBench)FuseIOBench.this).mParameters.mOperation);
            long waitMs = this.mContext.getStartMs() - CommonUtils.getCurrentMs();
            if (waitMs < 0L) {
                throw new IllegalStateException(String.format("Thread missed barrier. Increase the start delay. start: %d current: %d", this.mContext.getStartMs(), CommonUtils.getCurrentMs()));
            }
            CommonUtils.sleepMs((long)waitMs);
            FuseIOBench.this.mStartBarrierPassed = true;
            if (((FuseIOBench)FuseIOBench.this).mParameters.mOperation == FuseIOOperation.LIST_FILE) {
                for (int dirId = this.mThreadId; dirId < ((FuseIOBench)FuseIOBench.this).mParameters.mNumDirs; dirId += ((FuseIOBench)FuseIOBench.this).mParameters.mThreads) {
                    String dirPath = String.format("%s/%d", ((FuseIOBench)FuseIOBench.this).mParameters.mLocalPath, dirId);
                    File dir = new File(dirPath);
                    dir.listFiles();
                }
                return;
            }
            for (int dirId = this.mThreadId; dirId < ((FuseIOBench)FuseIOBench.this).mParameters.mNumDirs; dirId += ((FuseIOBench)FuseIOBench.this).mParameters.mThreads) {
                block2: for (int fileId = 0; fileId < ((FuseIOBench)FuseIOBench.this).mParameters.mNumFilesPerDir; ++fileId) {
                    this.mCurrentOffset = 0L;
                    String filePath = String.format("%s/%d/%d", ((FuseIOBench)FuseIOBench.this).mParameters.mLocalPath, dirId, fileId);
                    while (!Thread.currentThread().isInterrupted()) {
                        if (isRead && CommonUtils.getCurrentMs() > this.mContext.getEndMs()) {
                            this.closeInStream();
                            return;
                        }
                        long ioBytes = this.applyOperation(filePath);
                        if (ioBytes <= 0L) continue block2;
                        if (CommonUtils.getCurrentMs() <= recordMs) continue;
                        this.mThreadCountResult.incrementIOBytes(ioBytes);
                    }
                }
            }
            if (isRead) {
                throw new IllegalArgumentException(String.format("Thread %d finishes reading all its files before the bench ends. For more accurate result, use more files, or larger files, or a shorter duration", this.mThreadId));
            }
        }

        private long applyOperation(String filePath) throws IOException {
            if (FuseIOOperation.isRead((FuseIOOperation)((FuseIOBench)FuseIOBench.this).mParameters.mOperation) && this.mInStream == null) {
                this.mInStream = new FileInputStream(filePath);
            }
            switch (((FuseIOBench)FuseIOBench.this).mParameters.mOperation) {
                case READ: {
                    int bytesRead = this.mInStream.read(this.mBuffer);
                    if (bytesRead < 0) {
                        this.closeInStream();
                    }
                    return bytesRead;
                }
                case WRITE: {
                    int bytesToWrite;
                    if (this.mOutStream == null) {
                        this.mOutStream = new FileOutputStream(filePath);
                    }
                    if ((bytesToWrite = (int)Math.min(this.mFileSize - this.mCurrentOffset, (long)this.mBuffer.length)) == 0) {
                        this.closeOutStream();
                        return -1L;
                    }
                    this.mOutStream.write(this.mBuffer, 0, bytesToWrite);
                    this.mCurrentOffset += (long)bytesToWrite;
                    return bytesToWrite;
                }
            }
            throw new IllegalStateException("Unknown operation: " + ((FuseIOBench)FuseIOBench.this).mParameters.mOperation);
        }

        private void closeInStream() {
            try {
                if (this.mInStream != null) {
                    this.mInStream.close();
                }
            }
            catch (IOException e) {
                this.mThreadCountResult.addErrorMessage(e.getMessage());
            }
            finally {
                this.mInStream = null;
            }
        }

        private void closeOutStream() {
            try {
                if (this.mOutStream != null) {
                    this.mOutStream.close();
                }
            }
            catch (IOException e) {
                this.mThreadCountResult.addErrorMessage(e.getMessage());
            }
            finally {
                this.mOutStream = null;
            }
        }
    }

    private final class BenchContext {
        private final long mStartMs;
        private final long mEndMs;
        private FuseIOTaskResult.ThreadCountResult mThreadCountResult;

        public BenchContext(long startMs, long endMs) {
            this.mStartMs = startMs;
            this.mEndMs = endMs;
        }

        public long getStartMs() {
            return this.mStartMs;
        }

        public long getEndMs() {
            return this.mEndMs;
        }

        public synchronized void mergeThreadResult(FuseIOTaskResult.ThreadCountResult threadResult) {
            if (this.mThreadCountResult == null) {
                this.mThreadCountResult = threadResult;
            } else {
                try {
                    this.mThreadCountResult.merge(threadResult);
                }
                catch (Exception e) {
                    this.mThreadCountResult.addErrorMessage(e.getMessage());
                }
            }
        }

        public synchronized FuseIOTaskResult.ThreadCountResult getResult() {
            return this.mThreadCountResult;
        }
    }
}

