/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.cli;

import alluxio.AlluxioURI;
import alluxio.annotation.SuppressFBWarnings;
import alluxio.cli.fs.command.AbstractDistributedJobCommand;
import alluxio.cli.fs.command.DistributedLoadCommand;
import alluxio.cli.fs.command.DistributedLoadUtils;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.exception.AlluxioException;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.DeletePOptions;
import alluxio.grpc.WritePType;
import alluxio.stress.cli.Benchmark;
import alluxio.stress.jobservice.JobServiceBenchParameters;
import alluxio.stress.jobservice.JobServiceBenchTaskResult;
import alluxio.stress.jobservice.JobServiceBenchTaskResultStatistics;
import alluxio.util.CommonUtils;
import alluxio.util.ConfigurationUtils;
import alluxio.util.FormatUtils;
import alluxio.util.executor.ExecutorServiceFactories;
import com.beust.jcommander.ParametersDelegate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.HdrHistogram.Histogram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StressJobServiceBench
extends Benchmark<JobServiceBenchTaskResult> {
    private static final Logger LOG = LoggerFactory.getLogger(StressJobServiceBench.class);
    public static final int MAX_RESPONSE_TIME_BUCKET_INDEX = 0;
    @ParametersDelegate
    private JobServiceBenchParameters mParameters = new JobServiceBenchParameters();

    public static void main(String[] args) {
        StressJobServiceBench.mainInternal(args, new StressJobServiceBench());
    }

    @Override
    public void prepare() throws Exception {
        FileSystemContext fsContext = FileSystemContext.create((AlluxioConfiguration)new InstancedConfiguration(ConfigurationUtils.defaults()));
        FileSystem fileSystem = FileSystem.Factory.create((FileSystemContext)fsContext);
        long start = CommonUtils.getCurrentMs();
        this.deleteBasePath(fileSystem);
        long deleteEnd = CommonUtils.getCurrentMs();
        LOG.info("Cleanup delete took: {} s", (Object)((double)(deleteEnd - start) / 1000.0));
        this.createFiles(fileSystem, this.mParameters.mNumFilesPerDir, this.mParameters.mNumDirs, this.mParameters.mFileSize);
        long createEnd = CommonUtils.getCurrentMs();
        LOG.info("Create files took: {} s", (Object)((double)(createEnd - deleteEnd) / 1000.0));
    }

    private void createFiles(FileSystem fs, int numFiles, int numDirs, int fileSize) throws IOException, AlluxioException {
        CreateFilePOptions options = CreateFilePOptions.newBuilder().setRecursive(true).setWriteType(WritePType.THROUGH).build();
        for (int dirId = 0; dirId < numDirs; ++dirId) {
            for (int fileId = 0; fileId < numFiles; ++fileId) {
                String filePath = String.format("%s/%s/%d/%d", this.mParameters.mBasePath, this.mBaseParameters.mId, dirId, fileId);
                this.createByteFile(fs, new AlluxioURI(filePath), options, fileSize);
            }
        }
    }

    private void createByteFile(FileSystem fs, AlluxioURI fileURI, CreateFilePOptions options, int len) throws IOException, AlluxioException {
        try (FileOutStream os = fs.createFile(fileURI, options);){
            byte[] arr = new byte[len];
            for (int k = 0; k < len; ++k) {
                arr[k] = (byte)k;
            }
            os.write(arr);
        }
    }

    private void deleteBasePath(FileSystem fs) throws IOException, AlluxioException {
        String currentWorkerFilePath = String.format("%s/%s", this.mParameters.mBasePath, this.mBaseParameters.mId);
        AlluxioURI path = new AlluxioURI(currentWorkerFilePath);
        if (fs.exists(path)) {
            DeletePOptions options = DeletePOptions.newBuilder().setRecursive(true).build();
            fs.delete(path, options);
        }
    }

    @Override
    public String getBenchDescription() {
        return "";
    }

    @Override
    public JobServiceBenchTaskResult runLocal() throws Exception {
        ExecutorService service = ExecutorServiceFactories.fixedThreadPool((String)"bench-thread", (int)this.mParameters.mNumDirs).create();
        long timeOutMs = FormatUtils.parseTimeSize((String)this.mBaseParameters.mBenchTimeout);
        long startMs = this.mBaseParameters.mStartMs;
        if (this.mBaseParameters.mStartMs == -1L) {
            startMs = CommonUtils.getCurrentMs() + 1000L;
        }
        BenchContext context = new BenchContext(startMs);
        ArrayList<BenchThread> callables = new ArrayList<BenchThread>(this.mParameters.mNumDirs);
        for (int dirId = 0; dirId < this.mParameters.mNumDirs; ++dirId) {
            String filePath = String.format("%s/%s/%d", this.mParameters.mBasePath, this.mBaseParameters.mId, dirId);
            callables.add(new BenchThread(context, filePath));
        }
        service.invokeAll(callables, timeOutMs, TimeUnit.MILLISECONDS);
        service.shutdownNow();
        service.awaitTermination(30L, TimeUnit.SECONDS);
        if (!this.mBaseParameters.mProfileAgent.isEmpty()) {
            context.addAdditionalResult();
        }
        return context.getResult();
    }

    private final class BenchThread
    implements Callable<Void> {
        private final BenchContext mContext;
        private final Histogram mResponseTimeNs;
        private final String mPath;
        private final JobServiceBenchTaskResult mResult = new JobServiceBenchTaskResult();

        private BenchThread(BenchContext context, String path) {
            this.mContext = context;
            this.mResponseTimeNs = new Histogram(1800000000000L, 3);
            this.mPath = path;
        }

        @Override
        public Void call() {
            try {
                this.runInternal();
            }
            catch (Exception e) {
                this.mResult.addErrorMessage(e.getMessage());
            }
            this.mResult.setEndMs(CommonUtils.getCurrentMs());
            this.mResult.getStatistics().encodeResponseTimeNsRaw(this.mResponseTimeNs);
            this.mResult.setParameters(StressJobServiceBench.this.mParameters);
            this.mResult.setBaseParameters(StressJobServiceBench.this.mBaseParameters);
            this.mContext.mergeThreadResult(this.mResult);
            return null;
        }

        private void runInternal() throws Exception {
            this.mResult.setRecordStartMs(this.mContext.getStartMs());
            long waitMs = this.mContext.getStartMs() - CommonUtils.getCurrentMs();
            if (waitMs < 0L) {
                throw new IllegalStateException(String.format("Thread missed barrier. Set the start time to a later time. start: %d current: %d", this.mContext.getStartMs(), CommonUtils.getCurrentMs()));
            }
            CommonUtils.sleepMs((long)waitMs);
            long startNs = System.nanoTime();
            this.applyOperation(this.mPath);
            long endNs = System.nanoTime();
            long responseTimeNs = endNs - startNs;
            this.mResponseTimeNs.recordValue(responseTimeNs);
            long[] maxResponseTimeNs = this.mResult.getStatistics().mMaxResponseTimeNs;
            if (responseTimeNs > maxResponseTimeNs[0]) {
                maxResponseTimeNs[0] = responseTimeNs;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void applyOperation(String dirPath) throws IOException, AlluxioException {
            switch (((StressJobServiceBench)StressJobServiceBench.this).mParameters.mOperation) {
                case DISTRIBUTED_LOAD: {
                    int numReplication = 1;
                    FileSystemContext fsContext = FileSystemContext.create((AlluxioConfiguration)new InstancedConfiguration(ConfigurationUtils.defaults()));
                    DistributedLoadCommand cmd = new DistributedLoadCommand(fsContext);
                    try {
                        DistributedLoadUtils.distributedLoad((AbstractDistributedJobCommand)cmd, (AlluxioURI)new AlluxioURI(dirPath), (int)numReplication, new HashSet(), new HashSet(), new HashSet(), new HashSet());
                    }
                    finally {
                        this.mResult.incrementNumSuccess((long)cmd.getCompletedCount());
                    }
                    return;
                }
            }
            throw new IllegalStateException("Unknown operation: " + ((StressJobServiceBench)StressJobServiceBench.this).mParameters.mOperation);
        }
    }

    private final class BenchContext {
        private final long mStartMs;
        private JobServiceBenchTaskResult mResult;

        public BenchContext(long startMs) {
            this.mStartMs = startMs;
        }

        public long getStartMs() {
            return this.mStartMs;
        }

        public synchronized void mergeThreadResult(JobServiceBenchTaskResult threadResult) {
            if (this.mResult == null) {
                this.mResult = threadResult;
                return;
            }
            try {
                this.mResult.merge(threadResult);
            }
            catch (Exception e) {
                this.mResult.addErrorMessage(e.getMessage());
            }
        }

        @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
        public synchronized void addAdditionalResult() throws IOException {
            if (this.mResult == null) {
                return;
            }
            Map<String, Benchmark.MethodStatistics> nameStatistics = StressJobServiceBench.this.processMethodProfiles(this.mResult.getRecordStartMs(), this.mResult.getEndMs(), profileInput -> {
                String method = profileInput.getMethod();
                if (profileInput.getType().contains("RPC")) {
                    int classNameDivider = profileInput.getMethod().lastIndexOf(".");
                    method = profileInput.getMethod().substring(classNameDivider + 1);
                }
                return profileInput.getType() + ":" + method;
            });
            for (Map.Entry<String, Benchmark.MethodStatistics> entry : nameStatistics.entrySet()) {
                JobServiceBenchTaskResultStatistics stats = new JobServiceBenchTaskResultStatistics();
                stats.encodeResponseTimeNsRaw(entry.getValue().getTimeNs());
                stats.mNumSuccess = entry.getValue().getNumSuccess();
                stats.mMaxResponseTimeNs = entry.getValue().getMaxTimeNs();
                this.mResult.putStatisticsForMethod(entry.getKey(), stats);
            }
        }

        public synchronized JobServiceBenchTaskResult getResult() {
            return this.mResult;
        }
    }
}

