/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.cli;

import alluxio.annotation.SuppressFBWarnings;
import alluxio.client.job.JobGrpcClientUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.job.JobConfig;
import alluxio.job.plan.PlanConfig;
import alluxio.job.wire.JobInfo;
import alluxio.stress.BaseParameters;
import alluxio.stress.TaskResult;
import alluxio.stress.job.StressBenchConfig;
import alluxio.util.ConfigurationUtils;
import alluxio.util.FormatUtils;
import alluxio.util.ShellUtils;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParametersDelegate;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.HdrHistogram.Histogram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Benchmark<T extends TaskResult> {
    private static final Logger LOG = LoggerFactory.getLogger(Benchmark.class);
    @ParametersDelegate
    protected BaseParameters mBaseParameters = new BaseParameters();

    public abstract String getBenchDescription();

    public abstract T runLocal() throws Exception;

    public abstract void prepare() throws Exception;

    public void cleanup() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void mainInternal(String[] args, Benchmark benchmark) {
        int exitCode = 0;
        try {
            String result = benchmark.run(args);
            System.out.println(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            exitCode = -1;
        }
        finally {
            try {
                benchmark.cleanup();
            }
            catch (Exception e) {
                e.printStackTrace();
                exitCode = -1;
            }
        }
        System.exit(exitCode);
    }

    public PlanConfig generateJobConfig(String[] args) {
        List commandArgs = Arrays.stream(args).filter(s -> !"--cluster".equals(s) && !s.isEmpty()).collect(Collectors.toList());
        commandArgs.addAll(this.mBaseParameters.mJavaOpts.stream().map(String::trim).collect(Collectors.toList()));
        String className = this.getClass().getCanonicalName();
        long startDelay = FormatUtils.parseTimeSize((String)this.mBaseParameters.mClusterStartDelay);
        return new StressBenchConfig(className, commandArgs, startDelay, this.mBaseParameters.mClusterLimit);
    }

    public String run(String[] args) throws Exception {
        this.parseParameters(args);
        return this.runSingleTask(args);
    }

    protected void parseParameters(String[] args) {
        JCommander jc = new JCommander((Object)this);
        jc.setProgramName(this.getClass().getSimpleName());
        try {
            jc.parse(args);
            if (this.mBaseParameters.mHelp) {
                System.out.println(this.getBenchDescription());
                jc.usage();
                System.exit(0);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to parse command: ", (Throwable)e);
            System.out.println(this.getBenchDescription());
            jc.usage();
            throw e;
        }
    }

    protected String runSingleTask(String[] args) throws Exception {
        this.prepare();
        if (!this.mBaseParameters.mProfileAgent.isEmpty()) {
            this.mBaseParameters.mJavaOpts.add("-javaagent:" + this.mBaseParameters.mProfileAgent + "=" + "/tmp/stress_client.log");
        }
        InstancedConfiguration conf = new InstancedConfiguration(ConfigurationUtils.defaults());
        String className = this.getClass().getCanonicalName();
        if (this.mBaseParameters.mCluster) {
            long jobId = JobGrpcClientUtils.run((JobConfig)this.generateJobConfig(args), (int)0, (AlluxioConfiguration)conf);
            JobInfo jobInfo = JobGrpcClientUtils.getJobStatus((long)jobId, (AlluxioConfiguration)conf, (boolean)true);
            return jobInfo.getResult().toString();
        }
        if (this.mBaseParameters.mInProcess) {
            T result = this.runLocal();
            if (this.mBaseParameters.mDistributed) {
                return result.toJson();
            }
            String s = result.aggregator().aggregate(Collections.singletonList(result)).toJson();
            return s;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(conf.get(PropertyKey.HOME) + "/bin/alluxio");
        command.add("runClass");
        command.add(className);
        command.addAll(Arrays.asList(args));
        command.add("--in-process");
        command.addAll(this.mBaseParameters.mJavaOpts.stream().map(String::trim).collect(Collectors.toList()));
        LOG.info("running command: " + String.join((CharSequence)" ", command));
        return ShellUtils.execCommand((String[])command.toArray(new String[0]));
    }

    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
    protected Map<String, MethodStatistics> processMethodProfiles(long startMs, long endMs, Function<ProfileInput, String> nameTransformer) throws IOException {
        HashMap<String, MethodStatistics> nameStatistics = new HashMap<String, MethodStatistics>();
        try (BufferedReader reader = new BufferedReader(new FileReader("/tmp/stress_client.log"));){
            String line;
            long bucketSize = (endMs - startMs) / 20L;
            ObjectMapper objectMapper = new ObjectMapper();
            while ((line = reader.readLine()) != null) {
                ProfileInput profileInput;
                String name;
                Map lineMap;
                try {
                    lineMap = (Map)objectMapper.readValue(line, Map.class);
                }
                catch (JsonParseException | MismatchedInputException e) {
                    break;
                }
                String type = (String)lineMap.get("type");
                String methodName = (String)lineMap.get("methodName");
                Number timestampNumber = (Number)lineMap.get("timestamp");
                Number durationNumber = (Number)lineMap.get("duration");
                Boolean ttfbFlag = (Boolean)lineMap.get("ttfb");
                if (type == null || methodName == null || timestampNumber == null || durationNumber == null || ttfbFlag == null) continue;
                long timestamp = timestampNumber.longValue();
                long duration = durationNumber.longValue();
                boolean ttfb = ttfbFlag;
                if (timestamp <= startMs || (name = nameTransformer.apply(profileInput = new ProfileInput(type, methodName, ttfb))) == null) continue;
                if (!nameStatistics.containsKey(name)) {
                    nameStatistics.put(name, new MethodStatistics());
                }
                MethodStatistics statistic = (MethodStatistics)nameStatistics.get(name);
                statistic.mTimeNs.recordValue(duration);
                statistic.mNumSuccess = statistic.mNumSuccess + 1;
                int bucket = Math.min(statistic.mMaxTimeNs.length - 1, (int)((timestamp - startMs) / bucketSize));
                ((MethodStatistics)statistic).mMaxTimeNs[bucket] = Math.max(statistic.mMaxTimeNs[bucket], duration);
            }
        }
        return nameStatistics;
    }

    protected static final class MethodStatistics {
        private Histogram mTimeNs = new Histogram(1800000000000L, 3);
        private int mNumSuccess = 0;
        private long[] mMaxTimeNs = new long[20];

        MethodStatistics() {
            Arrays.fill(this.mMaxTimeNs, -1L);
        }

        public Histogram getTimeNs() {
            return this.mTimeNs;
        }

        public int getNumSuccess() {
            return this.mNumSuccess;
        }

        public long[] getMaxTimeNs() {
            return this.mMaxTimeNs;
        }
    }

    protected static final class ProfileInput {
        private final String mType;
        private final String mMethod;
        private final boolean mIsttfb;

        ProfileInput(String type, String method, boolean isttfb) {
            this.mType = type;
            this.mMethod = method;
            this.mIsttfb = isttfb;
        }

        public String getType() {
            return this.mType;
        }

        public String getMethod() {
            return this.mMethod;
        }

        public boolean getIsttfb() {
            return this.mIsttfb;
        }
    }
}

