/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.cli;

import alluxio.AlluxioURI;
import alluxio.annotation.SuppressFBWarnings;
import alluxio.client.file.FileSystem;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.AlluxioProperties;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.Source;
import alluxio.exception.AlluxioException;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.DeletePOptions;
import alluxio.hadoop.HadoopConfigurationUtils;
import alluxio.stress.cli.AbstractStressBench;
import alluxio.stress.cli.Benchmark;
import alluxio.stress.common.FileSystemClientType;
import alluxio.stress.master.MasterBenchParameters;
import alluxio.stress.master.MasterBenchTaskResult;
import alluxio.stress.master.MasterBenchTaskResultStatistics;
import alluxio.stress.master.Operation;
import alluxio.util.CommonUtils;
import alluxio.util.ConfigurationUtils;
import alluxio.util.FormatUtils;
import alluxio.util.executor.ExecutorServiceFactories;
import alluxio.util.io.PathUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.RateLimiter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.HdrHistogram.Histogram;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StressMasterBench
extends AbstractStressBench<MasterBenchTaskResult, MasterBenchParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(StressMasterBench.class);
    private byte[] mFiledata;
    private FileSystem[] mCachedFs;
    private alluxio.client.file.FileSystem[] mCachedNativeFs;

    public StressMasterBench() {
        this.mParameters = new MasterBenchParameters();
    }

    public static void main(String[] args) {
        StressMasterBench.mainInternal(args, new StressMasterBench());
    }

    @Override
    public String getBenchDescription() {
        return String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)ImmutableList.of((Object)"A benchmarking tool to measure the master performance of Alluxio", (Object)"MaxThroughput is the recommended way to run the Master Stress Bench.", (Object)"", (Object)"Example:", (Object)"# this would continuously run `ListDir` opeartion for 30s and record the throughput after 5s warmup.", (Object)"$ bin/alluxio runClass alluxio.stress.cli.StressMasterBench --operation ListDir \\", (Object)"--warmup 5s --duration 30s --cluster", (Object)""));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
    public void prepare() throws Exception {
        Configuration hdfsConf;
        if (((MasterBenchParameters)this.mParameters).mFixedCount <= 0) {
            throw new IllegalStateException("fixed count must be > 0. fixedCount: " + ((MasterBenchParameters)this.mParameters).mFixedCount);
        }
        if (!this.mBaseParameters.mDistributed) {
            hdfsConf = new Configuration();
            hdfsConf.set("alluxio.user.file.delete.unchecked", "true");
            hdfsConf.set("alluxio.user.file.writetype.default", ((MasterBenchParameters)this.mParameters).mWriteType);
            hdfsConf.set("alluxio.user.file.master.client.pool.size.max", "256");
            FileSystem prepareFs = FileSystem.get((URI)new URI(((MasterBenchParameters)this.mParameters).mBasePath), (Configuration)hdfsConf);
            Path path = new Path(((MasterBenchParameters)this.mParameters).mBasePath);
            Path basePath = ((MasterBenchParameters)this.mParameters).mOperation == Operation.CREATE_DIR ? new Path(path, "dirs") : new Path(path, "files");
            if (((MasterBenchParameters)this.mParameters).mOperation == Operation.CREATE_FILE || ((MasterBenchParameters)this.mParameters).mOperation == Operation.CREATE_DIR) {
                LOG.info("Cleaning base path: {}", (Object)basePath);
                long start = CommonUtils.getCurrentMs();
                this.deletePaths(prepareFs, basePath);
                long end = CommonUtils.getCurrentMs();
                LOG.info("Cleanup took: {} s", (Object)((double)(end - start) / 1000.0));
                prepareFs.mkdirs(basePath);
            } else if (!prepareFs.exists(basePath)) {
                throw new IllegalStateException(String.format("base path (%s) must exist for operation (%s)", basePath, ((MasterBenchParameters)this.mParameters).mOperation));
            }
            if (!prepareFs.isDirectory(basePath)) {
                throw new IllegalStateException(String.format("base path (%s) must be a directory for operation (%s)", basePath, ((MasterBenchParameters)this.mParameters).mOperation));
            }
        }
        hdfsConf = new Configuration();
        hdfsConf.set(String.format("fs.%s.impl.disable.cache", new URI(((MasterBenchParameters)this.mParameters).mBasePath).getScheme()), "true");
        for (Map.Entry entry : ((MasterBenchParameters)this.mParameters).mConf.entrySet()) {
            hdfsConf.set((String)entry.getKey(), (String)entry.getValue());
        }
        hdfsConf.set("alluxio.user.file.writetype.default", ((MasterBenchParameters)this.mParameters).mWriteType);
        if (((MasterBenchParameters)this.mParameters).mClientType == FileSystemClientType.ALLUXIO_HDFS) {
            LOG.info("Using ALLUXIO HDFS Compatible API to perform the test.");
            this.mCachedFs = new FileSystem[((MasterBenchParameters)this.mParameters).mClients];
            for (int i = 0; i < this.mCachedFs.length; ++i) {
                this.mCachedFs[i] = FileSystem.get((URI)new URI(((MasterBenchParameters)this.mParameters).mBasePath), (Configuration)hdfsConf);
            }
        } else {
            void var3_8;
            LOG.info("Using ALLUXIO Native API to perform the test.");
            AlluxioProperties alluxioProperties = ConfigurationUtils.defaults();
            alluxioProperties.merge(HadoopConfigurationUtils.getConfigurationFromHadoop((Configuration)hdfsConf), Source.RUNTIME);
            this.mCachedNativeFs = new alluxio.client.file.FileSystem[((MasterBenchParameters)this.mParameters).mClients];
            boolean bl = false;
            while (var3_8 < this.mCachedNativeFs.length) {
                this.mCachedNativeFs[var3_8] = FileSystem.Factory.create((AlluxioConfiguration)new InstancedConfiguration(alluxioProperties));
                ++var3_8;
            }
        }
    }

    private void deletePaths(FileSystem fs, Path basePath) throws Exception {
        if (!fs.exists(basePath)) {
            return;
        }
        FileStatus[] subDirs = fs.listStatus(basePath);
        if (subDirs.length == 0) {
            return;
        }
        int fixedSize = fs.listStatus(new Path(subDirs[0].getPath(), "fixed")).length;
        long batchSize = 50000L;
        int deleteThreads = 256;
        ExecutorService service = ExecutorServiceFactories.fixedThreadPool((String)"bench-delete-thread", (int)deleteThreads).create();
        block0: for (FileStatus subDir : subDirs) {
            LOG.info("Cleaning up all files in: {}", (Object)subDir.getPath());
            AtomicLong globalCounter = new AtomicLong();
            Path fixedBase = new Path(subDir.getPath(), "fixed");
            long runningLimit = 0L;
            while (!Thread.currentThread().isInterrupted()) {
                AtomicLong success = new AtomicLong();
                long limit = runningLimit += batchSize;
                ArrayList<Callable<Void>> callables = new ArrayList<Callable<Void>>(deleteThreads);
                for (int i = 0; i < deleteThreads; ++i) {
                    callables.add(() -> {
                        while (!Thread.currentThread().isInterrupted()) {
                            long counter = globalCounter.getAndIncrement();
                            if (counter >= limit) {
                                globalCounter.getAndDecrement();
                                return null;
                            }
                            Path deletePath = counter < (long)fixedSize ? new Path(fixedBase, Long.toString(counter)) : new Path(subDir.getPath(), Long.toString(counter));
                            if (!fs.delete(deletePath, true)) continue;
                            success.getAndIncrement();
                        }
                        return null;
                    });
                }
                service.invokeAll(callables, 1L, TimeUnit.MINUTES);
                if (success.get() == 0L) continue block0;
                LOG.info("Removed {} files", (Object)success.get());
            }
        }
        service.shutdownNow();
        service.awaitTermination(10L, TimeUnit.SECONDS);
        LOG.info("Deleting base directory: {}", (Object)basePath);
        fs.delete(basePath, true);
    }

    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
    public MasterBenchTaskResult runLocal() throws Exception {
        ExecutorService service = ExecutorServiceFactories.fixedThreadPool((String)"bench-thread", (int)((MasterBenchParameters)this.mParameters).mThreads).create();
        RateLimiter rateLimiter = RateLimiter.create((double)((MasterBenchParameters)this.mParameters).mTargetThroughput);
        long fileSize = FormatUtils.parseSpaceSize((String)((MasterBenchParameters)this.mParameters).mCreateFileSize);
        this.mFiledata = new byte[(int)Math.min(fileSize, 0x4000000L)];
        Arrays.fill(this.mFiledata, (byte)122);
        long durationMs = FormatUtils.parseTimeSize((String)((MasterBenchParameters)this.mParameters).mDuration);
        long warmupMs = FormatUtils.parseTimeSize((String)((MasterBenchParameters)this.mParameters).mWarmup);
        long startMs = this.mBaseParameters.mStartMs;
        if (this.mBaseParameters.mStartMs == -1L) {
            startMs = CommonUtils.getCurrentMs() + 1000L;
        }
        long endMs = startMs + warmupMs + durationMs;
        BenchContext context = new BenchContext(rateLimiter, startMs, endMs);
        ArrayList<BenchThread> callables = new ArrayList<BenchThread>(((MasterBenchParameters)this.mParameters).mThreads);
        for (int i = 0; i < ((MasterBenchParameters)this.mParameters).mThreads; ++i) {
            callables.add(this.getBenchThread(context, i));
        }
        LOG.info("Starting {} bench threads", (Object)callables.size());
        service.invokeAll(callables, FormatUtils.parseTimeSize((String)this.mBaseParameters.mBenchTimeout), TimeUnit.MILLISECONDS);
        LOG.info("Bench threads finished");
        service.shutdownNow();
        service.awaitTermination(30L, TimeUnit.SECONDS);
        if (!this.mBaseParameters.mProfileAgent.isEmpty()) {
            context.addAdditionalResult();
        }
        return context.getResult();
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
    private BenchThread getBenchThread(BenchContext context, int index) {
        if (((MasterBenchParameters)this.mParameters).mClientType == FileSystemClientType.ALLUXIO_HDFS) {
            return new AlluxioHDFSBenchThread(context, this.mCachedFs[index % this.mCachedFs.length]);
        }
        return new AlluxioNativeBenchThread(context, this.mCachedNativeFs[index % this.mCachedNativeFs.length]);
    }

    static /* synthetic */ byte[] access$400(StressMasterBench x0) {
        return x0.mFiledata;
    }

    private final class AlluxioNativeBenchThread
    extends BenchThread {
        private final alluxio.client.file.FileSystem mFs;

        private AlluxioNativeBenchThread(BenchContext context, alluxio.client.file.FileSystem fs) {
            super(context);
            this.mFs = fs;
        }

        @Override
        @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
        protected void applyOperation(long counter) throws IOException, AlluxioException {
            switch (((MasterBenchParameters)StressMasterBench.this.mParameters).mOperation) {
                case CREATE_DIR: {
                    Path path = counter < (long)((MasterBenchParameters)StressMasterBench.this.mParameters).mFixedCount ? new Path(this.mFixedBasePath, Long.toString(counter)) : new Path(this.mBasePath, Long.toString(counter));
                    this.mFs.createDirectory(new AlluxioURI(path.toString()), CreateDirectoryPOptions.newBuilder().setRecursive(true).build());
                    break;
                }
                case CREATE_FILE: {
                    Path path = counter < (long)((MasterBenchParameters)StressMasterBench.this.mParameters).mFixedCount ? new Path(this.mFixedBasePath, Long.toString(counter)) : new Path(this.mBasePath, Long.toString(counter));
                    this.mFs.createFile(new AlluxioURI(path.toString()), CreateFilePOptions.newBuilder().setRecursive(true).build()).close();
                    break;
                }
                case GET_BLOCK_LOCATIONS: {
                    Path path = new Path(this.mFixedBasePath, Long.toString(counter %= (long)((MasterBenchParameters)StressMasterBench.this.mParameters).mFixedCount));
                    this.mFs.getBlockLocations(new AlluxioURI(path.toString()));
                    break;
                }
                case GET_FILE_STATUS: {
                    Path path = new Path(this.mFixedBasePath, Long.toString(counter %= (long)((MasterBenchParameters)StressMasterBench.this.mParameters).mFixedCount));
                    this.mFs.getStatus(new AlluxioURI(path.toString()));
                    break;
                }
                case LIST_DIR: {
                    List files = this.mFs.listStatus(new AlluxioURI(this.mFixedBasePath.toString()));
                    if (files.size() == ((MasterBenchParameters)StressMasterBench.this.mParameters).mFixedCount) break;
                    throw new IOException(String.format("listing `%s` expected %d files but got %d files", this.mFixedBasePath, ((MasterBenchParameters)StressMasterBench.this.mParameters).mFixedCount, files.size()));
                }
                case LIST_DIR_LOCATED: {
                    throw new UnsupportedOperationException("LIST_DIR_LOCATED is not supported!");
                }
                case OPEN_FILE: {
                    Path path = new Path(this.mFixedBasePath, Long.toString(counter %= (long)((MasterBenchParameters)StressMasterBench.this.mParameters).mFixedCount));
                    this.mFs.openFile(new AlluxioURI(path.toString())).close();
                    break;
                }
                case RENAME_FILE: {
                    Path path = counter < (long)((MasterBenchParameters)StressMasterBench.this.mParameters).mFixedCount ? new Path(this.mFixedBasePath, Long.toString(counter)) : new Path(this.mBasePath, Long.toString(counter));
                    Path dst = new Path(path.toString() + "-renamed");
                    this.mFs.rename(new AlluxioURI(path.toString()), new AlluxioURI(dst.toString()));
                    break;
                }
                case DELETE_FILE: {
                    Path path = counter < (long)((MasterBenchParameters)StressMasterBench.this.mParameters).mFixedCount ? new Path(this.mFixedBasePath, Long.toString(counter)) : new Path(this.mBasePath, Long.toString(counter));
                    this.mFs.delete(new AlluxioURI(path.toString()), DeletePOptions.newBuilder().setRecursive(false).build());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown operation: " + ((MasterBenchParameters)StressMasterBench.this.mParameters).mOperation);
                }
            }
        }
    }

    private final class AlluxioHDFSBenchThread
    extends BenchThread {
        private final FileSystem mFs;

        private AlluxioHDFSBenchThread(BenchContext context, FileSystem fs) {
            super(context);
            this.mFs = fs;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
        protected void applyOperation(long counter) throws IOException {
            switch (1.$SwitchMap$alluxio$stress$master$Operation[((MasterBenchParameters)StressMasterBench.this.mParameters).mOperation.ordinal()]) {
                case 1: {
                    path = counter < (long)((MasterBenchParameters)StressMasterBench.this.mParameters).mFixedCount ? new Path(this.mFixedBasePath, Long.toString(counter)) : new Path(this.mBasePath, Long.toString(counter));
                    this.mFs.mkdirs(path);
                    break;
                }
                case 2: {
                    path = counter < (long)((MasterBenchParameters)StressMasterBench.this.mParameters).mFixedCount ? new Path(this.mFixedBasePath, Long.toString(counter)) : new Path(this.mBasePath, Long.toString(counter));
                    fileSize = FormatUtils.parseSpaceSize((String)((MasterBenchParameters)StressMasterBench.this.mParameters).mCreateFileSize);
                    stream = this.mFs.create(path);
                    var7_12 = null;
                    for (i = 0L; i < fileSize; i += 0x4000000L) {
                        stream.write(StressMasterBench.access$400(StressMasterBench.this), 0, (int)Math.min(0x4000000L, fileSize - i));
                    }
                    if (stream == null) break;
                    if (var7_12 == null) ** GOTO lbl24
                    try {
                        stream.close();
                    }
                    catch (Throwable i) {
                        var7_12.addSuppressed(i);
                    }
                    break;
lbl24:
                    // 1 sources

                    stream.close();
                    break;
                    catch (Throwable i) {
                        try {
                            var7_12 = i;
                            throw i;
                        }
                        catch (Throwable var10_18) {
                            if (stream != null) {
                                if (var7_12 != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (Throwable var11_19) {
                                        var7_12.addSuppressed(var11_19);
                                    }
                                } else {
                                    stream.close();
                                }
                            }
                            throw var10_18;
                        }
                    }
                }
                case 3: {
                    path = new Path(this.mFixedBasePath, Long.toString(counter %= (long)((MasterBenchParameters)StressMasterBench.this.mParameters).mFixedCount));
                    this.mFs.getFileBlockLocations(path, 0L, 0L);
                    break;
                }
                case 4: {
                    path = new Path(this.mFixedBasePath, Long.toString(counter %= (long)((MasterBenchParameters)StressMasterBench.this.mParameters).mFixedCount));
                    this.mFs.getFileStatus(path);
                    break;
                }
                case 5: {
                    files = this.mFs.listStatus(this.mFixedBasePath);
                    if (files.length == ((MasterBenchParameters)StressMasterBench.this.mParameters).mFixedCount) break;
                    throw new IOException(String.format("listing `%s` expected %d files but got %d files", new Object[]{this.mFixedBasePath, ((MasterBenchParameters)StressMasterBench.this.mParameters).mFixedCount, files.length}));
                }
                case 6: {
                    it = this.mFs.listLocatedStatus(this.mFixedBasePath);
                    listedFiles = 0;
                    while (it.hasNext()) {
                        it.next();
                        ++listedFiles;
                    }
                    if (listedFiles == ((MasterBenchParameters)StressMasterBench.this.mParameters).mFixedCount) break;
                    throw new IOException(String.format("listing located `%s` expected %d files but got %d files", new Object[]{this.mFixedBasePath, ((MasterBenchParameters)StressMasterBench.this.mParameters).mFixedCount, listedFiles}));
                }
                case 7: {
                    path = new Path(this.mFixedBasePath, Long.toString(counter %= (long)((MasterBenchParameters)StressMasterBench.this.mParameters).mFixedCount));
                    this.mFs.open(path).close();
                    break;
                }
                case 8: {
                    path = counter < (long)((MasterBenchParameters)StressMasterBench.this.mParameters).mFixedCount ? new Path(this.mFixedBasePath, Long.toString(counter)) : new Path(this.mBasePath, Long.toString(counter));
                    dst = new Path(path.toString() + "-renamed");
                    if (this.mFs.rename(path, dst)) break;
                    throw new IOException(String.format("Failed to rename (%s) to (%s)", new Object[]{path, dst}));
                }
                case 9: {
                    path = counter < (long)((MasterBenchParameters)StressMasterBench.this.mParameters).mFixedCount ? new Path(this.mFixedBasePath, Long.toString(counter)) : new Path(this.mBasePath, Long.toString(counter));
                    if (this.mFs.delete(path, false)) break;
                    throw new IOException(String.format("Failed to delete (%s)", new Object[]{path}));
                }
                default: {
                    throw new IllegalStateException("Unknown operation: " + ((MasterBenchParameters)StressMasterBench.this.mParameters).mOperation);
                }
            }
        }
    }

    protected abstract class BenchThread
    implements Callable<Void> {
        private final BenchContext mContext;
        private final Histogram mResponseTimeNs;
        protected final Path mBasePath;
        protected final Path mFixedBasePath;
        private final MasterBenchTaskResult mResult = new MasterBenchTaskResult();

        private BenchThread(BenchContext context) {
            this.mContext = context;
            this.mResponseTimeNs = new Histogram(1800000000000L, 3);
            this.mBasePath = this.mContext.getBasePath();
            this.mFixedBasePath = this.mContext.getFixedBasePath();
        }

        @Override
        @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
        public Void call() {
            try {
                this.runInternal();
            }
            catch (Exception e) {
                LOG.warn("Exception during bench thread runInternal", (Throwable)e);
                this.mResult.addErrorMessage(e.getMessage());
            }
            this.mResult.setEndMs(CommonUtils.getCurrentMs());
            this.mResult.getStatistics().encodeResponseTimeNsRaw(this.mResponseTimeNs);
            this.mResult.setParameters((MasterBenchParameters)StressMasterBench.this.mParameters);
            this.mResult.setBaseParameters(StressMasterBench.this.mBaseParameters);
            this.mContext.mergeThreadResult(this.mResult);
            return null;
        }

        @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
        private void runInternal() throws Exception {
            long recordMs = this.mContext.getStartMs() + FormatUtils.parseTimeSize((String)((MasterBenchParameters)StressMasterBench.this.mParameters).mWarmup);
            this.mResult.setRecordStartMs(recordMs);
            boolean useStopCount = ((MasterBenchParameters)StressMasterBench.this.mParameters).mStopCount != -1;
            long bucketSize = (this.mContext.getEndMs() - recordMs) / 20L;
            long waitMs = this.mContext.getStartMs() - CommonUtils.getCurrentMs();
            if (waitMs < 0L) {
                throw new IllegalStateException(String.format("Thread missed barrier. Increase the start delay. start: %d current: %d", this.mContext.getStartMs(), CommonUtils.getCurrentMs()));
            }
            CommonUtils.sleepMs((long)waitMs);
            long localCounter = 0L;
            while (!Thread.currentThread().isInterrupted() && (useStopCount || CommonUtils.getCurrentMs() < this.mContext.getEndMs())) {
                localCounter = this.mContext.getCounter().getAndIncrement();
                if (useStopCount && localCounter >= (long)((MasterBenchParameters)StressMasterBench.this.mParameters).mStopCount) break;
                this.mContext.getRateLimiter().acquire();
                long startNs = System.nanoTime();
                this.applyOperation(localCounter);
                long endNs = System.nanoTime();
                long currentMs = CommonUtils.getCurrentMs();
                if (currentMs <= recordMs) continue;
                this.mResult.incrementNumSuccess(1L);
                long responseTimeNs = endNs - startNs;
                this.mResponseTimeNs.recordValue(responseTimeNs);
                long[] maxResponseTimeNs = this.mResult.getStatistics().mMaxResponseTimeNs;
                int bucket = Math.min(maxResponseTimeNs.length - 1, (int)((currentMs - recordMs) / bucketSize));
                if (responseTimeNs <= maxResponseTimeNs[bucket]) continue;
                maxResponseTimeNs[bucket] = responseTimeNs;
            }
        }

        protected abstract void applyOperation(long var1) throws IOException, AlluxioException;
    }

    private final class BenchContext {
        private final RateLimiter mRateLimiter;
        private final long mStartMs;
        private final long mEndMs;
        private final AtomicLong mCounter;
        private final Path mBasePath;
        private final Path mFixedBasePath;
        private MasterBenchTaskResult mResult;

        @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
        public BenchContext(RateLimiter rateLimiter, long startMs, long endMs) {
            this.mRateLimiter = rateLimiter;
            this.mStartMs = startMs;
            this.mEndMs = endMs;
            this.mCounter = new AtomicLong();
            this.mBasePath = ((MasterBenchParameters)StressMasterBench.this.mParameters).mOperation == Operation.CREATE_DIR ? new Path(PathUtils.concatPath((Object)((MasterBenchParameters)StressMasterBench.this.mParameters).mBasePath, (Object[])new Object[]{"dirs", StressMasterBench.this.mBaseParameters.mId})) : new Path(PathUtils.concatPath((Object)((MasterBenchParameters)StressMasterBench.this.mParameters).mBasePath, (Object[])new Object[]{"files", StressMasterBench.this.mBaseParameters.mId}));
            this.mFixedBasePath = new Path(this.mBasePath, "fixed");
            LOG.info("BenchContext: basePath: {}, fixedBasePath: {}", (Object)this.mBasePath, (Object)this.mFixedBasePath);
        }

        public RateLimiter getRateLimiter() {
            return this.mRateLimiter;
        }

        public long getStartMs() {
            return this.mStartMs;
        }

        public long getEndMs() {
            return this.mEndMs;
        }

        public AtomicLong getCounter() {
            return this.mCounter;
        }

        public Path getBasePath() {
            return this.mBasePath;
        }

        public Path getFixedBasePath() {
            return this.mFixedBasePath;
        }

        public synchronized void mergeThreadResult(MasterBenchTaskResult threadResult) {
            if (this.mResult == null) {
                this.mResult = threadResult;
                return;
            }
            try {
                this.mResult.merge(threadResult);
            }
            catch (Exception e) {
                LOG.warn("Exception during result merge", (Throwable)e);
                this.mResult.addErrorMessage(e.getMessage());
            }
        }

        @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
        public synchronized void addAdditionalResult() throws IOException {
            if (this.mResult == null) {
                return;
            }
            Map<String, Benchmark.MethodStatistics> nameStatistics = StressMasterBench.this.processMethodProfiles(this.mResult.getRecordStartMs(), this.mResult.getEndMs(), profileInput -> {
                String method = profileInput.getMethod();
                if (profileInput.getType().contains("RPC")) {
                    int classNameDivider = profileInput.getMethod().lastIndexOf(".");
                    method = profileInput.getMethod().substring(classNameDivider + 1);
                }
                return profileInput.getType() + ":" + method;
            });
            for (Map.Entry<String, Benchmark.MethodStatistics> entry : nameStatistics.entrySet()) {
                MasterBenchTaskResultStatistics stats = new MasterBenchTaskResultStatistics();
                stats.encodeResponseTimeNsRaw(entry.getValue().getTimeNs());
                stats.mNumSuccess = entry.getValue().getNumSuccess();
                stats.mMaxResponseTimeNs = entry.getValue().getMaxTimeNs();
                this.mResult.putStatisticsForMethod(entry.getKey(), stats);
            }
        }

        public synchronized MasterBenchTaskResult getResult() {
            return this.mResult;
        }
    }
}

