/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.cli.suite;

import alluxio.ClientContext;
import alluxio.client.job.JobMasterClient;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.stress.cli.StressJobServiceBench;
import alluxio.stress.cli.suite.AbstractMaxThroughput;
import alluxio.stress.common.GeneralBenchSummary;
import alluxio.stress.common.GeneralParameters;
import alluxio.stress.jobservice.JobServiceBenchParameters;
import alluxio.stress.jobservice.JobServiceBenchSummary;
import alluxio.stress.jobservice.JobServiceBenchTaskResult;
import alluxio.stress.jobservice.JobServiceMaxThroughputSummary;
import alluxio.util.CommonUtils;
import alluxio.util.ConfigurationUtils;
import alluxio.util.JsonSerializable;
import alluxio.worker.job.JobMasterClientContext;
import com.beust.jcommander.ParametersDelegate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class JobServiceMaxThroughput
extends AbstractMaxThroughput<JobServiceBenchTaskResult, JobServiceMaxThroughputSummary, GeneralBenchSummary<JobServiceBenchTaskResult>, JobServiceBenchParameters> {
    @ParametersDelegate
    private JobServiceBenchParameters mParameters = new JobServiceBenchParameters();
    private int mNumWorkers = 0;

    public static void main(String[] args) {
        JobServiceMaxThroughput.mainInternal(args, new JobServiceMaxThroughput());
    }

    private JobServiceMaxThroughput() {
    }

    @Override
    public JobServiceMaxThroughputSummary runSuite(String[] args) throws Exception {
        try (JobMasterClient client = JobMasterClient.Factory.create((JobMasterClientContext)JobMasterClientContext.newBuilder((ClientContext)ClientContext.create((AlluxioConfiguration)new InstancedConfiguration(ConfigurationUtils.defaults()))).build());){
            this.mNumWorkers = client.getAllWorkerHealth().size();
        }
        if (this.mNumWorkers <= 0) {
            throw new IllegalStateException("No workers available for testing!");
        }
        JobServiceMaxThroughputSummary summary = new JobServiceMaxThroughputSummary();
        summary.setParameters((GeneralParameters)this.mParameters);
        ArrayList<String> baseArgs = new ArrayList<String>(Arrays.asList(args));
        int best = this.getBestThroughput(this.mParameters.mTargetThroughput, summary, baseArgs, this.mNumWorkers);
        LOG.info("max throughput: " + best);
        summary.setEndTimeMs(CommonUtils.getCurrentMs());
        summary.setMaxThroughput((float)best);
        return summary;
    }

    @Override
    protected JobServiceBenchSummary runSingleTest(List<String> args) throws Exception {
        StressJobServiceBench b = new StressJobServiceBench();
        String result = b.run(args.toArray(new String[0]));
        return (JobServiceBenchSummary)JsonSerializable.fromJson((String)result, (JsonSerializable[])new JobServiceBenchSummary[0]);
    }
}

