/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.cli.client;

import alluxio.AlluxioURI;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.AlluxioProperties;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.exception.FileAlreadyExistsException;
import alluxio.exception.FileDoesNotExistException;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.grpc.DeletePOptions;
import alluxio.grpc.ListStatusPOptions;
import alluxio.retry.CountingRetry;
import alluxio.stress.cli.Benchmark;
import alluxio.stress.client.CompactionParameters;
import alluxio.stress.client.CompactionTaskResult;
import alluxio.util.CommonUtils;
import alluxio.util.ConfigurationUtils;
import alluxio.util.FormatUtils;
import alluxio.util.executor.ExecutorServiceFactories;
import com.beust.jcommander.ParametersDelegate;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.HdrHistogram.Histogram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionBench
extends Benchmark<CompactionTaskResult> {
    private static final Logger LOG = LoggerFactory.getLogger(CompactionBench.class);
    protected ExecutorService mPool = null;
    @ParametersDelegate
    protected final CompactionParameters mParameters = new CompactionParameters();
    protected FileSystem[] mCachedFs;
    private AlluxioURI mRealSourceBase;

    public static void main(String[] args) {
        CompactionBench.mainInternal(args, new CompactionBench());
    }

    @Override
    public String getBenchDescription() {
        return String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)ImmutableList.of((Object)"A benchmark that simulates the workload of compacting many small files into a bigger file.", (Object)"", (Object)"Example:", (Object)"# This example creates 4 source directories each containing 100 source files that are 10KB each,", (Object)"# and compacts every 10 source files into 1 output file, resulting in 40 output files in", (Object)"# a single output directory.", (Object)"# The compaction is done on 1 job worker with 5 threads, meaning each thread will process 80 source", (Object)"# files in 8 sequential batches.", (Object)"$ bin/alluxio runClass alluxio.stress.cli.client.CompactionBench --cluster --cluster-limit 1 --base alluxio:///compaction-base --source-files 1000 --source-dirs 4 --source-file-size 10kb --threads 5 --compact-ratio 10 "));
    }

    @Override
    public CompactionTaskResult runLocal() throws Exception {
        this.mCachedFs = new FileSystem[this.mParameters.mThreads];
        AlluxioProperties properties = CompactionBench.getCustomProperties(this.mParameters.mCompactProperties);
        for (int i = 0; i < this.mParameters.mThreads; ++i) {
            this.mCachedFs[i] = FileSystem.Factory.create((AlluxioConfiguration)new InstancedConfiguration(properties));
        }
        FileSystem fs = this.mCachedFs[0];
        AlluxioURI baseUri = new AlluxioURI(this.mParameters.mBase);
        AlluxioURI destBaseUri = baseUri.join(this.mParameters.mOutputBase);
        AlluxioURI stagingBaseUri = baseUri.join(this.mParameters.mStagingBase);
        List subDirs = fs.listStatus(this.mRealSourceBase).stream().filter(URIStatus::isFolder).map(uri -> new AlluxioURI(this.mRealSourceBase, uri.getPath(), false)).collect(Collectors.toList());
        List partitions = CompactionBench.exactPartition(subDirs, this.mParameters.mThreads);
        ArrayList<CompletableFuture<CompactionTaskResult>> futures = new ArrayList<CompletableFuture<CompactionTaskResult>>(this.mParameters.mThreads);
        try {
            for (int i = 0; i < this.mParameters.mThreads; ++i) {
                List partition = partitions.get(i);
                Map<AlluxioURI, AlluxioURI> map = partition.stream().collect(Collectors.toMap(src -> src, src -> this.mParameters.mOutputInPlace ? src : destBaseUri));
                BenchThread thread = new BenchThread(this.mCachedFs[i], map, stagingBaseUri, this.mParameters.mCompactRatio, FormatUtils.parseTimeSize((String)this.mParameters.mDelayMs), (int)FormatUtils.parseSpaceSize((String)this.mParameters.mBufSize), this.mParameters.mPreserveSource, this.mParameters.mDeleteByDir, this.mBaseParameters.mId);
                CompletableFuture<CompactionTaskResult> future = CompletableFuture.supplyAsync(() -> {
                    CompactionTaskResult result;
                    try {
                        result = thread.call();
                    }
                    catch (Exception e) {
                        LOG.error("Failed to run compaction thread", (Throwable)e);
                        result = new CompactionTaskResult();
                        result.addError(e.getMessage());
                    }
                    return result;
                }, this.getPool());
                futures.add(future);
            }
            LOG.info("{} jobs submitted", (Object)futures.size());
            CompactionTaskResult result = new CompactionTaskResult();
            result.setBaseParameters(this.mBaseParameters);
            result.setParameters(this.mParameters);
            for (CompletableFuture completableFuture : futures) {
                CompactionTaskResult threadResult = (CompactionTaskResult)completableFuture.join();
                result.merge(threadResult);
            }
            return result;
        }
        catch (Exception e) {
            LOG.error("Failed to execute RPC in pool", (Throwable)e);
            CompactionTaskResult result = new CompactionTaskResult();
            result.setBaseParameters(this.mBaseParameters);
            result.setParameters(this.mParameters);
            result.addError(e.getMessage());
            return result;
        }
    }

    @Override
    public void prepare() throws Exception {
        Preconditions.checkArgument((this.mParameters.mThreads > 0 ? 1 : 0) != 0, (Object)"mThreads");
        AlluxioProperties properties = CompactionBench.getCustomProperties(this.mParameters.mPrepareProperties);
        FileSystem prepareFs = FileSystem.Factory.create((AlluxioConfiguration)new InstancedConfiguration(properties));
        int flags = Boolean.compare(this.mBaseParameters.mDistributed, false) << 2 | Boolean.compare(this.mBaseParameters.mCluster, false) << 1 | Boolean.compare(this.mBaseParameters.mInProcess, false);
        switch (flags) {
            case 0: 
            case 2: {
                if (this.mParameters.mSkipPrepare) break;
                this.prepareSourceBaseDir(prepareFs);
                this.prepareOutputBaseDir(prepareFs);
                this.prepareStagingBaseDir(prepareFs);
                break;
            }
            case 1: {
                this.mRealSourceBase = new AlluxioURI(this.mParameters.mBase).join(this.mParameters.mSourceBase).join("local");
                if (this.mParameters.mSkipPrepare) break;
                this.prepareSourceFiles(prepareFs);
                break;
            }
            case 5: {
                this.mRealSourceBase = new AlluxioURI(this.mParameters.mBase).join(this.mParameters.mSourceBase).join(this.mBaseParameters.mId);
                if (this.mParameters.mSkipPrepare) break;
                this.prepareSourceFiles(prepareFs);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unknown combination of flags: %s", Integer.toBinaryString(flags)));
            }
        }
    }

    private static AlluxioProperties getCustomProperties(List<String> propertyList) {
        AlluxioProperties properties = ConfigurationUtils.defaults();
        for (String property : propertyList) {
            String[] parts = property.split("=", 2);
            Preconditions.checkArgument((parts.length == 2 ? 1 : 0) != 0, (String)"Property should be set as \"key=value\", got %s", (Object)property);
            properties.set(PropertyKey.fromString((String)parts[0]), (Object)parts[1]);
        }
        return properties;
    }

    private void prepareStagingBaseDir(FileSystem fs) throws IOException, AlluxioException {
        try {
            fs.createDirectory(new AlluxioURI(this.mParameters.mBase).join(this.mParameters.mStagingBase), CreateDirectoryPOptions.newBuilder().setRecursive(true).build());
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
    }

    private void prepareOutputBaseDir(FileSystem fs) throws IOException, AlluxioException {
        if (!this.mParameters.mOutputInPlace) {
            AlluxioURI path = new AlluxioURI(this.mParameters.mBase).join(this.mParameters.mOutputBase);
            try {
                fs.delete(path, DeletePOptions.newBuilder().setRecursive(true).build());
            }
            catch (FileDoesNotExistException fileDoesNotExistException) {
                // empty catch block
            }
            fs.createDirectory(path, CreateDirectoryPOptions.newBuilder().setRecursive(true).build());
        }
    }

    private void prepareSourceBaseDir(FileSystem fs) throws IOException, AlluxioException {
        try {
            fs.createDirectory(new AlluxioURI(this.mParameters.mBase).join(this.mParameters.mSourceBase), CreateDirectoryPOptions.newBuilder().setRecursive(true).build());
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareSourceFiles(FileSystem fs) throws Exception {
        int fileSize = (int)FormatUtils.parseSpaceSize((String)this.mParameters.mSourceFileSize);
        byte[] fileData = new byte[Math.min(fileSize, 0x100000)];
        Arrays.fill(fileData, (byte)122);
        try {
            fs.createDirectory(this.mRealSourceBase);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
        AtomicInteger numDirsCreated = new AtomicInteger();
        int createFilesParallelism = Runtime.getRuntime().availableProcessors() * 2;
        ExecutorService pool = ExecutorServiceFactories.fixedThreadPool((String)"compact-bench-prepare-thread", (int)createFilesParallelism).create();
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>(createFilesParallelism);
        for (int i = 0; i < createFilesParallelism; ++i) {
            CompletableFuture future = CompletableFuture.supplyAsync(() -> {
                try {
                    int localNumDirsCreated;
                    while ((localNumDirsCreated = numDirsCreated.getAndIncrement()) < this.mParameters.mNumSourceDirs) {
                        LOG.info("creating directory {}/{} ", (Object)localNumDirsCreated, (Object)this.mParameters.mNumSourceDirs);
                        AlluxioURI dir = this.mRealSourceBase.join(Integer.toString(localNumDirsCreated));
                        try {
                            fs.createDirectory(dir);
                        }
                        catch (FileAlreadyExistsException fileAlreadyExistsException) {
                            // empty catch block
                        }
                        for (int f = 0; f < this.mParameters.mNumSourceFiles; ++f) {
                            AlluxioURI path = dir.join(Integer.toString(f));
                            try (FileOutStream stream = fs.createFile(path);){
                                for (long offset = 0L; offset < (long)fileSize; offset += (long)fileData.length) {
                                    stream.write(fileData, 0, (int)Math.min((long)fileData.length, (long)fileSize - offset));
                                }
                            }
                            catch (FileAlreadyExistsException e) {
                                fs.delete(path);
                                --f;
                            }
                            if (f % (this.mParameters.mNumSourceFiles / 10) != 0) continue;
                            LOG.info("{}/{} files created in dir {}", new Object[]{f, this.mParameters.mNumSourceFiles, localNumDirsCreated});
                        }
                        LOG.info("{}/{} directories created", (Object)localNumDirsCreated, (Object)this.mParameters.mNumSourceDirs);
                    }
                }
                catch (AlluxioException | IOException e) {
                    return e;
                }
                return null;
            }, pool);
            futures.add(future);
        }
        try {
            for (CompletableFuture future : futures) {
                Exception e = (Exception)future.join();
                if (e == null) continue;
                LOG.error("Failed to prepare test directory and files", (Throwable)e);
                throw e;
            }
        }
        finally {
            pool.shutdownNow();
            pool.awaitTermination(30L, TimeUnit.SECONDS);
        }
    }

    @Override
    public void cleanup() throws Exception {
        super.cleanup();
        if (this.mPool != null) {
            LOG.debug("Terminating thread pool");
            this.mPool.shutdownNow();
            this.mPool.awaitTermination(30L, TimeUnit.SECONDS);
        }
    }

    public ExecutorService getPool() {
        if (this.mPool == null) {
            this.mPool = ExecutorServiceFactories.fixedThreadPool((String)"compact-benchmark-thread", (int)this.mParameters.mThreads).create();
        }
        return this.mPool;
    }

    private static <T> List<List<T>> exactPartition(List<T> list, int numPartitions) {
        int i;
        int length = list.size();
        int sizePerPartition = length / numPartitions;
        int leftover = length % numPartitions;
        int leftoverEndIndex = (sizePerPartition + 1) * leftover;
        ArrayList<List<T>> partitions = new ArrayList<List<T>>(numPartitions);
        for (i = 0; i < leftover; ++i) {
            partitions.add(list.subList(i * (sizePerPartition + 1), (i + 1) * (sizePerPartition + 1)));
        }
        for (i = 0; i < numPartitions - leftover; ++i) {
            partitions.add(list.subList(leftoverEndIndex + i * sizePerPartition, leftoverEndIndex + (i + 1) * sizePerPartition));
        }
        return partitions;
    }

    static class Compactor {
        private final FileSystem mFs;
        private final AlluxioURI mOutputBase;
        private final String mOutputFileName;
        private final Iterator<AlluxioURI> mInputs;
        private final AlluxioURI mStagingBase;
        private final byte[] mBuffer;

        public Compactor(FileSystem fs, Iterator<AlluxioURI> inputs, AlluxioURI outputBase, String outputFileName, AlluxioURI stagingBase, int bufSize) {
            this.mFs = fs;
            this.mOutputBase = outputBase;
            this.mOutputFileName = outputFileName;
            this.mInputs = inputs;
            this.mStagingBase = stagingBase;
            this.mBuffer = new byte[bufSize];
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() throws IOException, AlluxioException {
            AlluxioURI tempFile = this.mStagingBase.join(CommonUtils.randomAlphaNumString((int)8));
            try (FileOutStream out = this.mFs.createFile(tempFile);){
                while (this.mInputs.hasNext()) {
                    FileInStream input;
                    block26: {
                        input = this.mFs.openFile(this.mInputs.next());
                        Throwable throwable = null;
                        try {
                            int bytesRead;
                            while ((bytesRead = input.read(this.mBuffer)) >= 0) {
                                out.write(this.mBuffer, 0, bytesRead);
                            }
                            if (input == null) continue;
                            if (throwable == null) break block26;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (input == null) throw throwable3;
                                if (throwable == null) {
                                    input.close();
                                    throw throwable3;
                                }
                                try {
                                    input.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                        }
                        try {
                            input.close();
                            continue;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            continue;
                        }
                    }
                    input.close();
                }
            }
            CountingRetry retry = new CountingRetry(5);
            String nameSuffix = "";
            boolean done = false;
            while (retry.attempt()) {
                try {
                    this.mFs.rename(tempFile, this.mOutputBase.join(this.mOutputFileName + nameSuffix));
                    done = true;
                    break;
                }
                catch (FileAlreadyExistsException ignored) {
                    nameSuffix = "_" + retry.getAttemptCount();
                }
            }
            if (done) return;
            throw new FileAlreadyExistsException(String.format("Output file %s already exists, renaming failed after %d attempts", this.mOutputFileName, retry.getAttemptCount()));
        }
    }

    static class BenchThread
    implements Callable<CompactionTaskResult> {
        private final FileSystem mFs;
        private final Map<AlluxioURI, AlluxioURI> mSrcDestMap;
        private final AlluxioURI mStagingDir;
        private final int mCompactRatio;
        private final long mDelayMs;
        private final int mBufSize;
        private final boolean mPreserveSource;
        private final boolean mDeleteByDir;
        private final String mWorkerId;
        private final CompactionTaskResult mResult;
        private final Histogram mRawRecords;

        public BenchThread(FileSystem fs, Map<AlluxioURI, AlluxioURI> dirMap, AlluxioURI stagingDir, int compactRatio, long delayMs, int bufSize, boolean preserveSource, boolean deleteByDir, String workerId) {
            Preconditions.checkArgument((compactRatio >= 1 ? 1 : 0) != 0, (Object)"compactRatio should be 1 or greater");
            Preconditions.checkArgument((delayMs >= 0L ? 1 : 0) != 0, (Object)"delayMs should be 0 or greater");
            Preconditions.checkArgument((bufSize > 0 ? 1 : 0) != 0, (Object)"buffer size should be greater than 0");
            this.mFs = fs;
            this.mSrcDestMap = dirMap;
            this.mStagingDir = stagingDir;
            this.mCompactRatio = compactRatio;
            this.mDelayMs = delayMs;
            this.mBufSize = bufSize;
            this.mPreserveSource = preserveSource;
            this.mDeleteByDir = deleteByDir;
            this.mWorkerId = workerId;
            this.mResult = new CompactionTaskResult();
            this.mRawRecords = new Histogram(1800000000000L, 3);
        }

        @Override
        public CompactionTaskResult call() throws Exception {
            this.runInternal();
            return this.mResult;
        }

        private void runInternal() throws Exception {
            Stopwatch stopwatch = Stopwatch.createUnstarted();
            for (Map.Entry<AlluxioURI, AlluxioURI> entry : this.mSrcDestMap.entrySet()) {
                AlluxioURI srcDir = entry.getKey();
                AlluxioURI destDir = entry.getValue();
                List files = this.mFs.listStatus(srcDir, ListStatusPOptions.newBuilder().setRecursive(false).build()).stream().filter(uri -> !uri.isFolder() && uri.isCompleted()).map(uri -> new AlluxioURI(srcDir, uri.getPath(), false)).collect(Collectors.toList());
                List batches = Lists.partition(files, (int)this.mCompactRatio);
                LOG.info("Partitioned {} files in dir {} into {} batches, each with {} files", new Object[]{files.size(), srcDir, batches.size(), this.mCompactRatio});
                for (int i = 0; i < batches.size(); ++i) {
                    List batch = (List)batches.get(i);
                    String outputFileName = String.format("compact_output_part%d_dir%s_worker%s", i, srcDir.getName(), this.mWorkerId);
                    Compactor compactor = new Compactor(this.mFs, batch.iterator(), destDir, outputFileName, this.mStagingDir, this.mBufSize);
                    try {
                        stopwatch.reset();
                        stopwatch.start();
                        compactor.run();
                        stopwatch.stop();
                        this.mRawRecords.recordValue(stopwatch.elapsed(TimeUnit.NANOSECONDS));
                        this.mResult.incrementNumSuccess();
                    }
                    catch (Exception e) {
                        LOG.warn("Batch {} in dir {} failed", (Object)(i + 1), (Object)e);
                        this.mResult.addError(e.getMessage());
                    }
                    LOG.info("Batch {}/{} in dir {} finished", new Object[]{i + 1, batches.size(), srcDir});
                    Thread.sleep(this.mDelayMs);
                }
                if (!this.mPreserveSource) {
                    if (!this.mDeleteByDir) {
                        for (AlluxioURI file : files) {
                            this.mFs.delete(file);
                        }
                        this.mFs.delete(srcDir, DeletePOptions.newBuilder().build());
                    } else {
                        this.mFs.delete(srcDir, DeletePOptions.newBuilder().setRecursive(true).build());
                    }
                }
                this.mResult.getStatistics().encodeResponseTimeNsRaw(this.mRawRecords);
            }
        }
    }
}

