/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.cli;

import alluxio.AlluxioURI;
import alluxio.ClientContext;
import alluxio.client.file.FileSystemContext;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.DeletePOptions;
import alluxio.grpc.FileSystemMasterWorkerServiceGrpc;
import alluxio.grpc.GetPinnedFileIdsPRequest;
import alluxio.grpc.SetAttributePOptions;
import alluxio.master.MasterClientContext;
import alluxio.resource.CloseableResource;
import alluxio.stress.cli.RpcBench;
import alluxio.stress.rpc.GetPinnedFileIdsParameters;
import alluxio.stress.rpc.RpcTaskResult;
import alluxio.util.CommonUtils;
import alluxio.util.FormatUtils;
import alluxio.worker.file.FileSystemMasterClient;
import com.beust.jcommander.ParametersDelegate;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import io.grpc.Channel;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetPinnedFileIdsBench
extends RpcBench<GetPinnedFileIdsParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(GetPinnedFileIdsBench.class);
    @ParametersDelegate
    private final GetPinnedFileIdsParameters mParameters = new GetPinnedFileIdsParameters();
    private final InstancedConfiguration mConf = InstancedConfiguration.defaults();
    private final FileSystemContext mFileSystemContext = FileSystemContext.create((AlluxioConfiguration)this.mConf);
    private final ThreadLocal<Stopwatch> mDurationStopwatch = ThreadLocal.withInitial(Stopwatch::createUnstarted);
    private final ThreadLocal<Stopwatch> mPointStopwatch = ThreadLocal.withInitial(Stopwatch::createUnstarted);
    private final PinListFileSystemMasterClient mWorkerClient = new PinListFileSystemMasterClient(MasterClientContext.newBuilder((ClientContext)ClientContext.create((AlluxioConfiguration)this.mConf)).build());

    @Override
    public String getBenchDescription() {
        return String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)ImmutableList.of((Object)"A benchmarking tool for the GetPinnedFileIds RPC.", (Object)"The test will generate a specified number of test files and pin them. Then it will keep calling the GetPinnedFileIds RPC by the specified load until the specified duration has elapsed. The test files will be cleaned up in the end.", (Object)"", (Object)"Example:", (Object)"# 2 job workers will be chosen to run the benchmark", (Object)"# Each job worker runs 3 simulated clients", (Object)"# Each client keeps requesting a total number of 10k pinned files for a total of 100 milliseconds", (Object)"$ bin/alluxio runClass alluxio.stress.cli.GetPinnedFileIdsBench --concurrency 3 \\", (Object)"--cluster --cluster-limit 2 --num-files 10000 --duration 100ms", (Object)""));
    }

    @Override
    public void prepare() throws Exception {
        LOG.info("Task ID is {}", (Object)this.mBaseParameters.mId);
        if (this.mBaseParameters.mDistributed) {
            LOG.info("Skipping preparation in distributed execution");
            return;
        }
        AlluxioURI baseUri = new AlluxioURI(this.mParameters.mBasePath);
        try (CloseableResource client = this.mFileSystemContext.acquireMasterClientResource();){
            LOG.info("Creating temporary directory {} for benchmark", (Object)baseUri);
            ((alluxio.client.file.FileSystemMasterClient)client.get()).createDirectory(baseUri, CreateDirectoryPOptions.newBuilder().setAllowExists(true).build());
        }
        int numFiles = this.mParameters.mNumFiles;
        int fileNameLength = (int)Math.ceil(Math.max(8.0, Math.log10(numFiles)));
        CompletableFuture[] futures = new CompletableFuture[numFiles];
        LOG.info("Generating {} pinned test files at the master", (Object)numFiles);
        for (int i = 0; i < numFiles; ++i) {
            CompletableFuture future;
            AlluxioURI fileUri = baseUri.join(CommonUtils.randomAlphaNumString((int)fileNameLength));
            futures[i] = future = CompletableFuture.supplyAsync(() -> {
                try (CloseableResource client = this.mFileSystemContext.acquireMasterClientResource();){
                    ((alluxio.client.file.FileSystemMasterClient)client.get()).createFile(fileUri, CreateFilePOptions.newBuilder().setBlockSizeBytes(this.mConf.getBytes(PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT)).build());
                    ((alluxio.client.file.FileSystemMasterClient)client.get()).setAttribute(fileUri, SetAttributePOptions.newBuilder().setPinned(true).build());
                }
                catch (AlluxioStatusException e) {
                    LOG.warn("Exception during file creation of {}", (Object)fileUri, (Object)e);
                }
                return null;
            }, this.getPool());
        }
        CompletableFuture.allOf(futures).join();
        LOG.info("Test files generated");
    }

    @Override
    public void cleanup() throws Exception {
        if (this.mBaseParameters.mDistributed) {
            LOG.info("Skipping cleanup in distributed execution");
        } else {
            AlluxioURI baseUri = new AlluxioURI(this.mParameters.mBasePath);
            try (CloseableResource client = this.mFileSystemContext.acquireMasterClientResource();){
                LOG.info("Deleting test directory {}", (Object)baseUri);
                ((alluxio.client.file.FileSystemMasterClient)client.get()).delete(baseUri, DeletePOptions.newBuilder().setRecursive(true).build());
            }
            catch (AlluxioStatusException e) {
                LOG.warn("Failed to delete test directory {}, manual cleanup needed", (Object)baseUri, (Object)e);
            }
        }
        super.cleanup();
    }

    @Override
    public RpcTaskResult runRPC() throws Exception {
        RpcTaskResult result = new RpcTaskResult();
        this.mDurationStopwatch.get().reset().start();
        long durationMs = FormatUtils.parseTimeSize((String)this.mParameters.mDuration);
        LOG.info("Beginning benchmark, running for {} ms", (Object)durationMs);
        while (this.mDurationStopwatch.get().elapsed(TimeUnit.MILLISECONDS) < durationMs) {
            try {
                this.mPointStopwatch.get().reset().start();
                int numPinnedFiles = this.mWorkerClient.getPinListLength();
                this.mPointStopwatch.get().stop();
                if (numPinnedFiles != this.mParameters.mNumFiles) {
                    result.addError(String.format("Unexpected number of files: %d, expected %d", numPinnedFiles, this.mParameters.mNumFiles));
                    continue;
                }
                result.addPoint(new RpcTaskResult.Point(this.mPointStopwatch.get().elapsed(TimeUnit.MILLISECONDS)));
            }
            catch (Exception e) {
                LOG.error("Failed when running", (Throwable)e);
                result.addError(e.getMessage());
            }
        }
        return result;
    }

    @Override
    public GetPinnedFileIdsParameters getParameters() {
        return this.mParameters;
    }

    public static void main(String[] args) {
        GetPinnedFileIdsBench.mainInternal(args, new GetPinnedFileIdsBench());
    }

    private static class PinListFileSystemMasterClient
    extends FileSystemMasterClient {
        private static final Logger LOG = LoggerFactory.getLogger(PinListFileSystemMasterClient.class);
        private FileSystemMasterWorkerServiceGrpc.FileSystemMasterWorkerServiceBlockingStub mClient = null;

        public PinListFileSystemMasterClient(MasterClientContext conf) {
            super(conf);
        }

        protected void afterConnect() throws IOException {
            this.mClient = FileSystemMasterWorkerServiceGrpc.newBlockingStub((Channel)this.mChannel);
        }

        public int getPinListLength() throws IOException {
            return (Integer)this.retryRPC(() -> ((FileSystemMasterWorkerServiceGrpc.FileSystemMasterWorkerServiceBlockingStub)this.mClient.withDeadlineAfter(this.mContext.getClusterConf().getMs(PropertyKey.WORKER_MASTER_PERIODICAL_RPC_TIMEOUT), TimeUnit.MILLISECONDS)).getPinnedFileIds(GetPinnedFileIdsPRequest.newBuilder().build()).getPinnedFileIdsCount(), LOG, "GetPinList", "", new Object[0]);
        }
    }
}

