/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.cli;

import alluxio.ClientContext;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.ConfigProperty;
import alluxio.master.MasterClientContext;
import alluxio.stress.rpc.TierAlias;
import alluxio.util.executor.ExecutorServiceFactories;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.wire.WorkerNetAddress;
import alluxio.worker.block.BlockMasterClient;
import alluxio.worker.block.BlockStoreLocation;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcBenchPreparationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RpcBenchPreparationUtils.class);
    public static final long CAPACITY = 0x500000000L;
    public static final Map<String, Long> CAPACITY_MEM = ImmutableMap.of((Object)TierAlias.MEM.toString(), (Object)0x500000000L);
    public static final Map<String, Long> USED_MEM_EMPTY = ImmutableMap.of((Object)TierAlias.MEM.toString(), (Object)0L);
    public static final BlockStoreLocation BLOCK_LOCATION_MEM = new BlockStoreLocation(TierAlias.MEM.toString(), 0, TierAlias.MEM.toString());
    public static final Map<String, List<String>> LOST_STORAGE = ImmutableMap.of((Object)TierAlias.MEM.toString(), (Object)ImmutableList.of());
    public static final List<ConfigProperty> EMPTY_CONFIG = ImmutableList.of();

    private RpcBenchPreparationUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prepareBlocksInMaster(Map<BlockStoreLocation, List<Long>> locToBlocks) throws InterruptedException {
        int concurrency = Runtime.getRuntime().availableProcessors() * 4;
        ArrayList jobs = new ArrayList();
        long totalBlocks = 0L;
        for (Map.Entry<BlockStoreLocation, List<Long>> e : locToBlocks.entrySet()) {
            List<Long> v = e.getValue();
            totalBlocks += (long)v.size();
            jobs.addAll(Lists.partition((List)v, (int)Math.min(v.size() / concurrency, 1000)));
        }
        long totalBlocksFinal = totalBlocks;
        LOG.info("Split block ID generation into {} jobs", (Object)jobs.size());
        for (List job : jobs) {
            LOG.debug("Block ids: [{},{}]", job.get(0), job.get(job.size() - 1));
        }
        ExecutorService pool = ExecutorServiceFactories.fixedThreadPool((String)"rpc-bench-prepare", (int)concurrency).create();
        long blockSize = Configuration.getBytes((PropertyKey)PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT);
        CompletableFuture[] futures = new CompletableFuture[jobs.size()];
        AtomicInteger progress = new AtomicInteger(0);
        for (int i = 0; i < jobs.size(); ++i) {
            CompletableFuture future;
            List job = (List)jobs.get(i);
            int batchIndex = i;
            int batchSize = job.size();
            futures[i] = future = CompletableFuture.supplyAsync(() -> {
                BlockMasterClient client = new BlockMasterClient(MasterClientContext.newBuilder((ClientContext)ClientContext.create()).build());
                for (Long blockId : job) {
                    try {
                        client.commitBlockInUfs(blockId.longValue(), blockSize);
                    }
                    catch (IOException e) {
                        LOG.error("Failed to commitBlockInUfs in batch {}, blockId={} total={}", new Object[]{batchIndex, blockId, totalBlocksFinal, e});
                    }
                }
                long finishedCount = progress.addAndGet(batchSize);
                LOG.info("Generated {}th batch of {} blocks, {}% completed", new Object[]{batchIndex, batchSize, String.format("%.2f", 100.0 * (double)finishedCount / (double)totalBlocksFinal)});
                return null;
            }, pool);
        }
        LOG.info("Collect all results");
        try {
            CompletableFuture.allOf(futures).join();
        }
        finally {
            pool.shutdownNow();
            pool.awaitTermination(30L, TimeUnit.SECONDS);
        }
    }

    static Deque<Long> prepareWorkerIds(BlockMasterClient client, int numWorkers) throws IOException {
        ArrayDeque<Long> workerPool = new ArrayDeque<Long>();
        int freePort = 40000;
        for (int i = 0; i < numWorkers; ++i) {
            LOG.info("Preparing worker {}", (Object)i);
            String hostname = NetworkAddressUtils.getLocalHostName((int)500);
            LOG.info("Detected local hostname {}", (Object)hostname);
            WorkerNetAddress address = new WorkerNetAddress().setHost(hostname).setDataPort(freePort++).setRpcPort(freePort++).setWebPort(freePort++);
            long workerId = client.getId(address);
            LOG.info("Created worker ID {} on {}", (Object)workerId, (Object)address);
            workerPool.offer(workerId);
        }
        return workerPool;
    }

    static void registerWorkers(BlockMasterClient client, Deque<Long> workerIds) throws IOException {
        for (long w : workerIds) {
            LOG.info("Worker {} registering", (Object)w);
            client.register(w, (List)ImmutableList.of((Object)TierAlias.MEM.toString()), CAPACITY_MEM, USED_MEM_EMPTY, (Map)ImmutableMap.of((Object)BLOCK_LOCATION_MEM, (Object)ImmutableList.of()), LOST_STORAGE, EMPTY_CONFIG);
        }
        LOG.info("All workers registered");
    }

    public static Map<BlockStoreLocation, List<Long>> generateBlockIdOnTiers(Map<TierAlias, List<Integer>> tiersConfig) {
        HashMap<BlockStoreLocation, List<Long>> blockMap = new HashMap<BlockStoreLocation, List<Long>>();
        long blockIdStart = Long.MAX_VALUE;
        for (Map.Entry<TierAlias, List<Integer>> tierConfig : tiersConfig.entrySet()) {
            List<Integer> dirConfigs = tierConfig.getValue();
            for (int i = 0; i < dirConfigs.size(); ++i) {
                int dirNumBlocks = dirConfigs.get(i);
                LOG.info("Found dir on tier {} with {} blocks", (Object)tierConfig.getKey(), (Object)dirNumBlocks);
                BlockStoreLocation loc = new BlockStoreLocation(tierConfig.getKey().toString(), i);
                List<Long> blockIds = RpcBenchPreparationUtils.generateDecreasingNumbers(blockIdStart, dirNumBlocks);
                blockMap.put(loc, blockIds);
                blockIdStart -= (long)dirNumBlocks;
            }
        }
        return blockMap;
    }

    private static List<Long> generateDecreasingNumbers(long start, int count) {
        LOG.info("Generating block Ids ({}, {}]", (Object)(start - (long)count), (Object)start);
        ArrayList<Long> list = new ArrayList<Long>(count);
        for (long i = 0L; i < (long)count; ++i) {
            list.add(start - i);
        }
        return list;
    }
}

