/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.cli;

import alluxio.annotation.SuppressFBWarnings;
import alluxio.client.file.FileSystem;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.Source;
import alluxio.exception.AlluxioException;
import alluxio.hadoop.HadoopConfigurationUtils;
import alluxio.stress.cli.StressMasterBenchBase;
import alluxio.stress.common.FileSystemClientType;
import alluxio.stress.master.MasterBenchBaseParameters;
import alluxio.stress.master.MasterBenchParameters;
import alluxio.stress.master.MasterBenchTaskResult;
import alluxio.stress.master.Operation;
import alluxio.util.CommonUtils;
import alluxio.util.FormatUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.RateLimiter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.Callable;
import org.HdrHistogram.Histogram;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StressMasterBench
extends StressMasterBenchBase<MasterBenchTaskResult, MasterBenchParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(StressMasterBench.class);

    public StressMasterBench() {
        super(new MasterBenchParameters());
    }

    public static void main(String[] args) {
        StressMasterBench.mainInternal(args, new StressMasterBench());
    }

    @Override
    public String getBenchDescription() {
        return String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)ImmutableList.of((Object)"A benchmarking tool to measure the master performance of Alluxio", (Object)"MaxThroughput is the recommended way to run the Master Stress Bench.", (Object)"", (Object)"Example:", (Object)"# this would continuously run `ListDir` opeartion for 30s and record the throughput after 5s warmup.", (Object)"$ bin/alluxio runClass alluxio.stress.cli.StressMasterBench --operation ListDir \\", (Object)"--warmup 5s --duration 30s --cluster", (Object)""));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
    public void prepare() throws Exception {
        block10: {
            void var3_8;
            Configuration hdfsConf;
            block9: {
                if (((MasterBenchParameters)this.mParameters).mFixedCount <= 0) {
                    throw new IllegalStateException("fixed count must be > 0. fixedCount: " + ((MasterBenchParameters)this.mParameters).mFixedCount);
                }
                if (!this.mBaseParameters.mDistributed) {
                    hdfsConf = new Configuration();
                    hdfsConf.set("alluxio.user.file.delete.unchecked", "true");
                    hdfsConf.set("alluxio.user.file.writetype.default", ((MasterBenchParameters)this.mParameters).mWriteType);
                    hdfsConf.set("alluxio.user.file.master.client.pool.size.max", "256");
                    FileSystem prepareFs = FileSystem.get((URI)new URI(((MasterBenchParameters)this.mParameters).mBasePath), (Configuration)hdfsConf);
                    Path path = new Path(((MasterBenchParameters)this.mParameters).mBasePath);
                    Path basePath = ((MasterBenchParameters)this.mParameters).mOperation == Operation.CREATE_DIR ? new Path(path, "dirs") : (((MasterBenchParameters)this.mParameters).mOperation == Operation.CREATE_TREE || ((MasterBenchParameters)this.mParameters).mOperation == Operation.LOAD_METADATA ? new Path(path, this.extractHostName(this.mBaseParameters.mId)) : new Path(path, "files"));
                    if (((MasterBenchParameters)this.mParameters).mOperation == Operation.CREATE_FILE || ((MasterBenchParameters)this.mParameters).mOperation == Operation.CREATE_DIR) {
                        LOG.info("Cleaning base path: {}", (Object)basePath);
                        long start = CommonUtils.getCurrentMs();
                        this.deletePaths(prepareFs, basePath);
                        long end = CommonUtils.getCurrentMs();
                        LOG.info("Cleanup took: {} s", (Object)((double)(end - start) / 1000.0));
                        prepareFs.mkdirs(basePath);
                    } else if (((MasterBenchParameters)this.mParameters).mOperation != Operation.CREATE_TREE && ((MasterBenchParameters)this.mParameters).mOperation != Operation.LOAD_METADATA && !prepareFs.exists(basePath)) {
                        throw new IllegalStateException(String.format("base path (%s) must exist for operation (%s)", basePath, ((MasterBenchParameters)this.mParameters).mOperation));
                    }
                    if (((MasterBenchParameters)this.mParameters).mOperation != Operation.CREATE_TREE && ((MasterBenchParameters)this.mParameters).mOperation != Operation.LOAD_METADATA && !prepareFs.getFileStatus(basePath).isDirectory()) {
                        throw new IllegalStateException(String.format("base path (%s) must be a directory for operation (%s)", basePath, ((MasterBenchParameters)this.mParameters).mOperation));
                    }
                }
                hdfsConf = new Configuration();
                hdfsConf.set(String.format("fs.%s.impl.disable.cache", new URI(((MasterBenchParameters)this.mParameters).mBasePath).getScheme()), "true");
                for (Map.Entry entry : ((MasterBenchParameters)this.mParameters).mConf.entrySet()) {
                    hdfsConf.set((String)entry.getKey(), (String)entry.getValue());
                }
                hdfsConf.set("alluxio.user.file.writetype.default", ((MasterBenchParameters)this.mParameters).mWriteType);
                if (((MasterBenchParameters)this.mParameters).mClientType != FileSystemClientType.ALLUXIO_HDFS) break block9;
                this.mCachedFs = new FileSystem[((MasterBenchParameters)this.mParameters).mClients];
                for (int i = 0; i < this.mCachedFs.length; ++i) {
                    this.mCachedFs[i] = FileSystem.get((URI)new URI(((MasterBenchParameters)this.mParameters).mBasePath), (Configuration)hdfsConf);
                }
                break block10;
            }
            if (((MasterBenchParameters)this.mParameters).mClientType != FileSystemClientType.ALLUXIO_NATIVE) break block10;
            InstancedConfiguration alluxioProperties = alluxio.conf.Configuration.copyGlobal();
            alluxioProperties.merge(HadoopConfigurationUtils.getConfigurationFromHadoop((Configuration)hdfsConf), Source.RUNTIME);
            this.mCachedNativeFs = new alluxio.client.file.FileSystem[((MasterBenchParameters)this.mParameters).mClients];
            boolean bl = false;
            while (var3_8 < this.mCachedNativeFs.length) {
                this.mCachedNativeFs[var3_8] = FileSystem.Factory.create((AlluxioConfiguration)alluxioProperties);
                ++var3_8;
            }
        }
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
    protected BenchThread getBenchThread(StressMasterBenchBase.BenchContext context, int index) {
        switch (((MasterBenchParameters)this.mParameters).mClientType) {
            case ALLUXIO_HDFS: {
                return new AlluxioHDFSBenchThread(context, this.mCachedFs[index % this.mCachedFs.length]);
            }
            case ALLUXIO_POSIX: {
                return new AlluxioFuseBenchThread(context);
            }
        }
        return new AlluxioNativeBenchThread(context, this.mCachedNativeFs[index % this.mCachedNativeFs.length]);
    }

    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
    protected StressMasterBenchBase.BenchContext getContext() {
        RateLimiter rateLimiter = RateLimiter.create((double)((MasterBenchParameters)this.mParameters).mTargetThroughput);
        return new StressMasterBenchBase.BenchContext(this, rateLimiter, ((MasterBenchParameters)this.mParameters).mOperation, ((MasterBenchParameters)this.mParameters).mDuration);
    }

    @Override
    public void validateParams() throws Exception {
    }

    private final class AlluxioFuseBenchThread
    extends BenchThread {
        java.nio.file.Path mFuseFixedBasePath;
        java.nio.file.Path mFuseBasePath;

        private AlluxioFuseBenchThread(StressMasterBenchBase.BenchContext context) {
            super(context);
            this.mFuseFixedBasePath = Paths.get(String.valueOf(this.mFixedBasePath), new String[0]);
            this.mFuseBasePath = Paths.get(String.valueOf(this.mBasePath), new String[0]);
            try {
                Files.createDirectories(this.mFuseFixedBasePath, new FileAttribute[0]);
                Files.createDirectories(this.mFuseBasePath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Failed to create directories %s %s", this.mFuseFixedBasePath, this.mFuseBasePath), e);
            }
        }

        /*
         * Unable to fully structure code
         */
        @Override
        @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
        protected void applyOperation(long counter) throws IOException {
            switch (1.$SwitchMap$alluxio$stress$master$Operation[((MasterBenchParameters)StressMasterBench.this.mParameters).mOperation.ordinal()]) {
                case 1: {
                    path = counter < (long)((MasterBenchParameters)StressMasterBench.this.mParameters).mFixedCount ? this.mFuseFixedBasePath.resolve(Long.toString(counter)) : this.mFuseBasePath.resolve(Long.toString(counter));
                    Files.createDirectories(path, new FileAttribute[0]);
                    break;
                }
                case 2: {
                    path = counter < (long)((MasterBenchParameters)StressMasterBench.this.mParameters).mFixedCount ? this.mFuseFixedBasePath.resolve(Long.toString(counter)) : this.mFuseBasePath.resolve(Long.toString(counter));
                    fileSize = FormatUtils.parseSpaceSize((String)((MasterBenchParameters)StressMasterBench.this.mParameters).mCreateFileSize);
                    stream = new FileOutputStream(String.valueOf(path));
                    var7_11 = null;
                    for (i = 0L; i < fileSize; i += 0x4000000L) {
                        stream.write(StressMasterBench.this.mFiledata, 0, (int)Math.min(0x4000000L, fileSize - i));
                    }
                    if (stream == null) break;
                    if (var7_11 == null) ** GOTO lbl24
                    try {
                        stream.close();
                    }
                    catch (Throwable i) {
                        var7_11.addSuppressed(i);
                    }
                    break;
lbl24:
                    // 1 sources

                    stream.close();
                    break;
                    catch (Throwable i) {
                        try {
                            var7_11 = i;
                            throw i;
                        }
                        catch (Throwable var10_17) {
                            if (stream != null) {
                                if (var7_11 != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (Throwable var11_18) {
                                        var7_11.addSuppressed(var11_18);
                                    }
                                } else {
                                    stream.close();
                                }
                            }
                            throw var10_17;
                        }
                    }
                }
                case 3: {
                    throw new UnsupportedOperationException("GET_BLOCK_LOCATIONS is not supported!");
                }
                case 4: {
                    path = this.mFuseFixedBasePath.resolve(Long.toString(counter %= (long)((MasterBenchParameters)StressMasterBench.this.mParameters).mFixedCount));
                    Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                    break;
                }
                case 5: {
                    dir = new File(this.mFuseFixedBasePath.toString());
                    files = dir.listFiles();
                    if (files != null && files.length == ((MasterBenchParameters)StressMasterBench.this.mParameters).mFixedCount) break;
                    throw new IOException(String.format("listing `%s` expected %d files but got %d files", new Object[]{this.mFuseFixedBasePath, ((MasterBenchParameters)StressMasterBench.this.mParameters).mFixedCount, files == null ? 0 : files.length}));
                }
                case 6: {
                    throw new UnsupportedOperationException("LIST_DIR_LOCATED is not supported!");
                }
                case 7: {
                    path = this.mFuseFixedBasePath.resolve(Long.toString(counter %= (long)((MasterBenchParameters)StressMasterBench.this.mParameters).mFixedCount));
                    new FileInputStream(path.toString()).close();
                    break;
                }
                case 8: {
                    if (counter < (long)((MasterBenchParameters)StressMasterBench.this.mParameters).mFixedCount) {
                        path = this.mFuseFixedBasePath.resolve(Long.toString(counter));
                        dst = this.mFuseFixedBasePath.resolve(counter + "-renamed");
                    } else {
                        path = this.mFuseBasePath.resolve(Long.toString(counter));
                        dst = this.mFuseBasePath.resolve(counter + "-renamed");
                    }
                    Files.move(path, dst, new CopyOption[0]);
                    break;
                }
                case 9: {
                    path = counter < (long)((MasterBenchParameters)StressMasterBench.this.mParameters).mFixedCount ? this.mFuseFixedBasePath.resolve(Long.toString(counter)) : this.mFuseBasePath.resolve(Long.toString(counter));
                    Files.delete(path);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown operation: " + ((MasterBenchParameters)StressMasterBench.this.mParameters).mOperation);
                }
            }
        }
    }

    private final class AlluxioNativeBenchThread
    extends BenchThread {
        private final alluxio.client.file.FileSystem mFs;

        private AlluxioNativeBenchThread(StressMasterBenchBase.BenchContext context, alluxio.client.file.FileSystem fs) {
            super(context);
            this.mFs = fs;
        }

        @Override
        @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
        protected void applyOperation(long counter) throws IOException, AlluxioException {
            StressMasterBench.this.applyNativeOperation(this.mFs, ((MasterBenchParameters)StressMasterBench.this.mParameters).mOperation, counter, this.mBasePath, this.mFixedBasePath, ((MasterBenchParameters)StressMasterBench.this.mParameters).mFixedCount);
        }
    }

    private final class AlluxioHDFSBenchThread
    extends BenchThread {
        private final FileSystem mFs;

        private AlluxioHDFSBenchThread(StressMasterBenchBase.BenchContext context, FileSystem fs) {
            super(context);
            this.mFs = fs;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
        protected void applyOperation(long counter) throws IOException {
            switch (1.$SwitchMap$alluxio$stress$master$Operation[((MasterBenchParameters)StressMasterBench.this.mParameters).mOperation.ordinal()]) {
                case 1: {
                    path = counter < (long)((MasterBenchParameters)StressMasterBench.this.mParameters).mFixedCount ? new Path(this.mFixedBasePath, Long.toString(counter)) : new Path(this.mBasePath, Long.toString(counter));
                    this.mFs.mkdirs(path);
                    break;
                }
                case 2: {
                    path = counter < (long)((MasterBenchParameters)StressMasterBench.this.mParameters).mFixedCount ? new Path(this.mFixedBasePath, Long.toString(counter)) : new Path(this.mBasePath, Long.toString(counter));
                    fileSize = FormatUtils.parseSpaceSize((String)((MasterBenchParameters)StressMasterBench.this.mParameters).mCreateFileSize);
                    stream = this.mFs.create(path);
                    var7_12 = null;
                    for (i = 0L; i < fileSize; i += 0x4000000L) {
                        stream.write(StressMasterBench.this.mFiledata, 0, (int)Math.min(0x4000000L, fileSize - i));
                    }
                    if (stream == null) break;
                    if (var7_12 == null) ** GOTO lbl24
                    try {
                        stream.close();
                    }
                    catch (Throwable i) {
                        var7_12.addSuppressed(i);
                    }
                    break;
lbl24:
                    // 1 sources

                    stream.close();
                    break;
                    catch (Throwable i) {
                        try {
                            var7_12 = i;
                            throw i;
                        }
                        catch (Throwable var10_18) {
                            if (stream != null) {
                                if (var7_12 != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (Throwable var11_19) {
                                        var7_12.addSuppressed(var11_19);
                                    }
                                } else {
                                    stream.close();
                                }
                            }
                            throw var10_18;
                        }
                    }
                }
                case 3: {
                    path = new Path(this.mFixedBasePath, Long.toString(counter %= (long)((MasterBenchParameters)StressMasterBench.this.mParameters).mFixedCount));
                    this.mFs.getFileBlockLocations(path, 0L, 0L);
                    break;
                }
                case 4: {
                    path = new Path(this.mFixedBasePath, Long.toString(counter %= (long)((MasterBenchParameters)StressMasterBench.this.mParameters).mFixedCount));
                    this.mFs.getFileStatus(path);
                    break;
                }
                case 5: {
                    files = this.mFs.listStatus(this.mFixedBasePath);
                    if (files.length == ((MasterBenchParameters)StressMasterBench.this.mParameters).mFixedCount) break;
                    throw new IOException(String.format("listing `%s` expected %d files but got %d files", new Object[]{this.mFixedBasePath, ((MasterBenchParameters)StressMasterBench.this.mParameters).mFixedCount, files.length}));
                }
                case 6: {
                    it = this.mFs.listLocatedStatus(this.mFixedBasePath);
                    listedFiles = 0;
                    while (it.hasNext()) {
                        it.next();
                        ++listedFiles;
                    }
                    if (listedFiles == ((MasterBenchParameters)StressMasterBench.this.mParameters).mFixedCount) break;
                    throw new IOException(String.format("listing located `%s` expected %d files but got %d files", new Object[]{this.mFixedBasePath, ((MasterBenchParameters)StressMasterBench.this.mParameters).mFixedCount, listedFiles}));
                }
                case 7: {
                    path = new Path(this.mFixedBasePath, Long.toString(counter %= (long)((MasterBenchParameters)StressMasterBench.this.mParameters).mFixedCount));
                    this.mFs.open(path).close();
                    break;
                }
                case 8: {
                    path = counter < (long)((MasterBenchParameters)StressMasterBench.this.mParameters).mFixedCount ? new Path(this.mFixedBasePath, Long.toString(counter)) : new Path(this.mBasePath, Long.toString(counter));
                    dst = new Path(path + "-renamed");
                    if (this.mFs.rename(path, dst)) break;
                    throw new IOException(String.format("Failed to rename (%s) to (%s)", new Object[]{path, dst}));
                }
                case 9: {
                    path = counter < (long)((MasterBenchParameters)StressMasterBench.this.mParameters).mFixedCount ? new Path(this.mFixedBasePath, Long.toString(counter)) : new Path(this.mBasePath, Long.toString(counter));
                    if (this.mFs.delete(path, false)) break;
                    throw new IOException(String.format("Failed to delete (%s)", new Object[]{path}));
                }
                default: {
                    throw new IllegalStateException("Unknown operation: " + ((MasterBenchParameters)StressMasterBench.this.mParameters).mOperation);
                }
            }
        }
    }

    protected abstract class BenchThread
    implements Callable<Void> {
        private final StressMasterBenchBase.BenchContext mContext;
        private final Histogram mResponseTimeNs;
        protected final Path mBasePath;
        protected final Path mFixedBasePath;
        private final MasterBenchTaskResult mResult = new MasterBenchTaskResult();

        private BenchThread(StressMasterBenchBase.BenchContext context) {
            this.mContext = context;
            this.mResponseTimeNs = new Histogram(1800000000000L, 3);
            this.mBasePath = this.mContext.getBasePath(0);
            this.mFixedBasePath = this.mContext.getFixedBasePath(0);
        }

        @Override
        @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
        public Void call() {
            try {
                this.runInternal();
            }
            catch (Exception e) {
                LOG.warn("Exception during bench thread runInternal", (Throwable)e);
                this.mResult.addErrorMessage(e.getMessage());
            }
            this.mResult.setEndMs(CommonUtils.getCurrentMs());
            this.mResult.getStatistics().encodeResponseTimeNsRaw(this.mResponseTimeNs);
            this.mResult.setParameters((MasterBenchBaseParameters)StressMasterBench.this.mParameters);
            this.mResult.setBaseParameters(StressMasterBench.this.mBaseParameters);
            this.mContext.mergeThreadResult(this.mResult);
            return null;
        }

        @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
        private void runInternal() throws IOException, AlluxioException {
            long recordMs = this.mContext.getStartMs() + FormatUtils.parseTimeSize((String)((MasterBenchParameters)StressMasterBench.this.mParameters).mWarmup);
            this.mResult.setRecordStartMs(recordMs);
            boolean useStopCount = ((MasterBenchParameters)StressMasterBench.this.mParameters).mStopCount != -1;
            long bucketSize = (this.mContext.getEndMs() - recordMs) / 20L;
            long waitMs = this.mContext.getStartMs() - CommonUtils.getCurrentMs();
            if (waitMs < 0L) {
                throw new IllegalStateException(String.format("Thread missed barrier. Increase the start delay. start: %d current: %d", this.mContext.getStartMs(), CommonUtils.getCurrentMs()));
            }
            CommonUtils.sleepMs((long)waitMs);
            while (!Thread.currentThread().isInterrupted() && (((MasterBenchParameters)StressMasterBench.this.mParameters).mOperation == Operation.LOAD_METADATA || ((MasterBenchParameters)StressMasterBench.this.mParameters).mOperation == Operation.CREATE_TREE || useStopCount || CommonUtils.getCurrentMs() < this.mContext.getEndMs())) {
                long localCounter = this.mContext.getOperationCounter(0).getAndIncrement();
                if (((MasterBenchParameters)StressMasterBench.this.mParameters).mOperation == Operation.CREATE_TREE && localCounter >= (long)StressMasterBench.this.mTreeTotalCount || ((MasterBenchParameters)StressMasterBench.this.mParameters).mOperation == Operation.LOAD_METADATA && localCounter >= (long)((MasterBenchParameters)StressMasterBench.this.mParameters).mThreads || useStopCount && localCounter >= (long)((MasterBenchParameters)StressMasterBench.this.mParameters).mStopCount) break;
                this.mContext.getGrandRateLimiter().acquire();
                long startNs = System.nanoTime();
                this.applyOperation(localCounter);
                long endNs = System.nanoTime();
                long currentMs = CommonUtils.getCurrentMs();
                if (currentMs <= recordMs) continue;
                this.mResult.incrementNumSuccess(1L);
                long responseTimeNs = endNs - startNs;
                this.mResponseTimeNs.recordValue(responseTimeNs);
                long[] maxResponseTimeNs = this.mResult.getStatistics().mMaxResponseTimeNs;
                int bucket = Math.min(maxResponseTimeNs.length - 1, (int)((currentMs - recordMs) / bucketSize));
                if (responseTimeNs <= maxResponseTimeNs[bucket]) continue;
                maxResponseTimeNs[bucket] = responseTimeNs;
            }
        }

        protected abstract void applyOperation(long var1) throws IOException, AlluxioException;
    }
}

