/*
 * Decompiled with CFR 0.152.
 */
package alluxio.stress.cli;

import alluxio.AlluxioURI;
import alluxio.annotation.SuppressFBWarnings;
import alluxio.exception.AlluxioException;
import alluxio.exception.FileAlreadyExistsException;
import alluxio.exception.UnexpectedAlluxioException;
import alluxio.grpc.Bits;
import alluxio.grpc.CreateDirectoryPOptions;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.DeletePOptions;
import alluxio.grpc.ListStatusPOptions;
import alluxio.grpc.LoadMetadataPType;
import alluxio.grpc.PMode;
import alluxio.grpc.SetAttributePOptions;
import alluxio.stress.cli.AbstractStressBench;
import alluxio.stress.cli.Benchmark;
import alluxio.stress.common.FileSystemClientType;
import alluxio.stress.master.MasterBenchBaseParameters;
import alluxio.stress.master.MasterBenchTaskResultBase;
import alluxio.stress.master.MasterBenchTaskResultStatistics;
import alluxio.stress.master.Operation;
import alluxio.util.CommonUtils;
import alluxio.util.FormatUtils;
import alluxio.util.executor.ExecutorServiceFactories;
import alluxio.util.io.PathUtils;
import com.google.common.util.concurrent.RateLimiter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StressMasterBenchBase<T extends MasterBenchTaskResultBase<P>, P extends MasterBenchBaseParameters>
extends AbstractStressBench<T, P> {
    private static final Logger LOG = LoggerFactory.getLogger(StressMasterBenchBase.class);
    protected byte[] mFiledata;
    protected FileSystem[] mCachedFs;
    protected alluxio.client.file.FileSystem[] mCachedNativeFs;
    protected final String mDirsDir = "dirs";
    protected final String mFilesDir = "files";
    protected final String mFixedDir = "fixed";
    protected int[] mPathNodeIds;
    protected int[] mTreeLevelNodeCount;
    protected int mTreeTotalNodeCount;

    protected StressMasterBenchBase(P parameters) {
        this.mParameters = parameters;
    }

    protected abstract BenchContext getContext() throws IOException, AlluxioException;

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
    protected void deletePaths(FileSystem fs, Path basePath) throws Exception {
        if (!fs.exists(basePath)) {
            return;
        }
        FileStatus[] subDirs = fs.listStatus(basePath);
        if (subDirs.length == 0) {
            return;
        }
        if (((MasterBenchBaseParameters)this.mParameters).mClientType == FileSystemClientType.ALLUXIO_HDFS) {
            fs.delete(basePath, true);
            if (fs.exists(basePath)) {
                throw new UnexpectedAlluxioException(String.format("Unable to delete the files in path %s.Please confirm whether it is HDFS file system. You may need to modify `--client-type` parameter", basePath));
            }
            return;
        }
        Path fixedPath = new Path(subDirs[0].getPath(), "fixed");
        int fixedSize = fs.exists(fixedPath) ? fs.listStatus(fixedPath).length : 0;
        long batchSize = 50000L;
        int deleteThreads = 256;
        ExecutorService service = ExecutorServiceFactories.fixedThreadPool((String)"bench-delete-thread", (int)deleteThreads).create();
        block0: for (FileStatus subDir : subDirs) {
            LOG.info("Cleaning up all files in: {}", (Object)subDir.getPath());
            AtomicLong globalCounter = new AtomicLong();
            Path fixedBase = new Path(subDir.getPath(), "fixed");
            long runningLimit = 0L;
            while (!Thread.currentThread().isInterrupted()) {
                AtomicLong success = new AtomicLong();
                long limit = runningLimit += batchSize;
                ArrayList<Callable<Void>> callables = new ArrayList<Callable<Void>>(deleteThreads);
                for (int i = 0; i < deleteThreads; ++i) {
                    callables.add(() -> {
                        while (!Thread.currentThread().isInterrupted()) {
                            long counter = globalCounter.getAndIncrement();
                            if (counter >= limit) {
                                globalCounter.getAndDecrement();
                                return null;
                            }
                            Path deletePath = counter < (long)fixedSize ? new Path(fixedBase, Long.toString(counter)) : new Path(subDir.getPath(), Long.toString(counter));
                            if (!fs.delete(deletePath, true)) continue;
                            success.getAndIncrement();
                        }
                        return null;
                    });
                }
                service.invokeAll(callables, 1L, TimeUnit.MINUTES);
                if (success.get() == 0L) continue block0;
                LOG.info("Removed {} files", (Object)success.get());
            }
        }
        service.shutdownNow();
        service.awaitTermination(10L, TimeUnit.SECONDS);
        LOG.info("Deleting base directory: {}", (Object)basePath);
        fs.delete(basePath, true);
    }

    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
    public T runLocal() throws Exception {
        ExecutorService service = ExecutorServiceFactories.fixedThreadPool((String)"bench-thread", (int)((MasterBenchBaseParameters)this.mParameters).mThreads).create();
        long fileSize = FormatUtils.parseSpaceSize((String)((MasterBenchBaseParameters)this.mParameters).mCreateFileSize);
        this.mFiledata = new byte[(int)Math.min(fileSize, 0x4000000L)];
        Arrays.fill(this.mFiledata, (byte)122);
        BenchContext context = this.getContext();
        ArrayList<Callable<Void>> callables = new ArrayList<Callable<Void>>(((MasterBenchBaseParameters)this.mParameters).mThreads);
        for (int i = 0; i < ((MasterBenchBaseParameters)this.mParameters).mThreads; ++i) {
            callables.add(this.getBenchThread(context, i));
        }
        LOG.info("Starting {} bench threads", (Object)callables.size());
        service.invokeAll(callables, FormatUtils.parseTimeSize((String)this.mBaseParameters.mBenchTimeout), TimeUnit.MILLISECONDS);
        LOG.info("Bench threads finished");
        service.shutdownNow();
        service.awaitTermination(30L, TimeUnit.SECONDS);
        if (!this.mBaseParameters.mProfileAgent.isEmpty()) {
            context.addAdditionalResult();
        }
        return context.getResult();
    }

    protected abstract Callable<Void> getBenchThread(BenchContext var1, int var2);

    /*
     * Unable to fully structure code
     */
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
    protected void applyNativeOperation(alluxio.client.file.FileSystem fs, Operation operation, long counter, Path basePath, Path fixedBasePath, int fixedCount) throws IOException, AlluxioException {
        block5 : switch (1.$SwitchMap$alluxio$stress$master$Operation[operation.ordinal()]) {
            case 1: {
                path = counter < (long)fixedCount ? new Path(fixedBasePath, Long.toString(counter)) : new Path(basePath, Long.toString(counter));
                fs.createDirectory(new AlluxioURI(path.toString()), CreateDirectoryPOptions.newBuilder().setRecursive(true).build());
                break;
            }
            case 2: {
                path = counter < (long)fixedCount ? new Path(fixedBasePath, Long.toString(counter)) : new Path(basePath, Long.toString(counter));
                fileSize = FormatUtils.parseSpaceSize((String)((MasterBenchBaseParameters)this.mParameters).mCreateFileSize);
                stream = fs.createFile(new AlluxioURI(path.toString()), CreateFilePOptions.newBuilder().setRecursive(true).build());
                var13_20 = null;
                for (i = 0L; i < fileSize; i += 0x4000000L) {
                    stream.write(this.mFiledata, 0, (int)Math.min(0x4000000L, fileSize - i));
                }
                if (stream == null) break;
                if (var13_20 == null) ** GOTO lbl23
                try {
                    stream.close();
                }
                catch (Throwable i) {
                    var13_20.addSuppressed(i);
                }
                break;
lbl23:
                // 1 sources

                stream.close();
                break;
                catch (Throwable i) {
                    try {
                        var13_20 = i;
                        throw i;
                    }
                    catch (Throwable var16_26) {
                        if (stream != null) {
                            if (var13_20 != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable var17_28) {
                                    var13_20.addSuppressed(var17_28);
                                }
                            } else {
                                stream.close();
                            }
                        }
                        throw var16_26;
                    }
                }
            }
            case 3: {
                path = new Path(fixedBasePath, Long.toString(counter %= (long)fixedCount));
                fs.getBlockLocations(new AlluxioURI(path.toString()));
                break;
            }
            case 4: {
                path = new Path(fixedBasePath, Long.toString(counter %= (long)fixedCount));
                fs.getStatus(new AlluxioURI(path.toString()));
                break;
            }
            case 5: {
                files = fs.listStatus(new AlluxioURI(fixedBasePath.toString()));
                if (files.size() == fixedCount) break;
                throw new IOException(String.format("listing `%s` expected %d files but got %d files", new Object[]{fixedBasePath, fixedCount, files.size()}));
            }
            case 6: {
                throw new UnsupportedOperationException("LIST_DIR_LOCATED is not supported!");
            }
            case 7: {
                path = new Path(fixedBasePath, Long.toString(counter %= (long)fixedCount));
                fs.openFile(new AlluxioURI(path.toString())).close();
                break;
            }
            case 8: {
                path = counter < (long)fixedCount ? new Path(fixedBasePath, Long.toString(counter)) : new Path(basePath, Long.toString(counter));
                dst = new Path(path + "-renamed");
                fs.rename(new AlluxioURI(path.toString()), new AlluxioURI(dst.toString()));
                break;
            }
            case 9: {
                path = counter < (long)fixedCount ? new Path(fixedBasePath, Long.toString(counter)) : new Path(basePath, Long.toString(counter));
                fs.delete(new AlluxioURI(path.toString()), DeletePOptions.newBuilder().setRecursive(false).build());
                break;
            }
            case 10: {
                path = new Path(basePath, Long.toString(counter));
                uri = new AlluxioURI(path.toString());
                fs.createFile(uri, CreateFilePOptions.newBuilder().setRecursive(true).build()).close();
                fs.delete(uri);
                break;
            }
            case 11: {
                path = counter < (long)fixedCount ? new Path(fixedBasePath, Long.toString(counter)) : new Path(basePath, Long.toString(counter));
                fs.setAttribute(new AlluxioURI(path.toString()), SetAttributePOptions.newBuilder().setMode(PMode.newBuilder().setOwnerBits(Bits.ALL).setGroupBits(Bits.ALL).setOtherBits(Bits.ALL).build()).build());
                break;
            }
            case 12: {
                path = new Path(basePath, Long.toString(counter));
                uri = new AlluxioURI(path.toString());
                fs.createFile(uri, CreateFilePOptions.newBuilder().setRecursive(true).build()).close();
                if (!fs.exists(uri)) {
                    throw new IOException("[INCONSISTENCY] file doesn't exist after creation");
                }
                fs.setAttribute(new AlluxioURI(path.toString()), SetAttributePOptions.newBuilder().setMode(PMode.newBuilder().setOwnerBits(Bits.ALL).setGroupBits(Bits.ALL).setOtherBits(Bits.ALL).build()).build());
                us = fs.getStatus(uri);
                if (us.getMode() != 511) {
                    throw new IOException("[INCONSISTENCY] file update doesn't reflect");
                }
                fs.delete(uri);
                if (!fs.exists(uri)) break;
                throw new IOException("[INCONSISTENCY] file still exists after deletion");
            }
            case 13: {
                fs.loadMetadata(new AlluxioURI(basePath + "/" + counter), ListStatusPOptions.newBuilder().setLoadMetadataType(LoadMetadataPType.ALWAYS).setRecursive(true).setLoadMetadataOnly(true).build());
                break;
            }
            case 14: {
                nodePath = "";
                nodeNumber = (int)counter;
                for (levelCount = 0; levelCount < ((MasterBenchBaseParameters)this.mParameters).mTreeDepth; ++levelCount) {
                    this.mPathNodeIds[levelCount] = nodeNumber / this.mTreeLevelNodeCount[levelCount];
                    nodeNumber %= this.mTreeLevelNodeCount[levelCount];
                    nodePath = nodePath + "/";
                    nodePath = nodePath + this.mPathNodeIds[levelCount];
                }
                for (fileNumber = 0; fileNumber < ((MasterBenchBaseParameters)this.mParameters).mTreeFiles; ++fileNumber) {
                    try {
                        fs.createFile(new AlluxioURI(basePath + nodePath + "/" + nodeNumber + "/" + fileNumber + ".txt"), CreateFilePOptions.newBuilder().setRecursive(true).build()).close();
                        continue;
                    }
                    catch (FileAlreadyExistsException e) {
                        break block5;
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unknown operation: " + operation);
            }
        }
    }

    protected String extractHostName(String mId) {
        String hostName = "";
        String[] splitedMid = mId.split("-");
        hostName = hostName + splitedMid[0];
        for (int i = 1; i < splitedMid.length - 1; ++i) {
            hostName = hostName + "-";
            hostName = hostName + splitedMid[i];
        }
        return hostName;
    }

    protected final class BenchContext {
        private final RateLimiter mGrandRateLimiter;
        private final RateLimiter[] mOperationRateLimiters;
        private final long mStartMs;
        private final long mEndMs;
        private final AtomicLong[] mOperationCounters;
        private final AtomicLong mTotalCounter;
        private final Path[] mBasePaths;
        private final Path[] mFixedBasePaths;
        private T mResult;

        @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
        BenchContext(RateLimiter grandRateLimiter, RateLimiter[] rateLimiters, Operation[] operations, String[] basePaths, String duration) {
            this.mGrandRateLimiter = grandRateLimiter;
            this.mOperationRateLimiters = rateLimiters;
            long durationMs = FormatUtils.parseTimeSize((String)duration);
            long warmupMs = FormatUtils.parseTimeSize((String)((MasterBenchBaseParameters)StressMasterBenchBase.this.mParameters).mWarmup);
            long startMs = StressMasterBenchBase.this.mBaseParameters.mStartMs;
            if (StressMasterBenchBase.this.mBaseParameters.mStartMs == -1L) {
                startMs = CommonUtils.getCurrentMs() + 1000L;
            }
            this.mStartMs = startMs;
            this.mEndMs = startMs + warmupMs + durationMs;
            this.mOperationCounters = new AtomicLong[operations.length];
            this.mTotalCounter = new AtomicLong();
            this.mBasePaths = new Path[operations.length];
            this.mFixedBasePaths = new Path[operations.length];
            StressMasterBenchBase.this.mPathNodeIds = new int[((MasterBenchBaseParameters)StressMasterBenchBase.this.mParameters).mTreeDepth];
            StressMasterBenchBase.this.mTreeLevelNodeCount = new int[((MasterBenchBaseParameters)StressMasterBenchBase.this.mParameters).mTreeDepth];
            StressMasterBenchBase.this.mTreeLevelNodeCount[((MasterBenchBaseParameters)StressMasterBenchBase.this.mParameters).mTreeDepth - 1] = ((MasterBenchBaseParameters)StressMasterBenchBase.this.mParameters).mTreeWidth;
            for (int levelCount = StressMasterBenchBase.this.mTreeLevelNodeCount.length - 2; levelCount >= 0; --levelCount) {
                StressMasterBenchBase.this.mTreeLevelNodeCount[levelCount] = StressMasterBenchBase.this.mTreeLevelNodeCount[levelCount + 1] * ((MasterBenchBaseParameters)StressMasterBenchBase.this.mParameters).mTreeWidth;
            }
            StressMasterBenchBase.this.mTreeTotalNodeCount = StressMasterBenchBase.this.mTreeLevelNodeCount[0] * ((MasterBenchBaseParameters)StressMasterBenchBase.this.mParameters).mTreeThreads;
            for (int i = 0; i < operations.length; ++i) {
                this.mOperationCounters[i] = new AtomicLong();
                this.mBasePaths[i] = operations[i] == Operation.CREATE_DIR ? new Path(PathUtils.concatPath((Object)basePaths[i], (Object[])new Object[]{"dirs", StressMasterBenchBase.this.mBaseParameters.mId})) : (operations[i] == Operation.CREATE_TREE || operations[i] == Operation.LOAD_METADATA ? new Path(PathUtils.concatPath((Object)basePaths[i], (Object)StressMasterBenchBase.this.extractHostName(StressMasterBenchBase.this.mBaseParameters.mId))) : new Path(PathUtils.concatPath((Object)basePaths[i], (Object[])new Object[]{"files", StressMasterBenchBase.this.mBaseParameters.mId})));
                this.mFixedBasePaths[i] = new Path(this.mBasePaths[i], "fixed");
                LOG.info("BenchContext: basePath: {}, fixedBasePath: {}", (Object)this.mBasePaths[i], (Object)this.mFixedBasePaths[i]);
            }
        }

        @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
        public BenchContext(RateLimiter rateLimiter, Operation operation, String duration) {
            this(rateLimiter, new RateLimiter[]{rateLimiter}, new Operation[]{operation}, new String[]{((MasterBenchBaseParameters)this$0.mParameters).mBasePath}, duration);
        }

        public RateLimiter[] getRateLimiters() {
            return this.mOperationRateLimiters;
        }

        public RateLimiter getGrandRateLimiter() {
            return this.mGrandRateLimiter;
        }

        public RateLimiter getRateLimiter(int index) {
            return this.mOperationRateLimiters[index];
        }

        public long getStartMs() {
            return this.mStartMs;
        }

        public long getEndMs() {
            return this.mEndMs;
        }

        public AtomicLong getOperationCounter(int index) {
            return this.mOperationCounters[index];
        }

        AtomicLong getTotalCounter() {
            return this.mTotalCounter;
        }

        public Path getBasePath(int index) {
            return this.mBasePaths[index];
        }

        Path[] getBasePaths() {
            return this.mBasePaths;
        }

        Path[] getFixedPaths() {
            return this.mFixedBasePaths;
        }

        public Path getFixedBasePath(int index) {
            return this.mFixedBasePaths[index];
        }

        public synchronized void mergeThreadResult(T threadResult) {
            if (this.mResult == null) {
                this.mResult = threadResult;
                return;
            }
            try {
                this.mResult.merge(threadResult);
            }
            catch (Exception e) {
                LOG.warn("Exception during result merge", (Throwable)e);
                this.mResult.addErrorMessage(e.getMessage());
            }
        }

        @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
        public synchronized void addAdditionalResult() throws IOException {
            if (this.mResult == null) {
                return;
            }
            Map<String, Benchmark.MethodStatistics> nameStatistics = StressMasterBenchBase.this.processMethodProfiles(this.mResult.getRecordStartMs(), this.mResult.getEndMs(), profileInput -> {
                String method = profileInput.getMethod();
                if (profileInput.getType().contains("RPC")) {
                    int classNameDivider = profileInput.getMethod().lastIndexOf(".");
                    method = profileInput.getMethod().substring(classNameDivider + 1);
                }
                return profileInput.getType() + ":" + method;
            });
            for (Map.Entry<String, Benchmark.MethodStatistics> entry : nameStatistics.entrySet()) {
                MasterBenchTaskResultStatistics stats = new MasterBenchTaskResultStatistics();
                stats.encodeResponseTimeNsRaw(entry.getValue().getTimeNs());
                stats.mNumSuccesses = entry.getValue().getNumSuccess();
                stats.mMaxResponseTimeNs = entry.getValue().getMaxTimeNs();
                this.mResult.putStatisticsForMethod(entry.getKey(), stats);
            }
        }

        public synchronized T getResult() {
            return this.mResult;
        }
    }
}

